#version 330 core

in vec2 UV;
uniform sampler2D colors;
uniform sampler2D refls;
uniform float decay;

// outputz
out vec4 color;

float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}

void main() {
	const int samples = 14;
	for(int i = 0; i < samples; i++){
		vec4 rd = texture(refls, UV + (-0.009+0.018*vec2( hash(float(i)), hash(float(-i*2.3+1.9))) ) );
    	color  += mix(texture(colors, UV), vec4(texture(colors, rd.xy).xyz, 1.0), vec4(exp(decay*rd.z)) );	
	}
    color /= float(samples);
}
