#version 440 core
#pragma stage vertex

layout(location = 0) in vec2  attrPosition;
layout(location = 1) in vec2  aParticlePos;
layout(location = 2) in vec4  aParticleColor;
layout(location = 3) in float aParticleAge;
layout(location = 4) in float aParticleLifespan;
layout(location = 5) in uint  aParticleAlive;

uniform vec2  uCameraPosition;
uniform float uCameraScale;
uniform float uSpriteLayer;
uniform float uSpriteScale;
uniform float uParallaxScale;
uniform vec2  uScreenSize;

out flat vec4  vColor;
out flat float vAge;
out flat float vLifespan;
out flat uint  vAlive;

out gl_PerVertex { vec4 gl_Position; };

void main()
{
	vec2 spritePosition = floor(aParticlePos);
	vec2 cameraPosition = floor(uCameraPosition);

	vec2 spritePos = attrPosition * (vec2(1.0) / uScreenSize) * uSpriteScale;       // Scale and size of the sprite in screen pixels
	spritePos -= vec2(1.0);                                                         // Origin is at bottom-left
	spritePos += 2.0 * (spritePosition / uScreenSize);                              // Offset sprite to its screen position in pixels

	vec2 camPos = 2.0 * (cameraPosition / uScreenSize) - vec2(1.0);                 // Compute camera position in 2D world space
	spritePos -= camPos;                                                            // Offset sprite by the inverse of the camera position

	spritePos *= uCameraScale;                                                      // Offset sprite by the camera zoom scale (<1.0 = dezoom, >1.0 = zoom)
	
	vec2 deltaPos = spritePosition - cameraPosition;
	spritePos += deltaPos * uParallaxScale * uSpriteLayer * uCameraScale;           // Correct sprite position by parallax influence

	gl_Position = vec4(spritePos, 0.0, 1.0);

	vColor    = aParticleColor;
	vAge      = aParticleAge;
	vLifespan = aParticleLifespan;
	vAlive    = aParticleAlive;
}
