Game.extend = function(src, dest) {
    // Create a copy of the source.
    var result = {};
    for (var key in src)
        result[key] = src[key];
		
    // Copy over all keys from dest
    for (var key in dest)
        result[key] = dest[key];
		
    return result;
};

Game.modalAnnounce = function(msg) {
	document.getElementById("modalContainerInner").innerHTML = msg;
	
	if($('#modalOverlay').is(':visible'))
		return;
		
	//$('#modalOverlay').fadeIn(500);
	//$('#modalContainer').animate({'top':'100px'},500);
	$('#modalOverlay').show();
	$('#modalContainer').show();
	$('#modalContainer').css({'top':'100px'});
}

Game.closeModalAnnounce = function() {
	//$('#modalContainer').animate({'top':'-1000px'},500);
	//$('#modalOverlay').fadeOut(500);
	$('#modalOverlay').hide();
	$('#modalContainer').hide();
}

Game.randomMessage = function(messages) {
   return messages[Math.floor(Math.random() * messages.length)];
}

Game.getRandomInt = function(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

Game.getRandomFloat = function(min, max) {
    return Math.random() * (max - min) + min;
}

Game.distanceBetween = function(x1,y1,x2,y2) {
    var xs = x2 - x1;
	xs *= xs;
	var ys = y2 - y1;
	ys *= ys;
	return Math.sqrt(xs+ys);
}

Game.capitaliseFirstLetter = function(string) {
	return string.charAt(0).toUpperCase() + string.slice(1);
}

Game.levelToFeet = function(level) {
	return 100.0+level*100.0;
}