Game.ItemRepository = new Game.Repository('items', Game.Item);

Game.ItemRepository.Symbol = {
	//'food': '&#127826;',
	'food': '=',
	//'tool': String.fromCharCode(172), // 172 logical not
};

// Edibles
Game.ItemRepository.define('cherry', {
    name: 'cherry',
    character: Game.ItemRepository.Symbol['food'],
    foreground: 'red',
    foodValue: 35,
    mixins: [Game.ItemMixins.Edible]
});

Game.ItemRepository.define('orange', {
    name: 'orange',
    character: Game.ItemRepository.Symbol['food'],
    foreground: 'orange',
    foodValue: 50,
    mixins: [Game.ItemMixins.Edible]
});

Game.ItemRepository.define('food ration', {
    name: 'food ration',
    character: Game.ItemRepository.Symbol['food'],
    foreground: 'khaki',
    foodValue: 75,
    consumptions: 4,
    mixins: [Game.ItemMixins.Edible]
});

Game.ItemRepository.define('corpse', {
    name: 'corpse',
    character: '%',
    foodValue: 50,
    consumptions: 1,
    mixins: [Game.ItemMixins.Edible]
}, {
    disableRandomCreation: true
});

Game.ItemRepository.define('rock', {
    name: 'rock',
    character: '*',
    foreground: 'white'
});

Game.ItemRepository.define('Scenepoint', {
    name: 'Scenepoint',
    character: 'o',
    foreground: 'yellow'
});

// Weapons
Game.ItemRepository.define('dagger', {
    name: 'dagger',
    character: ')',
    foreground: 'gray',
    attackValue: 5,
    wieldable: true,
    mixins: [Game.ItemMixins.Equippable]
}, {
    disableRandomCreation: true
});

Game.ItemRepository.define('sword', {
    name: 'sword',
    character: ')',
    foreground: 'white',
    attackValue: 10,
    wieldable: true,
    mixins: [Game.ItemMixins.Equippable]
}, {
    disableRandomCreation: true
});

Game.ItemRepository.define('staff', {
    name: 'staff',
    character: ')',
    foreground: 'yellow',
    attackValue: 5,
    defenseValue: 3,
    wieldable: true,
    mixins: [Game.ItemMixins.Equippable]
}, {
    disableRandomCreation: true
});

// Wearables
Game.ItemRepository.define('tunic', {
    name: 'tunic',
    character: '[',
    foreground: 'green',
    defenseValue: 1,
    wearable: true,
    mixins: [Game.ItemMixins.Equippable]
}, {
    disableRandomCreation: true
});

Game.ItemRepository.define('suit of leather armour', {
    name: 'suit of leather armour',
    character: '[',
    foreground: 'brown',
    defenseValue: 2,
    wearable: true,
    mixins: [Game.ItemMixins.Equippable]
}, {
    disableRandomCreation: true
});

Game.ItemRepository.define('suit of chainmail', {
    name: 'suit of chainmail',
    character: '[',
    foreground: 'white',
    defenseValue: 4,
    wearable: true,
    mixins: [Game.ItemMixins.Equippable]
}, {
    disableRandomCreation: true
});

Game.ItemRepository.define('suit of plate armour', {
    name: 'suit of plate armour',
    character: '[',
    foreground: 'aliceblue',
    defenseValue: 8,
    wearable: true,
    mixins: [Game.ItemMixins.Equippable]
}, {
    disableRandomCreation: true
});
