Game.State.TargetBasedState = function(template) {
    template = template || {};
    
    this._isAcceptableFunction = template['okFunction'] || function(x, y) {	// By default, our ok return does nothing and does not consume a turn
        return false;
    };
    
    this._captionFunction = template['captionFunction'] || function(x, y) {	// The defaut caption function simply returns an empty string
        return '';
    }
};

Game.State.TargetBasedState.prototype.setup = function(player, startX, startY, offsetX, offsetY) {
    this._player = player;
    this._startX = startX - offsetX;							// Store original position. Subtract the offset to make life easy so we don't always have to remove it.
    this._startY = startY - offsetY;
    this._cursorX = this._startX;								// Store current cursor position
    this._cursorY = this._startY;
    this._offsetX = offsetX;									// Store map offsets
    this._offsetY = offsetY;
    
    var visibleCells = {};										// Cache the FOV
    this._player.getMap().getFov(this._player.getZ()).compute(
        this._player.getX(), this._player.getY(), 
        this._player.getSightRadius(), 
        function(x, y, radius, visibility) {
            visibleCells[x + "," + y] = true;
        });
    this._visibleCells = visibleCells;
};

Game.State.TargetBasedState.prototype.render = function() {
    Game.State.PlayState.renderTiles.call(Game.State.PlayState);
    var points = Game.Geometry.getLine(this._startX, this._startY, this._cursorX, this._cursorY);	// Draw a line from the start to the cursor.
    for (var i = 0, l = points.length; i < l; i++)													// Render stars along the line
        display.drawText(points[i].x, points[i].y, '%c{magenta}*');
    display.drawText(0, RotEngine.getConsoleHeight() - 1, this._captionFunction(this._cursorX + this._offsetX, this._cursorY + this._offsetY));	// Render the caption at the bottom.
};

Game.State.TargetBasedState.prototype.handleInput = function(inputType, inputData) {
    // Move the cursor
    if (inputType == 'keydown') {
        if (inputData.keyCode === ROT.VK_LEFT)
            this.moveCursor(-1, 0);
        else if (inputData.keyCode === ROT.VK_RIGHT)
            this.moveCursor(1, 0);
        else if (inputData.keyCode === ROT.VK_UP)
            this.moveCursor(0, -1);
        else if (inputData.keyCode === ROT.VK_DOWN)
            this.moveCursor(0, 1);
        else if (inputData.keyCode === ROT.VK_ESCAPE)
            Game.State.PlayState.setSubState(undefined);
        else if (inputData.keyCode === ROT.VK_RETURN)
            this.executeOkFunction();
    }
    Game.refresh();
};

Game.State.TargetBasedState.prototype.moveCursor = function(dx, dy) {
    this._cursorX = Math.max(0, Math.min(this._cursorX + dx, RotEngine.getConsoleWidth()));		// Make sure we stay within bounds.
    this._cursorY = Math.max(0, Math.min(this._cursorY + dy, RotEngine.getConsoleHeight() - 1));	// We have to save the last line for the caption.
};

Game.State.TargetBasedState.prototype.executeOkFunction = function() {
    Game.State.PlayState.setSubState(undefined);											// Switch back to the play state.
    if (this._okFunction(this._cursorX + this._offsetX, this._cursorY + this._offsetY))		// Call the OK function and end the player's turn if it return true.
        this._player.getMap().getEngine().unlock();
};
