THREE.DungeonShader = {
	uniforms: {
		"diffuse": { type: "t", value: null },
		"multimap": { type: "t", value: null },
		"flicker": { type: "f", value: 1}
	},
	vertexShader: [
		"varying vec2 vUv;",
		"varying float worldY;",
		"void main() {",
			"vUv = uv;",
			"vec4 worldPos = modelMatrix * vec4(position, 1.);",
			"worldY = worldPos.y;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.);",
		"}"
	].join("\n"),
	fragmentShader: [
		"uniform sampler2D diffuse, multimap;",
		"uniform float flicker;",
		"varying vec2 vUv;",
		"varying float worldY;",
		"void main() {",
			"vec3 texel = texture2D(diffuse, vUv).rgb, muxel = texture2D(multimap, vUv).rgb;",
			"float lightBase=muxel.r, vis=muxel.g, height=muxel.b*255.;",
			
			//"gl_FragColor = vec4(muxel,1.);return;",
			
			"if(worldY>0.1 && (worldY>height || length(texel)<.001))",						// If this isn't the bottom layer, apply chromakey and max height checks
				"discard;",
			"else{",
				"if(vis<.1){",																// Pass no-fov area straight through - diffuse map has its final colour
					"gl_FragColor = vec4(texel,1.);",
					"return;",
				"}",
				"vec3 lightTorch = (1.2 + flicker) * mix(vec3(1.,.9,.6), vec3(1.), flicker);",	// If we got here, do torchlight and render the frag.
				"gl_FragColor = vec4(texel * lightBase * lightTorch, 1.);",
			"}",
		"}"
	].join("\n")

};
