THREE.DamageFlashShader = {
	uniforms: {
		"tDiffuse": { type: "t", value: null },
		"amount":   { type: "f", value: 0 },
	},
	vertexShader: [
		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);",
		"}"
	].join("\n"),
	fragmentShader: [
		"uniform sampler2D tDiffuse;",
		"uniform float amount;",
		"varying vec2 vUv;",
		"void main(){",
			"vec3 texel = texture2D(tDiffuse, vUv).rgb;",
			"gl_FragColor = vec4(min(vec3(1.),texel+vec3(.7,0.,0.)*amount),1.);",
		"}"
	].join("\n")
};
