Game.Map.Cave = function(tiles, player) {
    Game.Map.call(this, tiles);							// Call the Map constructor
    this.addEntityAtRandomPosition(player, 0);			// Add the player
    
    for (var z = 0; z < this._depth; z++) {				// Add random entities and items to each floor
        for (var i = 0; i < 15; i++) {					// 15 entities per floor
            var entity = Game.EntityRepository.createRandom();
            this.addEntityAtRandomPosition(entity, z);	// Add a random entity
            if (entity.hasMixin('ExperienceGainer'))	// Level up the entity based on the floor
                for (var level = 0; level < z; level++)
                    entity.giveExperience(entity.getNextLevelExperience() - entity.getExperience());
        }
		
        for (var i = 0; i < 15; i++) 					// 15 random items/floor
            this.addItemAtRandomPosition(Game.ItemRepository.createRandom(), z);
    }
	
    // Add weapons and armor to the map in random positions and floors
    var templates = ['dagger', 'sword', 'staff', 'tunic', 'suit of leather armour', 'suit of chainmail', 'suit of plate armour'];
    for (var i = 0; i < templates.length; i++) {
        this.addItemAtRandomPosition(Game.ItemRepository.create(templates[i]), Math.floor(this._depth * Math.random()));
		this.addItemAtRandomPosition(Game.ItemRepository.create(templates[i]), Math.floor(this._depth * Math.random()));
	}
    
    // Add a hole to the final cavern on the last level
    var holePosition = this.getRandomFloorPosition(this._depth - 1);
    this._tiles[this._depth - 1][holePosition.x][holePosition.y] = Game.Tile.holeToCavernTile;
};
Game.Map.Cave.extend(Game.Map);
