import pygame, math, random, vector
from pygame.locals import *
from entity import Entity
from config import Config

class Star:

    def __init__(self):
        self.Position = [0,1000000]
        self.Radius = 1

    def Spawn(self, _position, _radius):
        self.Position = _position
        self.Radius = _radius

        color = random.randrange(50,200)
        self.Color = (color,color,color)

    def IsDead(self):
        realYPosition = self.Position[1] - Entity.Offset
        if realYPosition > Config.WINDOWHEIGHT + self.Radius:
            return True
        return False

    def Draw(self, _screen):
        realYPosition = self.Position[1] - Entity.Offset
        if realYPosition < -self.Radius:
            return

        if realYPosition > self.Radius + Config.WINDOWHEIGHT:
            return

        pygame.draw.circle(_screen, self.Color, [self.Position[0], int(realYPosition)], self.Radius)