import pygame, sys, math, random, vector, utils, statemanager
from pygame.locals import *
from letter import Letter
from asteroid import Asteroid
from config import Config

class Intro:

    def Init(self, _payload):
        self.Asteroid = Asteroid()
        self.Asteroid.Spawn(
                [-400,-400], #position
                [100,100], #velocity
                Config.ASTEROIDMAXRADIUS, #radius
                3) #rotationSpeed

        self.Letters = []
        self.Letters.append( Letter( [0,0], [0.5,1], False, Config.INTRO_LETTER_S))
        self.Letters.append( Letter( [2,0], [0.5,1], False, Config.INTRO_LETTER_t))
        self.Letters.append( Letter( [3,0], [0.5,0.75], False, Config.INTRO_LETTER_e))
        self.Letters.append( Letter( [4.5,0], [0.5,0.75], False, Config.INTRO_LETTER_r))
        self.Letters.append( Letter( [5.5,0], [0.5,0.75], True, Config.INTRO_LETTER_o))
        self.Letters.append( Letter( [7,0], [0.1,0.75], False, Config.INTRO_LETTER_i))
        self.Letters.append( Letter( [8,0], [0.5,1], True, Config.INTRO_LETTER_D))

        self.inputTimer = 2

        self.Font = pygame.font.SysFont("monospace", 24)

        self.IsInitialized = True

    def Reset(self):

        del self.Asteroid
        for letter in self.Letters:
            del letter

        self.IsInitialized = False

    def Input(self, _fTime, _screen, _anyKeyDown):

        if not self.IsInitialized:
            return

        if self.inputTimer <= 0:
            if _anyKeyDown:
                statemanager.Set(1)

    def Update(self, _fTime):

        if not self.IsInitialized:
            return

        if self.inputTimer > 0:
            self.inputTimer -= _fTime

        self.Asteroid.Update(_fTime)

        for letter in self.Letters:
            letter.Update(_fTime)

            if utils.IsCollision(self.Asteroid.Entity, letter.Entity):
                utils.Collide(self.Asteroid.Entity, letter.Entity)

    def Draw(self, _screen):

        if not self.IsInitialized:
            return

        self.Asteroid.Draw(_screen)
        for letter in self.Letters:
            letter.Draw(_screen)

        pygame.draw.line(_screen, Config.RED, [120, 300], [Config.WINDOWWIDTH,300], 5)

        label = self.Font.render("k2/Revision 2016", 1, Config.WHITE)
        _screen.blit(label, (Config.WINDOWWIDTH-230, 306))


