import pygame
from pygame.locals import *
from config import Config

class Fuel:

    def __init__(self):
        self.Refill()

    def Boost(self, _fTime):
        self.Amount -= Config.FUELBOOSTCONSUMPTION * _fTime
        if self.Amount < 0:
            self.Amount = 0

    def Consume(self, _amount):
        self.Amount -= _amount
        if self.Amount < 0:
            self.Amount = 0

    def TimeSlow(self, _fTime):
        self.Consume(Config.FUELTIMESLOWCONSUMPTION * _fTime)

    def Collision(self, _radius):
        self.Consume(Config.FUELCOLLISIONCONSUMPTION * _radius)

    def TimeOver(self, _fTime):
        self.Consume(Config.FUELTIMEOVERCONSUMPTION * _fTime)

    def Refill(self):
        self.Amount = Config.FUELMAX

    def IsEmpty(self):
        return self.Amount <= 0

    def Draw(self, _screen):

        color = Config.GREEN
        fillAmount = self.Amount / Config.FUELMAX
        if fillAmount < 0.25:
            color = Config.RED

        pygame.draw.rect(_screen, color, [
            Config.FUEL_X,
            Config.FUEL_Y,
            Config.FUEL_WIDTH,
            Config.FUEL_HEIGHT], 2)

        pygame.draw.rect(_screen, color, [
            Config.FUEL_X,
            Config.FUEL_Y,
            Config.FUEL_WIDTH * fillAmount,
            Config.FUEL_HEIGHT])