import pygame, math, random, vector
from pygame.locals import *
from entity import Entity
from config import Config

class Asteroid:

    def __init__(self):
        points = []

        pointCount = random.randrange(Config.ASTEROIDMINPOINTS,Config.ASTEROIDMAXPOINTS)
        for i in range(0, pointCount):
            angle = float(i)/float(pointCount) * 6.28
            distance = random.uniform(Config.ASTEROIDMINPOINTDISTANCE, Config.ASTEROIDMAXPOINTDISTANCE)
            points.append([math.sin(angle)*distance,math.cos(angle)*distance])

        self.Entity = Entity([0,1000000], 1, points)
        self.RotationSpeed = 0

    def Spawn(self, _position, _velocity, _scale, _rotationSpeed):
        self.Entity.Position = _position
        self.Entity.Velocity = _velocity
        self.Entity.Scale = _scale
        self.Entity.Radius = _scale
        self.RotationSpeed = _rotationSpeed

    def IsDead(self):
        realYPosition = self.Entity.Position[1] - Entity.Offset
        if realYPosition > Config.ASTEROIDLIMIT:
            return True
        return False

    def Update(self, _fTime):
        self.Entity.Rotation += self.RotationSpeed * _fTime
        self.Entity.Update(_fTime)

    def Draw(self, _screen):
        self.Entity.Draw(_screen)

    def DrawMarker(self, _screen):
        realYPosition = self.Entity.Position[1] - Entity.Offset

        if realYPosition > 0:
            return

        modifier = 1 + realYPosition/Config.SENSORRANGE
        if modifier < 0:
            modifier = 0
        elif modifier > 1:
            modifier = 1

        size = int(self.Entity.Radius*2)

        rect = [
            int(self.Entity.Position[0])-size/2 + Entity.Shake[0],
            Entity.Shake[1],
            size,
            int(48 * modifier)]
        pygame.draw.rect(_screen, vector.multiplyColor(Config.GREEN, modifier), rect, 4)