"use strict";var demo={params:null,configs:null,fogs:null,spotlights:null,pointlights:null,atmospheres:null,materials:null,textures:null,objects:null,cameras:null,scenes:null,timeline:null},Diwe;!function(e){var t=angular.module("Diwe",[]);t.directive("diwe",function(){return{restrict:"A",templateUrl:"views/diwe.html"}}),t.directive("diweSystem",function(){return{restrict:"A",templateUrl:"views/system.html",controller:"SystemController",controllerAs:"system"}}),t.directive("diweSetup",function(){return{restrict:"A",templateUrl:"views/setup.html",controller:"SetupController",controllerAs:"setup"}}),t.directive("diweDemo",function(){return{restrict:"A",templateUrl:"views/demo.html",controller:"DemoController",controllerAs:"demo"}}),t.directive("diweSidebar",function(){return{restrict:"A",templateUrl:"views/sidebar.html",controller:"SidebarController",controllerAs:"sidebar"}}),t.directive("diweBottombar",function(){return{restrict:"A",templateUrl:"views/bottombar.html",controller:"BottombarController",controllerAs:"bottombar"}}),t.directive("diweTimeline",function(){return{restrict:"A",templateUrl:"views/timeline.html",controller:"TimelineController",controllerAs:"timeline"}}),t.directive("diweFog",function(){return{restrict:"A",templateUrl:"views/fog.html",controller:"FogController",controllerAs:"ctrl",scope:{fog:"=",demo:"=",sound:"="}}}),t.directive("diweLight",function(){return{restrict:"A",templateUrl:"views/light.html",controller:"LightController",controllerAs:"ctrl",scope:{light:"=",demo:"=",sound:"="}}}),t.directive("diweMesh",function(){return{restrict:"A",templateUrl:"views/mesh.html",controller:"MeshController",controllerAs:"ctrl",scope:{mesh:"="}}}),t.directive("diweCamera",function(){return{restrict:"A",templateUrl:"views/camera.html",controller:"CameraController",controllerAs:"ctrl",scope:{cam:"="}}}),t.directive("diweEffect",function(){return{restrict:"A",templateUrl:"views/effect.html",controller:"EffectController",controllerAs:"ctrl",scope:{name:"=",effect:"="}}}),t.directive("diweMaterial",function(){return{restrict:"A",templateUrl:"views/material.html",controller:"MaterialController",controllerAs:"ctrl",scope:{material:"="}}}),t.directive("diweTexture",function(){return{restrict:"A",templateUrl:"views/texture.html",controller:"TextureController",controllerAs:"ctrl",scope:{texture:"="}}})}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.config=e,this.demo=t,this.sound=i}return e.prototype.seek=function(){this.demo.animateScene(!0)},e}(),i=angular.module("Diwe");i.controller("BottombarController",["ConfigService","DemoService","SoundService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.scope=e,this.timeline=t,this.params=i;var r=this;this.scope.$watch("cam.fov",function(){r.scope.cam.updateProjectionMatrix()}),this.scope.$watch("cam.zoom",function(){r.scope.cam.updateProjectionMatrix()}),this.scope.$watch("cam.far",function(){r.scope.cam.updateProjectionMatrix()}),this.scope.$watch("cam.near",function(){r.scope.cam.updateProjectionMatrix()})}return Object.defineProperty(e.prototype,"lookAt",{get:function(){var e=this.scope.cam.getWorldDirection();return e},enumerable:!0,configurable:!0}),e.prototype.keyframeAdd=function(){var e={cameras:{}},t=this.scope.cam;e.cameras[t.name]=this.params.getParams(t,t.type),this.timeline.keyframeAdd(e)},e.prototype.keyframeDelete=function(){var e=this.scope.cam;this.timeline.keyframeDelete("cameras",e.name)},e}(),i=angular.module("Diwe");i.controller("CameraController",["$scope","TimelineService","ParamsService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.config=e,this.demo=t,this.params=i}return e}(),i=angular.module("Diwe");i.controller("DemoController",["ConfigService","DemoService","ParamsService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.scope=e,this.timeline=t,this.params=i}return e.prototype.keyframe=function(e){var t={effects:{}},i=this.scope.effect,r=e[0].toUpperCase()+e.slice(1)+"Effect";t.effects[e]=this.params.getParams(i,r),this.timeline.keyframeAdd(t)},e.prototype.keyframeDelete=function(e){this.timeline.keyframeDelete("effects",e)},Object.defineProperty(e.prototype,"uniformsColor",{get:function(){return"#"+this.scope.effect.uniforms.color.value.getHexString()},set:function(e){this.scope.effect.uniforms.color.value=new THREE.Color(e)},enumerable:!0,configurable:!0}),e}(),i=angular.module("Diwe");i.controller("EffectController",["$scope","TimelineService","ParamsService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.scope=e,this.timeline=t,this.params=i}return e.prototype.keyframeAdd=function(){var e={fog:{}},t=this.scope.fog;e.fog=this.params.getParams(t,t.type),this.timeline.keyframeAdd(e)},e.prototype.keyframeDelete=function(){this.timeline.keyframeDelete("fog",null)},Object.defineProperty(e.prototype,"color",{get:function(){return"#"+this.scope.fog.color.getHexString()},set:function(e){this.scope.fog.color=new THREE.Color(e)},enumerable:!0,configurable:!0}),e}(),i=angular.module("Diwe");i.controller("FogController",["$scope","TimelineService","ParamsService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.scope=e,this.timeline=t,this.params=i}return e.prototype.keyframeAdd=function(){var e={lights:{}},t=this.scope.light;e.lights[t.name]=this.params.getParams(t,t.type),this.timeline.keyframeAdd(e)},e.prototype.keyframeDelete=function(){var e=this.scope.light;this.timeline.keyframeDelete("lights",e.name)},Object.defineProperty(e.prototype,"color",{get:function(){return"#"+this.scope.light.color.getHexString()},set:function(e){this.scope.light.color=new THREE.Color(e)},enumerable:!0,configurable:!0}),e}(),i=angular.module("Diwe");i.controller("LightController",["$scope","TimelineService","ParamsService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t){this.scope=e,this.texture=t,this.constants={combine:{multiply:THREE.MultiplyOperation,mix:THREE.MixOperation,add:THREE.AddOperation},shading:{smooth:THREE.SmoothShading,flat:THREE.FlatShading},blending:{no:THREE.NoBlending,normal:THREE.NormalBlending,additive:THREE.AdditiveBlending,subtractive:THREE.SubtractiveBlending,multiply:THREE.MultiplyBlending,custom:THREE.CustomBlending},side:{front:THREE.FrontSide,back:THREE.BackSide,"double":THREE.DoubleSide},vertexcolors:{nocolors:THREE.NoColors,facecolors:THREE.FaceColors,vertexcolors:THREE.VertexColors}}}return e.prototype.changeTexture=function(e,t){if(!this.scope.material[t]||this.scope.material[t].name!=e)switch(this.scope.material.needsUpdate=!0,t){case"envMap":this.scope.material[t]=this.texture.get(e);break;default:this.scope.material[t]=this.texture.get(e)}},e}(),i=angular.module("Diwe");i.controller("MaterialController",["$scope","TextureService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i,r){this.scope=e,this.timeline=t,this.params=i,this.material=r}return e.prototype.keyframe=function(e){var t={objects:{}},i=this.scope.mesh,r=this.params.getParams(i,i.type);r.material=r.material.name,t.objects[e]=r,this.timeline.keyframeAdd(t)},e.prototype.keyframeDelete=function(e){this.timeline.keyframeDelete("objects",e)},e.prototype.changeMaterial=function(e){this.scope.mesh.material&&this.scope.mesh.material.name==e||(this.scope.mesh.material=this.material.get(e))},e}(),i=angular.module("Diwe");i.controller("MeshController",["$scope","TimelineService","ParamsService","MaterialService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i,r,n){this.window=e,this.config=t,this.diwe=i,this.demo=r,this.params=n}return Object.defineProperty(e.prototype,"available",{get:function(){return this.diwe.requirements},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"offline",{get:function(){return"dilemma.ws"!=this.window.location.hostname},enumerable:!0,configurable:!0}),e}(),i=angular.module("Diwe");i.controller("SetupController",["$window","ConfigService","SystemService","DemoService","ParamsService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i,r,n,o,a){this.scope=e,this.config=t,this.sound=i,this.demo=r,this.timeline=n,this.texture=o,this.material=a}return e.prototype.disableEffects=function(){for(var e in this.demo.currentScene.effects){var t=this.demo.currentScene.effects[e];t.enabled=!1}},e.prototype.changeObject=function(){for(var e in this.demo.currentScene.children){var t=this.demo.currentScene.children[e];if(t.uuid==this.selectedObjectUUID)return this.selectedObject=t,void console.log(t)}},e.prototype.scn=function(){return this.demo.currentScene},e.prototype.saveTextures=function(){this.texture.save()},e.prototype.newTexture=function(e){this.scope.selectTexture=this.texture.add(e)},e.prototype.saveMaterials=function(){this.material.save()},e}(),i=angular.module("Diwe");i.controller("SidebarController",["$scope","ConfigService","SoundService","DemoService","TimelineService","TextureService","MaterialService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i,r){this.config=e,this.demo=t,this.timeline=i,this.sound=r}return e.prototype.keyDown=function(e){this.defaultsDown(e),this.config.current.controls===!0&&this.timelineDown(e)},e.prototype.keyUp=function(e){this.defaultsUp(e),this.config.current.controls===!0&&(this.timelineUp(e),this.guiUp(e))},e.prototype.defaultsDown=function(e){38==e.keyCode&&(this.sound.volume=this.sound.volume+10),40==e.keyCode&&(this.sound.volume=this.sound.volume-10)},e.prototype.defaultsUp=function(e){27==e.keyCode&&(this.demo.pause(),this.demo.state=this.demo.states.end,this.sound.time=this.sound.duration),32==e.keyCode&&this.demo.pause(),32==e.keyCode&&e.shiftKey&&this.demo.stop(),77==e.keyCode&&this.sound.mute()},e.prototype.timelineDown=function(e){37!=e.keyCode||e.shiftKey||this.timeline.seekByTime(this.demo,this.sound.time-1),39!=e.keyCode||e.shiftKey||this.timeline.seekByTime(this.demo,this.sound.time+1),75==e.keyCode&&(this.sound.pause(),this.timeline.keyframeAdd({}))},e.prototype.timelineUp=function(e){37==e.keyCode&&e.shiftKey&&this.timeline.seekByIndex(this.demo,this.timeline.index-1),39==e.keyCode&&e.shiftKey&&this.timeline.seekByIndex(this.demo,this.timeline.index+1),40==e.keyCode&&e.shiftKey&&this.timeline.seekByIndex(this.demo,this.timeline.index),36==e.keyCode&&this.timeline.seekByTime(this.demo,0),33==e.keyCode&&this.timeline.scenePrev(this.demo),34==e.keyCode&&this.timeline.sceneNext(this.demo)},e.prototype.guiUp=function(e){if(71==e.keyCode&&(this.config.current.show_gui=!this.config.current.show_gui,this.demo.setSize()),e.keyCode>47&&e.keyCode<58){Object.keys(this.demo.scenes),e.keyCode-48}},e}(),i=angular.module("Diwe");i.controller("SystemController",["ConfigService","DemoService","TimelineService","SoundService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t){this.scope=e,this.texture=t,this.wrapOptions={"THREE.RepeatWrapping":THREE.RepeatWrapping,"THREE.ClampToEdgeWrapping":THREE.ClampToEdgeWrapping,"THREE.MirroredRepeatWrapping":THREE.MirroredRepeatWrapping},this.magFilterOptions={"THREE.NearestFilter":THREE.NearestFilter,"THREE.LinearFilter":THREE.LinearFilter},this.minFilterOptions={"THREE.NearestFilter":THREE.NearestFilter,"THREE.NearestMipMapNearestFilter":THREE.NearestMipMapNearestFilter,"THREE.NearestMipMapLinearFilter":THREE.NearestMipMapLinearFilter,"THREE.LinearFilter":THREE.LinearFilter,"THREE.LinearMipMapNearestFilter":THREE.LinearMipMapNearestFilter,"THREE.LinearMipMapLinearFilter":THREE.LinearMipMapLinearFilter},this.mappingOptions={"THREE.UVMapping ":THREE.UVMapping,"THREE.CubeReflectionMapping":THREE.CubeReflectionMapping,"THREE.CubeRefractionMapping":THREE.CubeRefractionMapping,"THREE.EquirectangularReflectionMapping":THREE.EquirectangularReflectionMapping,"THREE.EquirectangularRefractionMapping":THREE.EquirectangularRefractionMapping,"THREE.SphericalReflectionMapping":THREE.SphericalReflectionMapping,"THREE.CubeUVReflectionMapping":THREE.CubeUVReflectionMapping,"THREE.CubeUVRefractionMapping":THREE.CubeUVRefractionMapping},this.formatOptions={"THREE.AlphaFormat":THREE.AlphaFormat,"THREE.RGBFormat":THREE.RGBFormat,"THREE.RGBAFormat":THREE.RGBAFormat,"THREE.LuminanceFormat":THREE.LuminanceFormat,"THREE.LuminanceAlphaFormat":THREE.LuminanceAlphaFormat,"THREE.RGBEFormat":THREE.RGBEFormat,"THREE.DepthFormat":THREE.DepthFormat},this.encodingOptions={"THREE.LinearEncoding":THREE.LinearEncoding,"THREE.sRGBEncoding":THREE.sRGBEncoding,"THREE.AlphaFormat":THREE.GammaEncoding,"THREE.RGBEEncoding":THREE.RGBEEncoding,"THREE.LogLuvEncoding":THREE.LogLuvEncoding,"THREE.RGBM7Encoding":THREE.RGBM7Encoding,"THREE.RGBM16Encoding":THREE.RGBM16Encoding,"THREE.RGBDEncoding":THREE.RGBDEncoding},this.typeOptions={"THREE.UnsignedByteType":THREE.UnsignedByteType,"THREE.ByteType":THREE.ByteType,"THREE.ShortType":THREE.ShortType,"THREE.UnsignedShortType":THREE.UnsignedShortType,"THREE.IntType":THREE.IntType,"THREE.UnsignedIntType":THREE.UnsignedIntType,"THREE.FloatType":THREE.FloatType,"THREE.HalfFloatType":THREE.HalfFloatType,"THREE.UnsignedShort4444Type":THREE.UnsignedShort4444Type,"THREE.UnsignedShort5551Type":THREE.UnsignedShort5551Type,"THREE.UnsignedShort565Type":THREE.UnsignedShort565Type}}return e.prototype.changeTexture=function(e){this.scope.texture.needsUpdate=!0},e.prototype.deleteTexture=function(){this.texture["delete"](this.scope.texture.name)},e.prototype.changeImage=function(e,t){this.scope.texture.needsUpdate=!0,this.scope.texture[t]&&this.scope.texture[t].name==e},e}(),i=angular.module("Diwe");i.controller("TextureController",["$scope","TextureService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i,r){this.config=e,this.demo=t,this.sound=i,this.timeline=r}return Object.defineProperty(e.prototype,"percent",{get:function(){return this.sound.time/this.sound.duration*100},set:function(e){this.sound.time=this.sound.duration*(e/100)},enumerable:!0,configurable:!0}),e.prototype.setPercent=function(e){var t=e.currentTarget.clientWidth,i=e.offsetX;this.percent=i/t*100},e}(),i=angular.module("Diwe");i.controller("TimelineController",["ConfigService","DemoService","SoundService","TimelineService",t])}(Diwe||(Diwe={}));var Diwe;!function(e){function t(){return{name:"main",near:1,far:1e3,fov:75,position:[0,0,150],lookAt:[0,0,0],scale:[1,1,1]}}function i(){return{name:"second",near:1,far:1e3,fov:75,position:[50,50,200],lookAt:[0,0,0],scale:[1,1,1]}}function r(){return{name:"track",near:1,far:1e3,fov:75,position:[0,0,150],lookAt:[0,0,0],scale:[1,1,1]}}e.mainCamera=t,e.secondCamera=i,e.trackCamera=r}(Diwe||(Diwe={}));var Diwe;!function(e){function t(){return{data:"data/",fonts:"data/fonts/",objects:"data/objects/",textures:"data/textures/",max_fps:40,limit_fps:!1,volume:64,min_near:1,max_far:2e4,axis_size:100,controls:!1,seekPlay:0,seekPlayEnabled:!1,show_fps:!1,show_gui:!1,show_axis:!1,trackball:!1,sleep:100,effects:!0,shadows:!0,shadow_cam:!1,shadow_map_size_multiplier:4,renderer:{alpha:!0,premultipliedAlpha:!0,antialias:!1,stencil:!0,preserveDrawingBuffer:!1,clearColor:0}}}function i(){var e=t();return angular.merge(e,{limit_fps:!1,volume:100,show_fps:!1,show_gui:!1,show_axis:!1,trackball:!1,sleep:100,effects:!0,shadows:!0,shadow_cam:!1,shadow_map_size_multiplier:4}),e}e.defaultConfig=t,e.partyConfig=i}(Diwe||(Diwe={}));var Diwe;!function(e){function t(e){var t={DefaultFog:{color:"color",near:"number",far:"number"},ExpFog:{color:"color",density:"number"},AmbientLight:{visible:"boolean",color:"color",intensity:"number"},SpotLight:{visible:"boolean",color:"color",intensity:"number",castShadow:"boolean",decay:"number",distance:"number",position:"vector3"},PointLight:{visible:"boolean",color:"color",intensity:"number",castShadow:"boolean",decay:"number",distance:"number",position:"vector3"},PerspectiveCamera:{castShadow:"boolean",far:"number",focalLength:"number",fov:"number",near:"number",zoom:"number",position:"vector3",lookAt:"vector3",scale:"vector3",visible:"boolean"},Mesh:{castShadow:"boolean",receiveShadow:"boolean",position:"vector3",rotation:"euler",scale:"vector3",visible:"boolean",material:"material"},Points:{position:"vector3",rotation:"euler",scale:"vector3",visible:"boolean",material:"material"},BleachEffect:{enabled:"boolean",uniforms:{opacity:{value:"number"}}},BloomEffect:{enabled:"boolean",copyUniforms:{opacity:{value:"number"}}},DotScreenEffect:{enabled:"boolean",uniforms:{angle:{value:"number"},scale:{value:"number"}}},EdgeEffect:{enabled:"boolean"},FilmEffect:{enabled:"boolean",uniforms:{grayscale:{value:"boolean"},nIntensity:{value:"number"},sCount:{value:"number"},sIntensity:{value:"number"},time:{value:"number"}}},FocusEffect:{enabled:"boolean",uniforms:{sampleDistance:{value:"number"},waveFactor:{value:"number"}}},HorizontalTiltShiftEffect:{enabled:"boolean",uniforms:{h:{value:"number"},r:{value:"number"}}},KaleidoEffect:{enabled:"boolean"},MirrorEffect:{enabled:"boolean",uniforms:{side:{value:"number"}}},RefractionEffect:{enabled:"boolean"},RgbShiftEffect:{enabled:"boolean",uniforms:{amount:{value:"number"}}},SsaoEffect:{enabled:"boolean"},VignetteEffect:{enabled:"boolean"},Texture:{repeat:"vector2",mapping:"number",image:"image",anisotropy:"number",wrapS:"number",wrapT:"number"},ColorifyEffect:{enabled:"boolean"},BrightnessContrastEffect:{enabled:"boolean"},ColorCorrectionEffect:{enabled:"boolean"},HueSaturationEffect:{enabled:"boolean"},LuminosityEffect:{enabled:"boolean"},GlitchEffect:{enabled:"boolean"},VerticalBlurEffect:{enabled:"boolean",uniforms:{v:{value:"number"}}},Material:{type:"string",color:"color",specular:"color",shininess:"number",map:"texture",bumpMap:"texture",bumpScale:"number",alphaMap:"texture",envMap:"texture",reflectivity:"number",refractionRatio:"number",shading:"number",opacity:"number",transparent:"boolean",combine:"number",blending:"number",side:"number",size:"number",depthTest:"boolean",depthWrite:"boolean"}};return void 0===e?t:t[e]?t[e]:void 0}e.ObjectKeys=t}(Diwe||(Diwe={}));var Diwe;!function(e){function t(){return{title:"title",subtitle:"subtitle",group:"group",party:"party",country:"Hungary",site:"http://",online:"http://",credits:[{title:"Engine",nickname:"rascy"}],musicfile:"data/musicfile",description:"description",greetings_int:["scene.org"],greetings_hun:["scene.hu"]}}e.defaultParams=t}(Diwe||(Diwe={}));var Diwe;!function(e){function t(){return{name:"new",image:"1.jpg",mapping:THREE.UVMapping,repeat:{x:1,y:1}}}e.defaultTexture=t}(Diwe||(Diwe={}));var Diwe;!function(e){function t(){return{}}e.defaultTrackball=t}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e){this.config=e,this.fogs={},this.pointlights={},this.spotlights={},this.presets={},this.scene=null}return e.prototype.init=function(e){this.fogs=e.fogs,this.pointlights=e.pointlights,this.spotlights=e.spotlights,this.presets=e.atmospheres},e.prototype.setup=function(e,t){var i,r=this.presets[t];if(this.scene=e,e.lights={},r.fog){var n=this.fogs[r.fog];e.fog=this.createFog(n),e.fog.type=n.type[0].toUpperCase()+n.type.slice(1)+"Fog"}var o=this.createAmbient(r.ambient);e.lights.ambient=o,e.add(o);for(var a in r.pointlights){var t=r.pointlights[a];this.pointlights[t]?(i=this.createPointLight(t),e.lights[t]=i,e.add(i)):console.warn("pointlights not found: "+t)}for(var a in r.spotlights){var t=r.spotlights[a];this.spotlights[t]?(i=this.createSpotLight(t),e.lights[t]=i,e.add(i)):console.warn("spotlights not found: "+t)}return e},e.prototype.createFog=function(e){switch(e.type){case"default":return new THREE.Fog(e.color,e.near,e.far);case"exp":return new THREE.FogExp2(e.color,e.density)}},e.prototype.createPointLight=function(e){var t=this.pointlights[e],i=new THREE.PointLight(t.color,t.intensity,t.distance);return i=this.lightCommon(i,t),i.name=e,i},e.prototype.createSpotLight=function(e){var t=this.spotlights[e],i=new THREE.SpotLight(t.color);this.lightCommon(i,t),i.name=e,t.target&&(i.target.position.x=t.target.x,i.target.position.y=t.target.y,i.target.position.z=t.target.z);var r=["intensity","distance","angle","decay","exponent"];for(var n in r)t[r[n]]&&(i[r[n]]=t[r[n]]);return i},e.prototype.lightCommon=function(e,t){if(t.position&&(e.position.x=t.position.x,e.position.y=t.position.y,e.position.z=t.position.z),t.mesh&&"default"===t.mesh){var i=new THREE.SphereGeometry(12,12,12),r=new THREE.MeshBasicMaterial({color:t.color}),n=new THREE.Mesh(i,r);e.add(n)}return t.castShadow&&(e.castShadow=!0,e.shadow.bias=t.shadow.bias,e.shadow.camera.near=t.shadow.camera.near,e.shadow.camera.far=t.shadow.camera.far,e.shadow.mapSize.width=512*this.config.current.shadow_map_size_multiplier,e.shadow.mapSize.height=512*this.config.current.shadow_map_size_multiplier,this.config.current.shadow_cam&&this.scene.add(new THREE.CameraHelper(e.shadow.camera))),e},e.prototype.createAmbient=function(e){var t=new THREE.AmbientLight(e),t=new THREE.AmbientLight(e);return t.name="ambient",t},e}(),i=angular.module("Diwe");i.factory("AtmosphereService",["ConfigService",function(e){return new t(e)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function t(){this.preset="default",this.current=e.defaultConfig(),this.presets={"default":e.defaultConfig(),party:e.partyConfig()},this.setCurrent()}return t.prototype.setCurrent=function(e){e&&(this.preset=e),this.current=this.presets[this.preset]},t.prototype.init=function(t){if(t){for(var i in t)this.presets[i]||(this.presets[i]=e.defaultConfig()),angular.merge(this.presets[i],t[i]);this.setCurrent()}},t.prototype.getSize=function(e){!e&&this.width||(this.width=angular.element(".diwe .system").width(),this.height=angular.element(".diwe .system").height());var t=this.current.show_gui?50:0,i=this.current.show_gui?.2:0;return{width:this.width-this.width*i,height:this.height-t}},t}(),i=angular.module("Diwe");i.factory("ConfigService",[function(){return new t}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function t(t,i,r,n,o,a,s,c,l,u,h,p){this.config=t,this.atmosphere=i,this.diwe=r,this.sound=n,this.object=o,this.effect=a,this.timeline=s,this.material=c,this.texture=l,this.timeout=u,this.interval=h,this.window=p,this.params=e.defaultParams(),this.state=-1,this.states={setup:-1,loading:0,playing:1,paused:2,stopped:3,end:4},this.scenes={},this.currentScene=null,this.currentSceneObj=null,this.currentCamera=null,this.currentSceneName=null,this.currentSceneStartTime=0,this.stats=null,this.config.init(demo.configs),demo.params&&(angular.merge(this.params,demo.params),this.params.preset&&this.config.setCurrent(this.params.preset)),document.title=this.params.title+" | "+this.params.group}return t.prototype.start=function(){var e=this;this.state=this.states.loading,this.atmosphere.init(demo),this.diwe.initRender(),this.setSize(),this.window.addEventListener("resize",function(){e.setSize()},!1),this.sound.init(this.params.musicfile,{onKick:function(t){e.currentSceneObj.onKick(t,e.currentScene,e.sound)},offKick:function(t){e.currentSceneObj.offKick(t,e.currentScene,e.sound)}}),e.texture.init(demo.textures);var t=this.interval(function(){e.texture.ready&&(e.material.init(demo.materials),e.interval.cancel(t))},this.config.current.sleep),i=this.interval(function(){e.material.ready&&(e.object.init(demo.objects),e.interval.cancel(i))},this.config.current.sleep),r=this.interval(function(){e.object.ready&&(e.initScenes(demo.scenes),e.initStats(),e.sound.load(),e.interval.cancel(r))},this.config.current.sleep),n=this.interval(function(){e.sound.ready&&(e.timeline.init(demo.timeline),e.state=e.states.playing,e.animate(),angular.element(".controll").focus(),angular.element(".layers").on("click",function(e){angular.element(".controll").focus()}),e.interval.cancel(n),e.sound.play())},this.config.current.sleep)},t.prototype.loading=function(){var e=Object.keys(demo.scenes).length,t=Object.keys(this.scenes).length,i=this.object.all+this.material.all+this.texture.all+e,r=this.object.loaded+this.material.loaded+this.texture.loaded+t,n=r/i*100;return{scenes:{all:e,loaded:t},overall:{all:i,loaded:r,percent:n}}},t.prototype.isState=function(e,t){switch(t){case"gte":return this.state>=this.states[e];case"gt":return this.state>this.states[e];default:return this.state==this.states[e]}},t.prototype.initScenes=function(e){for(var t in e)this.scenes[t]=this.createScene(e[t],t)},t.prototype.createScene=function(e,t){this.scenes[t]=new THREE.Scene;var i=this.scenes[t],r=this;this.atmosphere.setup(i,e.atmosphere),i.name=t,i.cameras={},i.objects={},i.materials={},i.addObj=function(e){void 0!=e.name&&""!=e.name||console.warn("object name missing",e),i.objects[e.name]=e,i.add(e)},i.addMat=function(e){return i.materials[e]=r.material.get(e)};for(var n in e.cameras){var o=e.cameras[n],a=demo.cameras[o];a.name=o;var s=this.createCamera(a);i.cameras[o]=s,i.add(s)}return i.cameraActive="main",i.controls=this.createControls(i.cameras.main,angular.element(".trackball")[0]),e.init&&e.init(i,this.object,this.texture,this.material,this),e.animate||(e.animate=function(){}),e.onKick||(e.onKick=function(){}),e.offKick||(e.offKick=function(){}),this.currentScene||this.changeScene(t),i.composer=this.effect.setup(e.effects,i,this.diwe.renderer,this),i},t.prototype.changeCamera=function(e){e&&(this.currentScene.cameraActive=e),this.currentCamera=this.currentScene.cameras[this.currentScene.cameraActive]},t.prototype.changeScene=function(e){return e&&(e!=this.currentScene&&(this.currentSceneStartTime=parseFloat(""+this.sound.time)),this.currentSceneName=e),void 0===demo.scenes[this.currentSceneName]||void 0===this.scenes[this.currentSceneName]?void console.warn(this.currentSceneName+" scene not found"):(this.currentSceneObj=demo.scenes[this.currentSceneName],this.currentScene=this.scenes[this.currentSceneName],void(this.currentCamera=this.currentScene.cameras[this.currentScene.cameraActive]))},t.prototype.createCamera=function(e){var t=new THREE.PerspectiveCamera(e.fov,this.diwe.getAspectRatio(),e.near,e.far);return t.position.x=e.position[0],t.position.y=e.position[1],t.position.z=e.position[2],t.scale.x=e.scale[0],t.scale.y=e.scale[1],t.scale.z=e.scale[2],t.lookAt(new THREE.Vector3(e.lookAt[0],e.lookAt[1],e.lookAt[2])),t.name=e.name,t},t.prototype.createControls=function(e,t){var i=new THREE.OrbitControls(e,t);return i.enableKeys=!1,i},t.prototype.pause=function(){this.sound.pause(),this.state!=this.states.playing?this.state=this.states.playing:(this.state=this.states.paused,console.log(this.currentScene),console.log(this.sound),console.log(this.texture.textures),console.log(this.material.materials),console.log(this.timeline.keyframes))},t.prototype.stop=function(){this.sound.pause(),this.state!=this.states.playing?(this.state=this.states.playing,this.animate()):this.state=this.states.stopped},t.prototype.animateScene=function(e){(this.state==this.states.playing||e)&&(this.currentSceneObj&&this.currentSceneObj.animate(this.currentScene,this.sound,this),this.timeline.setFrame(this))},Object.defineProperty(t.prototype,"currentTime",{get:function(){return this.sound.time},enumerable:!0,configurable:!0}),t.prototype.animate=function(){if(this.state==this.states.playing||this.state==this.states.paused){this.animateScene();var e=this;this.config.current.limit_fps!==!0?window.requestAnimationFrame(function(){e.animate()}):this.timeout(function(){e.animate()},1e3/this.config.current.max_fps)}this.state!=this.states.stopped&&this.renderScene()},t.prototype.renderScene=function(){this.stats&&this.stats.update(),this.currentScene.controls.update(),this.diwe.renderScene(this.currentScene,this.currentCamera)},t.prototype.initStats=function(){this.config.current.show_fps===!0&&(this.stats=new Stats,this.stats.domElement.style.position="fixed",this.stats.domElement.style.top="0px",this.stats.domElement.style.zIndex="100",document.body.appendChild(this.stats.domElement))},t.prototype.setSize=function(){this.config.getSize(!0);for(var e in this.scenes){var t=this.scenes[e];for(var i in t.cameras){var r=t.cameras[i];r.aspect=this.diwe.getAspectRatio(),r.updateProjectionMatrix()}}this.diwe.setSize(),this.effect.setSize(this.currentScene)},t}(),i=angular.module("Diwe");i.factory("DemoService",["ConfigService","AtmosphereService","SystemService","SoundService","ObjectService","EffectService","TimelineService","MaterialService","TextureService","$timeout","$interval","$window",function(e,i,r,n,o,a,s,c,l,u,h,p){return new t(e,i,r,n,o,a,s,c,l,u,h,p)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.config=e,this.system=t,this.params=i,this.composer=null,this.scene=null}return e.prototype.setup=function(e,t,i,r){var n=t.cameras.main;this.scene=t,this.composer=new THREE.EffectComposer(i),this.composer.addPass(new THREE.RenderPass(t,n)),this.scene.effects={},this.addEffect("ssao",this.ssao(t,n)),this.addEffect("kaleido",this.kaleido()),this.addEffect("mirror",this.mirror()),this.addEffect("refraction",this.refraction()),this.addEffect("dotScreen",this.dotScreen()),this.addEffect("rgbShift",this.rgbShift()),this.addEffect("horizontalTiltShift",this.horizontalTiltShift()),this.addEffect("bleach",this.bleach()),this.addEffect("vignette",this.vignette()),this.addEffect("bloom",this.bloom()),this.addEffect("focus",this.focus()),this.addEffect("verticalBlur",this.verticalBlur()),this.addEffect("film",this.film()),this.addEffect("colorify",this.colorify()),this.addEffect("brightnessContrast",this.brightnessContrast()),this.addEffect("colorCorrection",this.colorCorrection()),this.addEffect("hueSaturation",this.hueSaturation()),this.addEffect("luminosity",this.luminosity()),this.composer.addPass(this.copy());for(var o in e){var a=t.effects[o].type;this.params.setParams(t.effects[o],a,e[o])}return this.composer},e.prototype.setSize=function(e){if(e&&e.effects){if(this.composer.setSize(this.config.getSize().width,this.config.getSize().height),e.effects.focus&&(e.effects.focus.uniforms.screenWidth.value=this.config.getSize().width,e.effects.focus.uniforms.screenHeight.value=this.config.getSize().height),e.effects.horizontalTiltShift){var t=7;e.effects.horizontalTiltShift.uniforms.h.value=t/this.config.getSize().width}e.effects.ssao&&e.effects.ssao.uniforms.size.value.set(this.config.getSize().width,this.config.getSize().height)}},e.prototype.addEffect=function(e,t){t.enabled=!1,t.type=e[0].toUpperCase()+e.slice(1)+"Effect",this.composer.addPass(t),this.scene.effects[e]=t},e.prototype.copy=function(){var e=new THREE.ShaderPass(THREE.CopyShader);return e.renderToScreen=!0,e},e.prototype.bloom=function(){var e=new THREE.BloomPass(1);return e},e.prototype.bleach=function(){var e=new THREE.ShaderPass(THREE.BleachBypassShader);return e.uniforms.opacity.value=3,e},e.prototype.film=function(){var e=new THREE.ShaderPass(THREE.FilmShader);return e.uniforms.sCount.value=800,e.uniforms.sIntensity.value=.9,e.uniforms.nIntensity.value=.4,e.uniforms.grayscale.value=!1,e},e.prototype.focus=function(){var e=new THREE.ShaderPass(THREE.FocusShader);return e.uniforms.screenWidth.value=this.config.getSize().width,e.uniforms.screenHeight.value=this.config.getSize().height,e},e.prototype.kaleido=function(){var e=new THREE.ShaderPass(THREE.KaleidoShader);return e},e.prototype.edge=function(){var e=new THREE.ShaderPass(THREE.EdgeShader);return e},e.prototype.mirror=function(){var e=new THREE.ShaderPass(THREE.MirrorShader);return e},e.prototype.vignette=function(){var e=new THREE.ShaderPass(THREE.VignetteShader);return e.uniforms.darkness.value=2,e},e.prototype.horizontalTiltShift=function(){var e=new THREE.ShaderPass(THREE.HorizontalTiltShiftShader),t=7;return e.uniforms.h.value=t/this.config.getSize().width,e},e.prototype.refraction=function(){var e=(new THREE.TextureLoader).load("data/textures/envmaps/env_silver.jpg");e.needsUpdate=!0;var t=new THREE.NodePass,i=new THREE.TextureNode(e),r=new THREE.SwitchNode(i,"xy"),n=new THREE.FloatNode(.5),o=(new THREE.Vector2Node(-1,1),
new THREE.Math1Node(r,THREE.Math1Node.INVERT)),a=new THREE.OperatorNode(o,new THREE.FloatNode(.5),THREE.OperatorNode.ADD),s=new THREE.OperatorNode(new THREE.SwitchNode(i,"z"),a,THREE.OperatorNode.MUL),c=new THREE.Math3Node(new THREE.FloatNode(1),s,n,THREE.Math3Node.MIX),l=new THREE.OperatorNode(new THREE.UVNode,c,THREE.OperatorNode.MUL),u=new THREE.ScreenNode(l);return t.value=u,t.build(),t},e.prototype.dotScreen=function(){var e=new THREE.ShaderPass(THREE.DotScreenShader);return e.uniforms.scale.value=4,e},e.prototype.rgbShift=function(){var e=new THREE.ShaderPass(THREE.RGBShiftShader);return e.uniforms.amount.value=.0015,e},e.prototype.ssao=function(e,t){e.depthMaterial=new THREE.MeshDepthMaterial,e.depthMaterial.depthPacking=THREE.RGBADepthPacking,e.depthMaterial.blending=THREE.NoBlending;var i={minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter};e.depthRenderTarget=new THREE.WebGLRenderTarget(window.innerWidth,window.innerHeight,i);var r=new THREE.ShaderPass(THREE.SSAOShader);return r.uniforms.tDepth.value=e.depthRenderTarget,r.uniforms.size.value.set(this.config.getSize().width,this.config.getSize().height),r.uniforms.cameraNear.value=t.near,r.uniforms.cameraFar.value=t.far,r.uniforms.onlyAO.value=!1,r.uniforms.aoClamp.value=.3,r.uniforms.lumInfluence.value=.5,r},e.prototype.colorify=function(){var e=new THREE.ShaderPass(THREE.ColorifyShader);return e.uniforms.color.value=new THREE.Color(16711680),e},e.prototype.brightnessContrast=function(){var e=new THREE.ShaderPass(THREE.BrightnessContrastShader);return e.uniforms.contrast.value=.2,e.uniforms.brightness.value=.1,e},e.prototype.colorCorrection=function(){var e=new THREE.ShaderPass(THREE.ColorCorrectionShader);return e},e.prototype.hueSaturation=function(){var e=new THREE.ShaderPass(THREE.HueSaturationShader);return e.uniforms.hue.value=.5,e.uniforms.saturation.value=.5,e},e.prototype.luminosity=function(){var e=new THREE.ShaderPass(THREE.LuminosityShader);return e},e.prototype.verticalBlur=function(){var e=new THREE.ShaderPass(THREE.VerticalBlurShader);return e.uniforms.v.value=1/512,e},e.prototype.glitch=function(){var e=new THREE.ShaderPass(THREE.GlitchPass);return e},e}(),i=angular.module("Diwe");i.factory("EffectService",["ConfigService","SystemService","ParamsService",function(e,i,r){return new t(e,i,r)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i,r){this.config=e,this.texture=t,this.interval=i,this.params=r,this.materials={},this.all=0,this.loaded=0,this.ready=!1,this.all=Object.keys(demo.materials).length}return e.prototype.init=function(e){for(var t in e)this.create(t,e[t]);var i=this,r=this.interval(function(){i.loaded==i.all&&(i.ready=!0,i.interval.cancel(r))},this.config.current.sleep)},e.prototype.get=function(e,t){return this.materials[e]||console.warn(e+" material not found"),t===!0?this.materials[e].clone():this.materials[e]},e.prototype.addMap=function(e,t){if(!e)return null;var i=demo.textures[e];return i?(t.indexOf(i.mapping)<0&&console.warn("Incorrect mapping type: "+e+" - on material "+e),this.texture.get(e)):(console.warn(e+" texture not found"),null)},e.prototype.create=function(e,t){if(demo.materials[e]||t){!demo.materials[e]&&t&&(demo.materials[e]=angular.extend({},t)),t||(t=demo.materials[e]);var i=angular.extend({},t),r={map:[THREE.UVMapping],bumpMap:[THREE.UVMapping],alphaMap:[THREE.UVMapping],lightMap:[THREE.UVMapping],envMap:[THREE.CubeReflectionMapping,THREE.CubeRefractionMapping,THREE.SphericalReflectionMapping]};for(var n in r)void 0!==i[n]&&null!==i[n]&&(i[n]=this.addMap(i[n],r[n]));switch(i.type){case"MeshBasicMaterial":delete i.bumpMap,delete i.lightMap,this.materials[e]=new THREE.MeshBasicMaterial(i);break;case"MeshPhongMaterial":this.materials[e]=new THREE.MeshPhongMaterial(i);break;case"MeshNormalMaterial":this.materials[e]=new THREE.MeshNormalMaterial(i);break;case"MeshLambertMaterial":delete i.bumpMap,this.materials[e]=new THREE.MeshLambertMaterial(i);break;case"PointsMaterial":delete i.envMap,delete i.bumpMap,delete i.alphaMap,delete i.lightMap,this.materials[e]=new THREE.PointsMaterial(i)}return this.materials[e].name=e,1==this.config.current.show_gui?this.materials[e].needsUpdate=!0:this.materials[e].needsUpdate=void 0!==i.needsUpdate?i.needsUpdate:!1,this.materials[e].needsUpdate=!0,this.loaded++,this.materials[e]}},e.prototype.save=function(){var e={};for(var t in this.materials){var i=this.materials[t],r=this.params.getParams(i,"Material");e[i.name]=r}var n=JSON.stringify(e,null,"    "),o="data:text/json;charset=utf8,"+encodeURIComponent(n);window.open(o,"_blank"),window.focus()},e.prototype.text=function(e){e.size||(e.size=1024),void 0==e.alpha&&(e.alpha=!0);var t=this.texture.text(e),i=new THREE.Texture(t);return i.mapping=THREE.CubeRefractionMapping,i.wrapS=THREE.RepeatWrapping,i.wrapT=THREE.RepeatWrapping,i.repeat.set(1,1),i.needsUpdate=!0,e.material.map=i,e.material.side=THREE.DoubleSide,e.alpha&&(e.material.transparent=!0,e.material.alphaMap=i,e.material.depthWrite=!1),e.material},e}(),i=angular.module("Diwe");i.factory("MaterialService",["ConfigService","TextureService","$interval","ParamsService",function(e,i,r,n){return new t(e,i,r,n)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t){this.config=e,this.interval=t,this.objects={},this.all=0,this.loaded=0,this.ready=!1,this.all=Object.keys(demo.objects).length}return e.prototype.init=function(e){for(var t in e){var i=e[t];"string"==typeof i?this.loader(t,i):(this.objects[t]=i,this.loaded++)}var r=this,n=this.interval(function(){r.loaded==r.all&&(r.ready=!0,r.interval.cancel(n))},this.config.current.sleep)},e.prototype.loader=function(e,t){var i=t.substr(t.indexOf("."));switch(i){case".js":this.loaderJson(e,t);break;case".obj":this.loaderObj(e,t)}},e.prototype.loaderJson=function(e,t){var i=this,r=new THREE.JSONLoader;r.load(this.config.current.objects+t,function(t){var r=new THREE.Mesh(t,new THREE.MeshFaceMaterial);r.name=e,r.visible=!0,i.objects[e]=r,i.loaded++})},e.prototype.loaderObj=function(e,t){var i=this,r=new THREE.OBJLoader;r.load(this.config.current.objects+t,function(t){t.traverse(function(e){e instanceof THREE.Mesh}),t.name=e,t.visible=!0,i.objects[e]=t,i.loaded++})},e.prototype.get=function(e,t){return this.objects[e]?"function"==typeof this.objects[e]?this.objects[e](t):this.objects[e].clone():void console.warn(e+" object not found")},e.prototype.axis=function(e){var t=new THREE.AxisHelper;return t.name="helper-axis",t.scale.x=t.scale.y=t.scale.z=e,t},e.prototype.grid=function(e,t){var i=new THREE.GridHelper(e,t);return i.name="helper-grid",i.setColors(255,8421504),i.position.y=0,i},e}(),i=angular.module("Diwe");i.factory("ObjectService",["ConfigService","$interval",function(e,i){return new t(e,i)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function t(e){this.config=e}return t.prototype.getParams=function(t,i){return this.getParamsParse(t,e.ObjectKeys(i))},t.prototype.setParams=function(t,i,r,n,o){this.setParamsParse(t,e.ObjectKeys(i),r,n,o)},t.prototype.getParamsParse=function(e,t){var i={};for(var r in t){var n=t[r];"object"==typeof n?i[r]=this.getParamsParse(e[r],n):i[r]=this.getParam(e,r,n),void 0===i[r]&&delete i[r]}return i},t.prototype.setParamsParse=function(e,t,i,r,n){for(var o in t){var a=t[o];"object"==typeof a&&i[o]?this.setParamsParse(e[o],a,i[o],r?r[o]:null,n):this.setParam(e,o,a,i,r,n)}},t.prototype.getImageSrc=function(e){var t=angular.element(e.outerHTML).attr("src");return t.replace(this.config.current.textures,"")},t.prototype.getParam=function(e,t,i){if(void 0!==e[t]&&null!==e[t])switch(i){case"vector2":return{x:e[t].x,y:e[t].y};case"color":return e[t].toArray();case"texture":return e[t].name;case"image":var r=e[i].length;switch(r){case 6:var n=[];for(var o in e[i])n.push(this.getImageSrc(e[i][o]));return n;default:return this.getImageSrc(e[i])}default:return e[t]}},t.prototype.setParam=function(e,t,i,r,n,o){if(void 0!==r[t])switch(i){case"vector3":n&&void 0!==n[t]?(e[t].x=this.tween(r[t].x,n[t].x,o.percent),e[t].y=this.tween(r[t].y,n[t].y,o.percent),e[t].z=this.tween(r[t].z,n[t].z,o.percent)):(e[t].x=r[t].x,e[t].y=r[t].y,e[t].z=r[t].z);break;case"color":n&&void 0!==n[t]?(e[t].r=parseInt(this.tween(r[t][0],n[t][0],o.percent)),e[t].g=parseInt(this.tween(r[t][1],n[t][1],o.percent)),e[t].b=parseInt(this.tween(r[t][2],n[t][2],o.percent))):(e[t].r=r[t][0],e[t].g=r[t][1],e[t].b=r[t][2]);break;case"number":n&&void 0!==n[t]?e[t]=this.tween(r[t],n[t],o.percent):e[t]=r[t];break;case"vector2":e[t]=new THREE.Vector2(r[t].x,r[t].y);break;case"euler":break;default:e[t]!=r[t]&&(e[t]=r[t])}},t.prototype.tween=function(e,t,i){return e+(t-e)*i},t}(),i=angular.module("Diwe");i.factory("ParamsService",["ConfigService",function(e){return new t(e)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t){this.config=e,this.timeout=t,this.player=null,this.musicfile=null,this.kick=null,this.ready=!1}return e.prototype.init=function(e,t){this.musicfile=e,this.player=new Dancer,this.kick=t},Object.defineProperty(e.prototype,"volume",{get:function(){return this.ready?Math.round(100*this.player.getVolume()):void 0},set:function(e){this.ready&&(0>e&&(e=0),e>100&&(e=100),this.player.setVolume(e/100))},enumerable:!0,configurable:!0}),e.prototype.mute=function(){0==this.volume?this.volume=this.config.current.volume:this.volume=0},Object.defineProperty(e.prototype,"time",{get:function(){return this.ready?this.player.getTime():void 0},set:function(e){if(this.ready)if(this.paused&&this.config.current.seekPlayEnabled&&this.config.current.seekPlay){this.player.audio.currentTime=e,this.play();var t=this;this.timeout(function(){t.pause(),t.player.audio.currentTime=e},1e3*this.config.current.seekPlay)}else this.player.audio.currentTime=e},enumerable:!0,configurable:!0}),e.prototype.play=function(){this.ready&&this.player.play()},Object.defineProperty(e.prototype,"paused",{get:function(){return!this.player.isPlaying()},enumerable:!0,configurable:!0}),e.prototype.pause=function(e){this.ready&&(void 0===e&&(e=!0),this.player.isPlaying()?this.player.pause():this.player.play())},Object.defineProperty(e.prototype,"duration",{get:function(){return this.ready?this.player.audio.duration:void 0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"percent",{get:function(){return this.ready?this.time/this.duration:void 0},enumerable:!0,configurable:!0}),e.prototype.load=function(){var e=this;this.player.onceAt(0,function(){e.player.createKick(e.kick).on()}).load({src:e.musicfile}),this.player.bind("loaded",function(){e.ready=!0,e.volume=e.config.current.volume})},e.prototype.frequency=function(e,t){return this.player.getFrequency(e,t)},Object.defineProperty(e.prototype,"spectrum",{get:function(){return this.player.getSpectrum()},enumerable:!0,configurable:!0}),e}(),i=angular.module("Diwe");i.factory("SoundService",["ConfigService","$timeout",function(e,i){return new t(e,i)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.config=e,this.sound=t,this.window=i,this.preset="default",this.requirements={audio:null,webgl:null,canvas:null},this.renderer=null,this.time=0,this.timeStart=0,this.checkRequirements()}return e.prototype.checkRequirements=function(){for(var e in this.requirements)this.requirements[e]=!!Modernizr[e]},e.prototype.getAspectRatio=function(){return this.config.getSize().width/this.config.getSize().height},e.prototype.initRender=function(){var e=angular.element(".diwe .three");this.renderer=new THREE.WebGLRenderer(this.config.current.renderer),this.renderer.setClearColor(this.config.current.renderer.clearColor,0),this.renderer.setPixelRatio(window.devicePixelRatio),this.renderer.autoClear=!1,this.setSize(),this.renderer.shadowMap.enabled=this.config.current.shadows,this.renderer.shadowMap.type=THREE.BasicShadowMap,e.append(this.renderer.domElement)},e.prototype.setSize=function(){angular.element(".demo").css("width",this.config.getSize().width).css("height",this.config.getSize().height),this.renderer.setSize(this.config.getSize().width,this.config.getSize().height)},e.prototype.renderScene=function(e,t){e.composer&&this.config.current.effects?(e.depthMaterial&&(e.overrideMaterial=e.depthMaterial,this.renderer.render(e,t,e.depthRenderTarget,!0),e.overrideMaterial=null),e.composer.render()):(this.renderer.clear(),this.renderer.render(e,t))},e}(),i=angular.module("Diwe");i.factory("SystemService",["ConfigService","SoundService","$window",function(e,i){return new t(e,i,window)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function t(e,t,i,r){this.config=e,this.interval=t,this.filter=i,this.params=r,this.textures=null,this.all=0,this.loaded=0,this.ready=!1,this.all=Object.keys(demo.textures).length}return t.prototype.init=function(e){for(var t in e)this.create(t,e[t]);var i=this,r=this.interval(function(){i.loaded==i.all&&(i.ready=!0,i.interval.cancel(r))},this.config.current.sleep)},t.prototype.get=function(e){return this.textures[e]||console.warn(e+" texture not found"),this.textures[e]},t.prototype.list=function(e){var t=[];for(var i in this.textures){var r=this.textures[i];void 0!=e&&r.mapping!=e||t.push(r)}return t},t.prototype.create=function(e,t){var i=this,r=new THREE.TextureLoader,n=new THREE.CubeTextureLoader,o=this.config.current.textures;this.textures||(this.textures={});var a=function(e){for(var t in e)e[t]=o+e[t];return e};switch(t.mapping){case THREE.CubeReflectionMapping:case THREE.CubeRefractionMapping:case THREE.CubeUVReflectionMapping:case THREE.CubeUVRefractionMapping:this.textures[e]=n.load(a(t.image),function(){i.setParams(e,t)});break;default:this.textures[e]=r.load(o+t.image,function(){i.setParams(e,t)})}},t.prototype.setParams=function(t,i){this.loaded++,this.textures[t].name=t;var r=e.ObjectKeys("Texture");for(var n in r)"image"!=n&&("repeat"==n?this.textures[t].repeat.set(i.repeat.x,i.repeat.y):void 0!=i[n]&&(this.textures[t][n]=i[n]));1==this.config.current.show_gui?this.textures[t].needsUpdate=!0:this.textures[t].needsUpdate=void 0!==i.needsUpdate?i.needsUpdate:!1},t.prototype.add=function(t){var i=t.substr(0,t.indexOf(".")).replace("/","-");if(void 0!=this.textures[i])return void console.warn(i+" texture already defined");var r=e.defaultTexture();return r.image=t,this.create(i,r),i},t.prototype["delete"]=function(e){delete this.textures[e]},t.prototype.save=function(){var e={};for(var t in this.textures){var i=this.textures[t],r=this.params.getParams(i,"Texture");e[i.name]=r}var n=JSON.stringify(e,null,"    "),o="data:text/json;charset=utf8,"+encodeURIComponent(n);window.open(o,"_blank"),window.focus()},t.prototype.text=function(e){function t(e,t,i,r,n,o){for(var a=t.split(" "),s="",c=0;c<a.length;c++){var l=s+a[c]+" ",u=e.measureText(l),h=u.width;h>n?(e.fillText(s,i,r),s=a[c]+" ",r+=o):s=l}e.fillText(s,i,r)}e.size||(e.size=256);var i=e.size,r=e.size,n=document.createElement("canvas");n.width=i,n.height=r;var o=n.getContext("2d");return e.font||(e.font={point:32,family:"Arial"}),e.x=void 0==e.x?e.font.point:e.x,e.y=void 0==e.y?e.font.point:e.y,e.lineHeight=void 0==e.lineHeight?1.5*e.font.point:e.lineHeight,o.fillStyle=void 0==e.fillStyle?"white":e.fillStyle,o.font=e.font.point+"pt "+e.font.family,t(o,e.text,e.x,e.y,e.size,e.lineHeight),n},t}(),i=angular.module("Diwe");i.factory("TextureService",["ConfigService","$interval","$filter","ParamsService",function(e,i,r,n){return new t(e,i,r,n)}])}(Diwe||(Diwe={}));var Diwe;!function(e){var t=function(){function e(e,t,i){this.sound=e,this.config=t,this.params=i,this.index=0,this.merged={}}return e.prototype.init=function(e){if(e&&(this.keyframes=e),this.lastKeyFrame[0]!=this.sound.duration){var t=angular.copy(this.lastKeyFrame);t[0]=this.sound.duration,this.keyframes.push(t)}},Object.defineProperty(e.prototype,"lastKeyFrame",{get:function(){return this.keyframes[this.keyframes.length-1]},enumerable:!0,configurable:!0}),e.prototype.keyframeDelete=function(e,t){var i=this.calcIndexByTime(),r=this.keyframes[i];return r[0]==this.getTime(!0)?void 0==e&&void 0==t?void this.keyframes.splice(i,1):void 0!=e&&void 0==t?void delete r[1][e]:void delete r[1][e][t]:void 0},e.prototype.keyframeAdd=function(e){var t=this.getTime(!0),i=this.getCurrentNext();return i.current.time==t?this.keyframes[i.current.index]=[t,angular.merge(this.keyframes[i.current.index][1],e)]:this.keyframes.splice(i.current.index+1,0,[t,e]),this.keyframes[t]},e.prototype.getTime=function(e){return e?this.round(this.sound.time):this.sound.time},e.prototype.round=function(e){return Math.round(100*e)/100},e.prototype.checkIndex=function(e){return 0>e&&(e=0),e>this.keyframes.length-1&&(e=this.keyframes.length),e},e.prototype.getStat=function(e,t){if(void 0===t.time)return{interval:0,elapsed:0,percent:0};var i=t.time-e.time,r=this.sound.time-e.time;if(0==i)var n=1;else if(0==r)var n=0;else var n=r/i;return{interval:i,elapsed:r,percent:n}},e.prototype.setFrame=function(e,t){if(t||(t=this.getCurrentNext()),t.current){var i=this.getStat(t.current,t.next);if(t.current.name&&t.current.name!=e.currentScene.name&&e.changeScene(t.current.name),t.current.layers)for(var r in t.current.layers){var n=t.current.layers[r];n.addClass&&angular.element("."+r).addClass(n.addClass),n.removeClass&&angular.element("."+r).removeClass(n.removeClass)}if(t.current.fog){var o=e.currentScene.fog.type;this.params.setParams(e.currentScene.fog,o,t.current.fog,t.next.fog?t.next.fog:null,i)}if(t.current.lights)for(var r in t.current.lights)if(e.currentScene.lights[r]){var o=e.currentScene.lights[r].type;this.params.setParams(e.currentScene.lights[r],o,t.current.lights[r],t.next.lights?t.next.lights[r]:null,i)}if(t.current.effects)for(var r in t.current.effects)if(e.currentScene.effects[r]){var o=e.currentScene.effects[r].type;this.params.setParams(e.currentScene.effects[r],o,t.current.effects[r],t.next.effects?t.next.effects[r]:null,i)}if(t.current.cameras)for(var r in t.current.cameras)if(e.currentScene.cameras[r]){var o=e.currentScene.cameras[r].type;this.params.setParams(e.currentScene.cameras[r],o,t.current.cameras[r],t.next.cameras?t.next.cameras[r]:null,i)}if(t.current.objects)for(var r in t.current.objects)if(e.currentScene.objects[r]){var o=e.currentScene.objects[r].type;this.params.setParams(e.currentScene.objects[r],o,t.current.objects[r],t.next.objects?t.next.objects[r]:null,i)}}},e.prototype.calcIndexByTime=function(){var e=0,t=this.getTime(!0);this.config.current.show_gui===!1&&(e=this.index);for(var i=e;i<this.keyframes.length;i++){var r=this.keyframes[i][0];if(r>t)return i-1;if(r==t)return i}return i-1},e.prototype.getCurrentNext=function(){var e=this.calcIndexByTime(),t=this.checkIndex(e),i=this.keyframes[t]?this.keyframes[t][1]:null,r=this.keyframes[t+1]?this.keyframes[t+1][1]:null;return i&&(i.index=t,i.time=this.keyframes[t][0],this.index=t),r&&(r.index=t+1,r.time=this.keyframes[t+1][0]),{current:i,next:r}},e.prototype.mergeFrames=function(e,t){this.merged={};for(var i=e;t>=i;i++)this.keyframes[i][1].name&&(this.merged={}),angular.merge(this.merged,this.keyframes[i][1]);return this.merged},e.prototype.seekByTime=function(e,t){this.sound.time=t;var i=this.calcIndexByTime(),r=this.calcSceneStartByIndex(i),n=this.mergeFrames(r,i);this.setFrame(e,{current:n,next:{}}),e.animateScene(!0)},e.prototype.seekByIndex=function(e,t){var i=this.checkIndex(t),r=this.keyframes[i];this.sound.time=r[0];var n=this.calcSceneStartByIndex(i),o=this.mergeFrames(n,i);this.setFrame(e,{current:o,next:{}}),e.animateScene(!0)},e.prototype.calcSceneStartByIndex=function(e){for(var t=e;t>=0;t--)if(this.keyframes[t][1].name)return t;return 0},e.prototype.calcSceneNextByIndex=function(e,t){for(var i=e;i<=this.keyframes.length;i++)if(this.keyframes[i][1].name&&this.keyframes[i][1].name!=t)return i;return 0},e.prototype.sceneNext=function(e){this.index=this.calcSceneNextByIndex(this.index,e.currentScene.name);var t=this.keyframes[this.index];this.sound.time=t[0],e.animateScene(!0)},e.prototype.scenePrev=function(e){var t=this.calcSceneStartByIndex(this.index);this.index=this.calcSceneStartByIndex(t-1);var i=this.keyframes[this.index];this.sound.time=i[0],e.animateScene(!0)},e.prototype.save=function(){var e=angular.copy(this.keyframes);for(var t in e)delete e[t][1].index,delete e[t][1].time;var i=JSON.stringify(e,null,"    "),r="data:text/json;charset=utf8,"+encodeURIComponent(i);window.open(r,"_blank"),window.focus()},e}(),i=angular.module("Diwe");i.factory("TimelineService",["SoundService","ConfigService","ParamsService",function(e,i,r){return new t(e,i,r)}])}(Diwe||(Diwe={}));
angular.module("Diwe").run(["$templateCache", function($templateCache) {$templateCache.put("views/bottombar.html","<form>\r\n\r\n    <div data-ng-if=\"bottombar.sound.ready\">\r\n\r\n        <label> Seek\r\n            <input type=\"number\" name=\"seek\" step=\"0.1\" data-ng-change=\"bottombar.seek()\" data-ng-max=\"bottombar.sound.duration\" data-ng-model=\"bottombar.sound.time\">\r\n        </label>\r\n        <label data-ng-if=\"bottombar.sound.seekPlayEnabled\"> seekPlayTime\r\n            <input type=\"number\" name=\"seekPlay\" step=\"0.05\" data-ng-min=\"0\" data-ng-max=\"1\" data-ng-model=\"bottombar.sound.seekPlay\">\r\n        </label>\r\n        <label> seekPlayEnabled\r\n        <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"bottombar.sound.seekPlayEnabled\">\r\n        </label>\r\n        <button type=\"button\" name=\"pause\" data-ng-click=\"bottombar.sound.pause()\">pause</button>\r\n    </div>\r\n\r\n\r\n\r\n    <div data-diwe-timeline></div>\r\n\r\n</form>\r\n\r\n");
$templateCache.put("views/camera.html","<label> fov\r\n    <input type=\"number\" step=\"5\" data-ng-model=\"cam.fov\">\r\n</label>\r\n<label> zoom\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"cam.zoom\">\r\n</label>\r\n<label> near\r\n    <input type=\"number\" step=\"5\" data-ng-model=\"cam.near\">\r\n</label>\r\n<label> far\r\n    <input type=\"number\" step=\"5\" data-ng-model=\"cam.far\">\r\n</label>\r\n\r\n\r\n<label> position x\r\n    <input type=\"number\" step=\"10\" data-ng-model=\"cam.position.x\">\r\n</label>\r\n<label> position y\r\n    <input type=\"number\" step=\"10\" data-ng-model=\"cam.position.y\">\r\n</label>\r\n<label> position z\r\n    <input type=\"number\" step=\"10\" data-ng-model=\"cam.position.z\">\r\n</label>\r\n\r\n<label> lookAt x\r\n    <input type=\"number\" step=\"10\" data-ng-model=\"ctrl.lookAt.x\">\r\n</label>\r\n<label> lookAt y\r\n    <input type=\"number\" step=\"10\" data-ng-model=\"ctrl.lookAt.y\">\r\n</label>\r\n<label> lookAt z\r\n    <input type=\"number\" step=\"10\" data-ng-model=\"ctrl.lookAt.z\">\r\n</label>\r\n\r\n<label> scale x\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"cam.scale.x\">\r\n</label>\r\n<label> scale y\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"cam.scale.y\">\r\n</label>\r\n<label> scale z\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"cam.scale.z\">\r\n</label>\r\n\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframeAdd()\">keyframe save</button>\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframeDelete()\">keyframe del</button>");
$templateCache.put("views/demo.html","\r\n\r\n\r\n\r\n<div class=\"layers\">\r\n    <div data-ng-repeat=\"layer in demo.demo.params.layers\" data-ng-style=\"{ \'z-index\': layer.zIndex, \'background-image\': \'url(\' + demo.config.current.data + layer.img.src + \')\' }\" preload-bg-image=\"{{ demo.config.current.data + layer.img.src }}\" class=\"layer {{ layer.class }}\">\r\n    </div>\r\n</div>\r\n<input class=\"controll\" tabindex=\"1\" data-ng-keydown=\"system.keyDown($event)\" data-ng-keyup=\"system.keyUp($event)\">\r\n\r\n");
$templateCache.put("views/diwe.html","<div data-ng-cloak data-ng-controller=\"SystemController as diwe\" data-ng-class=\"{show_gui : diwe.config.current.show_gui}\">\r\n\r\n    <div data-diwe-setup class=\"setup\" data-ng-show=\"system.demo.isState(\'setup\')\"></div>\r\n    <div data-diwe-sidebar class=\"sidebar\" data-ng-show=\"system.demo.isState(\'playing\',\'gte\') && system.config.current.show_gui\"></div>\r\n    <div data-diwe-bottombar class=\"bottombar\" data-ng-show=\"system.demo.isState(\'playing\', \'gte\') && system.config.current.show_gui\"></div>\r\n    <div data-diwe-system class=\"system trackball\"></div>\r\n\r\n</div>");
$templateCache.put("views/effect.html","<label> Enabled\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"effect.enabled\">\r\n</label>\r\n\r\n<!--<label> Clear-->\r\n<!--<input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"effect.clear\"/>-->\r\n<!--</label>-->\r\n\r\n<!--<label> NeedSwap-->\r\n<!--<input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"effect.needsSwap\"/>-->\r\n<!--</label>-->\r\n\r\n<div data-ng-if=\"name == \'ssao\'\">\r\n\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"effect.uniforms.aoClamp.value\">\r\n    <input type=\"number\" step=\"50\" data-ng-model=\"effect.uniforms.cameraFar.value\">\r\n    <input type=\"number\" step=\"50\" data-ng-model=\"effect.uniforms.cameraNear.value\">\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"effect.uniforms.lumInfluence.value\">\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"effect.uniforms.onlyAO.value\">\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'focus\'\">\r\n\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.uniforms.sampleDistance.value\">\r\n    <input type=\"number\" step=\"0.001\" data-ng-model=\"effect.uniforms.waveFactor.value\">\r\n\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'mirror\'\">\r\n\r\n    <input type=\"number\" step=\"1\" data-ng-model=\"effect.uniforms.side.value\">\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'bleach\'\">\r\n\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"effect.uniforms.opacity.value\">\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'vignette\'\">\r\n\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.uniforms.darkness.value\">\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'film\'\">\r\n\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"effect.uniforms.grayscale.value\">\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.uniforms.nIntensity.value\">\r\n    <input type=\"number\" step=\"50\" data-ng-model=\"effect.uniforms.sCount.value\">\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"effect.uniforms.sIntensity.value\">\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"effect.uniforms.time.value\">\r\n\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'bloom\'\">\r\n\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.copyUniforms.opacity.value\">\r\n\r\n</div>\r\n\r\n\r\n<div data-ng-if=\"name == \'rgbShift\'\">\r\n\r\n    <input type=\"number\" step=\"0.0005\" data-ng-model=\"effect.uniforms.amount.value\">\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'dotScreen\'\">\r\n\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"effect.uniforms.angle.value\">\r\n\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"effect.uniforms.scale.value\">\r\n\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'horizontalTiltShift\'\">\r\n\r\n    <input type=\"number\" step=\"0.001\" data-ng-model=\"effect.uniforms.h.value\">\r\n\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.uniforms.r.value\">\r\n\r\n</div>\r\n\r\n\r\n<div data-ng-if=\"name == \'colorify\'\">\r\n\r\n    <input type=\"color\" data-ng-model=\"ctrl.uniformsColor\">\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'brightnessContrast\'\">\r\n\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.uniforms.brightness.value\">\r\n\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.uniforms.contrast.value\">\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'hueSaturation\'\">\r\n\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.uniforms.hue.value\">\r\n\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"effect.uniforms.saturation.value\">\r\n\r\n</div>\r\n\r\n<div data-ng-if=\"name == \'verticalBlur\'\">\r\n\r\n    <input type=\"number\" step=\"0.001\" data-ng-model=\"effect.uniforms.v.value\">\r\n\r\n\r\n</div>\r\n\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframe(name)\">keyframe save</button>\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframeDelete(name)\">keyframe del</button>\r\n");
$templateCache.put("views/fog.html","<input type=\"color\" data-ng-model=\"ctrl.color\">\r\n\r\n<div data-ng-if=\"fog.type == \'ExpFog\'\">\r\n    <input type=\"number\" step=\"0.00001\" data-ng-model=\"fog.density\">\r\n</div>\r\n\r\n<div data-ng-if=\"fog.type == \'DefaultFog\'\">\r\n    <input type=\"number\" data-ng-model=\"fog.near\">\r\n    <input type=\"number\" data-ng-model=\"fog.far\">\r\n</div>\r\n\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframeAdd()\">keyframe save</button>\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframeDelete()\">keyframe del</button>");
$templateCache.put("views/light.html","<label> Visible\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"light.visible\">\r\n</label>\r\n<input type=\"color\" data-ng-model=\"ctrl.color\">\r\n\r\n\r\n<div data-ng-if=\"light.type == \'PointLight\' || light.type == \'SpotLight\'\">\r\n\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"light.intensity\">\r\n\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"light.distance\">\r\n\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"light.decay\">\r\n\r\n    <label> position x\r\n        <input type=\"number\" step=\"10\" data-ng-model=\"light.position.x\">\r\n    </label>\r\n    <label> position y\r\n        <input type=\"number\" step=\"10\" data-ng-model=\"light.position.y\">\r\n    </label>\r\n    <label> position z\r\n        <input type=\"number\" step=\"10\" data-ng-model=\"light.position.z\">\r\n    </label>\r\n</div>\r\n\r\n<div data-ng-if=\"light.type == \'SpotLight\'\">\r\n\r\n    <input type=\"number\" step=\"0.1\" data-ng-model=\"light.exponent\">\r\n\r\n</div>\r\n\r\n<label> Cast Shadow\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"light.castShadow\">\r\n</label>\r\n\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframeAdd()\">keyframe save</button>\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframeDelete()\">keyframe del</button>");
$templateCache.put("views/material.html","\r\n<label> Visible\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.visible\">\r\n</label>\r\n\r\n<label> Transparent\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.transparent\">\r\n</label>\r\n\r\n<label> Skinning\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.skinning\">\r\n</label>\r\n\r\n<label> fog\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.fog\">\r\n</label>\r\n\r\n<label> depthTest\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.depthTest\">\r\n</label>\r\n<label> depthWrite\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.depthWrite\">\r\n</label>\r\n\r\n<label> map\r\n    <select data-ng-model=\"map\" data-ng-change=\"ctrl.changeTexture(map, \'map\')\">\r\n        <option value=\"null\">null</option>\r\n        <option value=\"{{ texture.name }}\" data-ng-repeat=\"texture in ctrl.texture.list(300)\">{{ texture.name }}</option>\r\n    </select>\r\n</label>\r\n\r\n<label> alphaMap\r\n    <select data-ng-model=\"alphaMap\" data-ng-change=\"ctrl.changeTexture(alphaMap, \'alphaMap\')\">\r\n        <option value=\"null\">null</option>\r\n        <option value=\"{{ texture.name }}\" data-ng-repeat=\"texture in ctrl.texture.list(300)\">{{ texture.name }}</option>\r\n    </select>\r\n</label>\r\n\r\n<label> lightMap\r\n    <select data-ng-model=\"lightMap\" data-ng-change=\"ctrl.changeTexture(lightMap, \'lightMap\')\">\r\n        <option value=\"null\">null</option>\r\n        <option value=\"{{ texture.name }}\" data-ng-repeat=\"texture in ctrl.texture.list(300)\">{{ texture.name }}</option>\r\n    </select>\r\n</label>\r\n\r\n<label> envMap\r\n    <select data-ng-model=\"envMap\" data-ng-change=\"ctrl.changeTexture(envMap, \'envMap\')\">\r\n        <option value=\"null\">null</option>\r\n        <option value=\"{{ texture.name }}\" data-ng-repeat=\"texture in ctrl.texture.list(301)\">{{ texture.name }}</option>\r\n    </select>\r\n</label>\r\n\r\n\r\n<label> opacity\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"material.opacity\">\r\n</label>\r\n\r\n<label> bumpMap\r\n    <select data-ng-model=\"bumpMap\" data-ng-change=\"ctrl.changeTexture(bumpMap, \'bumpMap\')\">\r\n        <option value=\"null\">null</option>\r\n        <option value=\"{{ texture.name }}\" data-ng-repeat=\"texture in ctrl.texture.list(300)\">{{ texture.name }}</option>\r\n    </select>\r\n</label>\r\n\r\n<label> bumpScale\r\n    <input type=\"number\" step=\"0.5\" data-ng-model=\"material.bumpScale\">\r\n</label>\r\n\r\n<label> reflectivity\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"material.reflectivity\">\r\n</label>\r\n\r\n<label> refractionRatio\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"material.refractionRatio\">\r\n</label>\r\n\r\n<label> shininess\r\n    <input type=\"number\" step=\"0.5\" data-ng-model=\"material.shininess\">\r\n</label>\r\n\r\n<label> blending\r\n    <input type=\"number\" step=\"1\" data-ng-model=\"material.blending\">\r\n</label>\r\n\r\n<label> shading\r\n    <input type=\"number\" step=\"1\" data-ng-model=\"material.shading\">\r\n</label>\r\n\r\n<label> side\r\n    <input type=\"number\" step=\"1\" data-ng-model=\"material.side\">\r\n</label>\r\n\r\n<label> size\r\n    <input type=\"number\" step=\"1\" data-ng-model=\"material.size\">\r\n</label>\r\n\r\n<label> combine\r\n    <input type=\"number\" step=\"1\" data-ng-model=\"material.combine\">\r\n</label>\r\n\r\n\r\n<label> Wireframe\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.wireframe\">\r\n</label>\r\n\r\n<div data-ng-if=\"material.wireframe\">\r\n\r\n    <label> Linewidth\r\n        <input type=\"number\" step=\"1\" data-ng-model=\"material.wireframeLinewidth\">\r\n    </label>\r\n\r\n</div>\r\n\r\n\r\n");
$templateCache.put("views/mesh.html","\r\n<label> Visible\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"mesh.visible\">\r\n</label>\r\n\r\n<label> position x\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.position.x\">\r\n</label>\r\n<label> position y\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.position.y\">\r\n</label>\r\n<label> position z\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.position.z\">\r\n</label>\r\n\r\n<label> rotation x\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.rotation.x\">\r\n</label>\r\n<label> rotation y\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.rotation.y\">\r\n</label>\r\n<label> rotation z\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.rotation.z\">\r\n</label>\r\n\r\n<label> scale x\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.scale.x\">\r\n</label>\r\n<label> scale y\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.scale.y\">\r\n</label>\r\n<label> scale z\r\n    <input type=\"number\" step=\"0.05\" data-ng-model=\"mesh.scale.z\">\r\n</label>\r\n\r\n<label> Material\r\n    <select data-ng-model=\"materialName\" data-ng-change=\"ctrl.changeMaterial(materialName)\">\r\n        <option value=\"null\">null</option>\r\n        <option value=\"{{ material.name }}\" data-ng-repeat=\"material in ctrl.material.materials\">{{ material.name }}</option>\r\n    </select>\r\n</label>\r\n\r\n<label> Receive Shadow\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"mesh.receiveShadow\">\r\n</label>\r\n\r\n<label> Cast Shadow\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"mesh.castShadow\">\r\n</label>\r\n\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframe(mesh.name)\">keyframe save</button>\r\n<button type=\"button\" data-ng-click=\"ctrl.keyframeDelete(mesh.name)\">keyframe del</button>");
$templateCache.put("views/setup.html","<div class=\"row\">\r\n\r\n    <div class=\"start col-md-6\">\r\n\r\n        <div class=\"col-md-12 header text-center\">\r\n            <h1>{{ setup.demo.params.title }}</h1>\r\n            <i>{{ setup.demo.params.subtitle }}</i> /\r\n            <i><a href=\"{{ setup.demo.params.party.link }}\">{{ setup.demo.params.party.title }}</a></i>\r\n            <br>\r\n            <i>{{ setup.demo.params.description }}</i>\r\n            <br>\r\n\r\n            <div data-ng-repeat=\"member in setup.demo.params.credits\">\r\n                <i>{{ member.title }} : <span data-ng-if=\"member.link\"> <a href=\"{{ member.link }}\"> {{ member.nickname\r\n                    }}</a> </span>\r\n                    <span data-ng-if=\"!member.link\"> {{ member.nickname }} </span>\r\n                </i>\r\n            </div>\r\n            <i>Our first WebGL demo: <a href=\"http://www.dilemma.ws/demo/state-zero-one\" target=\"_blank\">State\r\n                Zero-One</a></i>\r\n\r\n        </div>\r\n\r\n        <div class=\"col-md-12 header text-center\">\r\n\r\n            <br>\r\n            <h4><span class=\"label label-warning\">Google Chrome required</span></h4>\r\n            <h4>Press <span class=\"label label-warning\">F11</span> before start</h4>\r\n            <br>\r\n            <button class=\"btn btn-primary\" data-ng-disabled=\"(!setup.available.audio || !setup.available.canvas || !setup.available.webgl)\" data-ng-click=\"setup.demo.start()\">START DEMO\r\n            </button>\r\n\r\n            <span data-ng-if=\"setup.demo.params.online && setup.offline\">\r\n                <a class=\"btn btn-default\" href=\"{{ setup.demo.params.online }}\" target=\"_blank\">Online version</a>\r\n            </span>\r\n\r\n            <br>\r\n\r\n            <h2>Setup</h2>\r\n\r\n            <form name=\"form\" class=\"options\">\r\n\r\n\r\n                <span> preset\r\n                <select data-ng-model=\"setup.config.preset\" data-ng-change=\"setup.config.setCurrent()\">\r\n                    <option data-ng-repeat=\"(preset,config) in setup.config.presets\" value=\"{{ preset }}\">{{ preset }}\r\n                    </option>\r\n                </select>\r\n                </span>\r\n\r\n                <span> volume\r\n                  <input data-ng-model=\"setup.config.current.volume\" type=\"number\" min=\"0\" max=\"100\" maxlength=\"2\">\r\n                </span>\r\n                <br>\r\n                <span> show FPS\r\n                    <input data-ng-model=\"setup.config.current.show_fps\" type=\"checkbox\">\r\n                </span>\r\n                <span> limit FPS\r\n                    <input data-ng-model=\"setup.config.current.limit_fps\" type=\"checkbox\">\r\n                </span>\r\n                <span data-ng-if=\"setup.config.current.limit_fps\">\r\n                    <span> max FPS\r\n                        <input data-ng-model=\"setup.config.current.max_fps\" type=\"number\" min=\"1\" max=\"60\">\r\n                    </span>\r\n                </span>\r\n\r\n            </form>\r\n\r\n            <h2>Controls</h2>\r\n\r\n\r\n            <h4 data-ng-if=\"setup.config.current.controls\">The editor and the GUI is <span class=\"label label-warning\">under construction</span>\r\n            </h4>\r\n\r\n            <div class=\"col-xs-6 col-xs-offset-4 text-left\">\r\n\r\n                <div data-ng-repeat=\"control in setup.demo.params.controls\">\r\n                <span data-ng-if=\"!control.editor\" class=\"text-nowrap\">\r\n                  <span class=\"label label-default\">{{ control.label}}</span> - {{ control.text }}\r\n                </span>\r\n                <span data-ng-if=\"control.editor && setup.config.current.controls\" class=\"text-nowrap\">\r\n                    <span class=\"label label-default\">{{ control.label}}</span> - {{ control.text }}\r\n                </span>\r\n                </div>\r\n            </div>\r\n\r\n        </div>\r\n\r\n        <div class=\"clearfix\"><br><br></div>\r\n\r\n    </div>\r\n\r\n\r\n    <div class=\"text col-md-6 text-center\">\r\n\r\n\r\n        <div class=\"section requirements col-md-8 col-md-offset-2\">\r\n            <h2>Requirements</h2>\r\n\r\n            Graphic card with <a href=\"http://www.opengl.org\" target=\"_blank\">OpenGL ES 2.0</a>\r\n            support and modern web browser (preffered\r\n            <a href=\"http://www.google.com/chrome\" target=\"_blank\">Google Chrome</a>) with the following features:\r\n\r\n            <br>\r\n            <br>\r\n\r\n            <a href=\"http://www.w3schools.com/html/html5_canvas.asp\" target=\"_blank\">HTML5 canvas</a> -\r\n                            <span class=\"label label-success\" data-ng-if=\"setup.available.canvas == true\">available</span>\r\n            <span class=\"label label-danger\" data-ng-if=\"!setup.available.canvas\">not available</span>\r\n\r\n            <br>\r\n\r\n            <a href=\"http://www.w3schools.com/html/html5_audio.asp\" target=\"_blank\">HTML5 audio</a> -\r\n            <span class=\"label label-success\" data-ng-if=\"setup.available.audio\">available</span>\r\n            <span class=\"label label-danger\" data-ng-if=\"!setup.available.audio\">not available</span>\r\n\r\n            <br>\r\n\r\n            <a href=\"http://www.khronos.org/webgl\" target=\"_blank\">WebGL</a> -\r\n            <span class=\"label label-success\" data-ng-if=\"setup.available.webgl\">available</span>\r\n\r\n\r\n        </div>\r\n\r\n        <div class=\"section greetings col-md-8 col-md-offset-2\">\r\n            <h2>Greetings and thanks to</h2>\r\n            <a href=\"https://github.com/mrdoob/three.js/\" target=\"_blank\">three.js</a>\r\n            - Javascript 3D Engine for WebGL\r\n            <br>\r\n            <a href=\"https://github.com/lialosiu/dancer.js\" target=\"_blank\">dancer.js</a>\r\n            - high-level audio API, designed to make sweet visualizations\r\n            <br>\r\n            <a href=\"https://sites.google.com/site/topmod3d/\" target=\"_blank\">TopMod</a>\r\n            - Topological Mesh Modeler\r\n            <br>\r\n            <a href=\"https://angularjs.org/\" target=\"_blank\">AngularJS</a>\r\n            - Superheroic JavaScript MVW Framework\r\n            <br>\r\n            <a href=\"https://www.typescriptlang.org/\" target=\"_blank\">TypeScript</a>\r\n            - TypeScript is a typed superset of JavaScript that compiles to plain JavaScript\r\n            <br>\r\n            and\r\n            <a href=\"https://www.npmjs.com/\" target=\"_blank\">npm</a>,\r\n            <a href=\"http://gulpjs.com/\" target=\"_blank\">Gulp</a>,\r\n            <a href=\"http://bower.io/\" target=\"_blank\">Bower</a>,\r\n            <a href=\"https://github.com/typings/\" target=\"_blank\">Typings</a>,\r\n            <a href=\"http://jquery.com/\" target=\"_blank\">Jquery</a>,\r\n            <a href=\"http://getbootstrap.com/\" target=\"_blank\">Bootstrap</a>,\r\n            <a href=\"http://modernizr.com/\" target=\"_blank\">Modernizr</a>,\r\n            <a href=\"http://www.blender.org/\" target=\"_blank\">Blender</a>\r\n\r\n        </div>\r\n\r\n        <div class=\"section important col-md-8 col-md-offset-2\">\r\n            <h2>How to run locally</h2>\r\n\r\n            <span class=\"label label-default\">Google Chrome</span> : start with this parameters: \"chrome.exe\r\n            --allow-file-access-from-files\r\n            --disable-web-security\"\r\n            <br>\r\n            <span class=\"label label-default\">Mozilla Firefox</span> : write \"about:config\" in the address bar and hit\r\n            enter.\r\n            Set\r\n            security.fileuri.strict_origin_policy to false and restart the browser.\r\n            <strong class=\"label label-warning\">For your security set it back to true</strong> after viewed the\r\n            demo\r\n\r\n        </div>\r\n\r\n    </div>\r\n\r\n    <div class=\"clearfix\"><br><br></div>\r\n\r\n</div>");
$templateCache.put("views/shaders.html","<script id=\"vertexShaderNap\" type=\"x-shader/x-vertex\">\r\n\r\n    void main()	{\r\n\r\n        gl_Position = vec4( position, 1.0 );\r\n\r\n    }\r\n\r\n\r\n</script>\r\n\r\n<script id=\"fragmentShaderNap\" type=\"x-shader/x-fragment\">\r\n\r\n    uniform vec2 resolution;\r\n    uniform float time;\r\n\r\n    float PI=3.14159265358979323846;\r\n\r\n    float speed=time*0.2975;\r\n    float ground_x=0.0-0.325*sin(PI*speed*0.25);\r\n    float ground_y=0.0;\r\n    float ground_z=0.0;\r\n\r\n    vec2 rotate(vec2 k,float t)\r\n    {\r\n        return vec2(cos(t)*k.x-sin(t)*k.y,sin(t)*k.x+cos(t)*k.y);\r\n    }\r\n\r\n    float scene(vec3 p)\r\n    {\r\n        float bar_p=1.0;\r\n        float bar_w=bar_p*0.1;\r\n        float bar_x=length(max(abs(mod(p.yz,bar_p)-bar_p*0.5)-bar_w,0.0));\r\n        float bar_y=length(max(abs(mod(p.xz,bar_p)-bar_p*0.5)-bar_w,0.0));\r\n        float bar_z=length(max(abs(mod(p.xy,bar_p)-bar_p*0.5)-bar_w,0.0));\r\n        return -max(max(-bar_x,-bar_y),-bar_z);\r\n    }\r\n\r\n    void main()\r\n    {\r\n        vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy;\r\n        vec3 dir=normalize(vec3(p*vec2(1.77,1.0),1.0));\r\n        dir.zx=rotate(dir.zx,-PI*speed*0.15);\r\n        dir.xy=rotate(dir.xy,-speed*0.75);\r\n        vec3 ray=vec3(ground_x,ground_y,ground_z-speed*0.5);\r\n\r\n        float t=0.0;\r\n        const int raynum=128;\r\n        for(int i=0;i<raynum;i++)\r\n        {\r\n            float k=scene(ray+dir*t);\r\n            t+=k*0.5;\r\n        }\r\n\r\n        vec3 hit=ray+dir*t;\r\n        vec2 h=vec2(0.005,-0.005);\r\n        vec3 n=normalize(vec3(scene(hit+h.xyy),scene(hit+h.yxx),scene(hit+h.yyx)));\r\n        float c=(n.x+n.y+n.z)*0.25+t*0.025;\r\n        vec3 color=vec3(c*t*0.125);//+vec3(0.05);\r\n\r\n        gl_FragColor = vec4(color,1.0);\r\n        return;\r\n    }\r\n\r\n\r\n\r\n\r\n</script>");
$templateCache.put("views/sidebar.html","<div class=\"frame\">\r\n\r\n    <form name=\"form\">\r\n\r\n        <div class=\"panel\">\r\n\r\n            <h3 data-ng-click=\"panel.main = !panel.main\">Main</h3>\r\n\r\n            <div data-ng-if=\"panel.main\" class=\"inputs\">\r\n                <label> FPS\r\n                    <input type=\"number\" name=\"fpx\" min=\"1\" max=\"512\" data-ng-model=\"sidebar.config.current.max_fps\">\r\n                </label>\r\n\r\n                <label> Volume\r\n                    <input type=\"number\" name=\"volume\" min=\"0\" max=\"100\" data-ng-model=\"bottombar.sound.volume\">\r\n                </label>\r\n            </div>\r\n\r\n        </div>\r\n\r\n        <div data-ng-if=\"sidebar.demo.currentScene\">\r\n\r\n            <div class=\"panel\">\r\n\r\n                <h3 data-ng-click=\"panel.scene = !panel.scene\">Scene</h3>\r\n\r\n                <div data-ng-if=\"panel.scene\" class=\"inputs\">\r\n\r\n                    <select name=\"currentSceneName\" data-ng-change=\"sidebar.demo.changeScene()\" data-ng-model=\"sidebar.demo.currentSceneName\">\r\n                        <option value=\"\">-timeline</option>\r\n                        <option ng-repeat=\"scene in sidebar.demo.scenes\" value=\"{{ scene.name }}\">{{ scene.name }}\r\n                        </option>\r\n\r\n                    </select>\r\n\r\n                </div>\r\n            </div>\r\n\r\n            <div data-ng-if=\"1 == 2\" class=\"panel\">\r\n\r\n                <select name=\"selectEffect\" data-ng-model=\"sidebar.demo.currentScene.cameraActive\" data-ng-change=\"sidebar.demo.changeCamera()\">\r\n                    <option></option>\r\n                    <option ng-repeat=\"(key, cam) in sidebar.demo.currentScene.cameras\" value=\"{{ key }}\">\r\n                        {{ key }}\r\n                    </option>\r\n                </select>\r\n\r\n                <div>{{ sidebar.demo.currentScene.cameraActive }}</div>\r\n\r\n            </div>\r\n\r\n            <div class=\"panel\" data-ng-if=\"sidebar.demo.currentScene.fog\">\r\n\r\n                <h3 data-ng-click=\"panel.fog = !panel.fog\">Fog</h3>\r\n\r\n                <div data-ng-if=\"panel.fog\" class=\"inputs\">\r\n                    <div data-diwe-fog fog=\"sidebar.demo.currentScene.fog\"></div>\r\n                </div>\r\n\r\n            </div>\r\n\r\n            <div class=\"panel\">\r\n\r\n                <h3 data-ng-click=\"panel.effects = !panel.effects\">Effects</h3>\r\n\r\n                <div data-ng-if=\"panel.effects\" class=\"inputs\">\r\n\r\n                    <select name=\"selectEffect\" data-ng-model=\"sidebar.selectedEffect\">\r\n                        <option></option>\r\n                        <option ng-repeat=\"(key, effect) in sidebar.demo.currentScene.effects\" value=\"{{ key }}\">\r\n                            {{ key }}\r\n                        </option>\r\n                    </select>\r\n\r\n                    <label> On/off\r\n                        <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"diwe.config.current.effects\">\r\n                    </label>\r\n\r\n                    <button data-ng-click=\"sidebar.disableEffects()\" type=\"button\">Disable all</button>\r\n\r\n                    <div data-diwe-effect data-ng-if=\"sidebar.selectedEffect\" name=\"sidebar.selectedEffect\" effect=\"sidebar.demo.currentScene.effects[sidebar.selectedEffect]\"></div>\r\n\r\n                </div>\r\n\r\n            </div>\r\n\r\n\r\n            <div class=\"panel\">\r\n\r\n                <h3 data-ng-click=\"panel.lights = !panel.lights\">Lights</h3>\r\n\r\n                <div data-ng-if=\"panel.lights\" class=\"inputs\">\r\n\r\n                    <select name=\"selectedLight\" data-ng-model=\"selectedLight\">\r\n                        <option ng-repeat=\"light in sidebar.demo.currentScene.lights\" value=\"{{ light.name }}\">\r\n                            {{ light.name }} | {{ light.type }}\r\n                        </option>\r\n                    </select>\r\n\r\n                    <div data-ng-if=\"sidebar.demo.currentScene.lights[selectedLight]\" data-diwe-light light=\"sidebar.demo.currentScene.lights[selectedLight]\"></div>\r\n\r\n                </div>\r\n\r\n            </div>\r\n\r\n            <div class=\"panel\">\r\n\r\n                <h3 data-ng-click=\"panel.cameras = !panel.cameras\">Cameras</h3>\r\n\r\n                <div data-ng-if=\"panel.cameras\" class=\"inputs\">\r\n\r\n                    <select name=\"selectedCamera\" data-ng-model=\"selectedCamera\">\r\n                        <option ng-repeat=\"camera in sidebar.demo.currentScene.cameras\" value=\"{{ camera.name }}\">\r\n                            {{ camera.name }} | {{ camera.type }}\r\n                        </option>\r\n                    </select>\r\n\r\n                    <div data-ng-if=\"sidebar.demo.currentScene.cameras[selectedCamera]\" data-diwe-camera cam=\"sidebar.demo.currentScene.cameras[selectedCamera]\"></div>\r\n\r\n                </div>\r\n\r\n            </div>\r\n\r\n            <div class=\"panel\">\r\n\r\n                <h3 data-ng-click=\"panel.objects = !panel.objects\">Objects</h3>\r\n\r\n                <div data-ng-if=\"panel.objects\" class=\"inputs\">\r\n\r\n                    <select name=\"selectedObject\" data-ng-model=\"selectedObject\">\r\n                        <option ng-repeat=\"(key,object) in sidebar.demo.currentScene.objects\" value=\"{{ key }}\">\r\n                            {{ object.name }} | {{ object.type }}\r\n                        </option>\r\n                    </select>\r\n\r\n                    <span data-ng-switch=\"selectedObject\">\r\n                        <div data-diwe-mesh mesh=\"sidebar.demo.currentScene.objects[selectedObject]\"></div>\r\n                    </span>\r\n\r\n                </div>\r\n\r\n            </div>\r\n\r\n            <div class=\"panel\">\r\n\r\n                <h3 data-ng-click=\"panel.materials = !panel.materials\">Materials</h3>\r\n\r\n                <div data-ng-if=\"panel.materials\" class=\"inputs\">\r\n\r\n                    <select name=\"selectMaterial\" data-ng-model=\"selectedMaterial\">\r\n                        <option ng-repeat=\"(key, material) in sidebar.demo.currentScene.materials\" value=\"{{ key }}\">\r\n                            {{ material.name ? material.name : key }} | {{ material.type }}\r\n                        </option>\r\n                    </select>\r\n\r\n                    <div data-ng-if=\"sidebar.demo.currentScene.materials[selectedMaterial]\" data-diwe-material material=\"sidebar.demo.currentScene.materials[selectedMaterial]\"></div>\r\n\r\n                    <button data-ng-click=\"sidebar.saveMaterials()\" type=\"button\">Export materials.json</button>\r\n\r\n                </div>\r\n\r\n            </div>\r\n\r\n\r\n            <div class=\"panel\">\r\n\r\n                <h3 data-ng-click=\"panel.textures = !panel.textures\">Textures</h3>\r\n\r\n                <div data-ng-if=\"panel.textures\" class=\"inputs\">\r\n\r\n                    <input data-ng-model=\"newTextureUrl\" placeholder=\"new texture url\" type=\"text\">\r\n                    <button data-ng-click=\"sidebar.newTexture(newTextureUrl);\" type=\"button\">Add new texture</button>\r\n\r\n                    <select name=\"selectTexture\" data-ng-model=\"selectTexture\">\r\n                        <option ng-repeat=\"(key, texture) in sidebar.demo.texture.textures\" value=\"{{ key }}\">\r\n                            {{ texture.name ? texture.name : key }} | {{ texture.type }}\r\n                        </option>\r\n                    </select>\r\n\r\n                    <div data-ng-if=\"sidebar.demo.texture.textures[selectTexture]\" data-diwe-texture texture=\"sidebar.demo.texture.textures[selectTexture]\"></div>\r\n\r\n                    <button data-ng-click=\"sidebar.saveTextures()\" type=\"button\">Export textures.json</button>\r\n\r\n                </div>\r\n\r\n            </div>\r\n\r\n\r\n            <button data-ng-click=\"sidebar.timeline.save()\" type=\"button\">Export timeline.js</button>\r\n\r\n\r\n        </div>\r\n\r\n    </form>\r\n</div>");
$templateCache.put("views/system.html","<div class=\"loading\" data-ng-if=\"system.demo.isState(\'loading\')\">\r\n    <div class=\"bar\" data-ng-style=\"{ width: system.demo.loading().overall.percent + \'%\' }\"></div>\r\n</div>\r\n<div data-diwe-demo class=\"demo\" data-ng-show=\"system.demo.isState(\'loading\',\'gte\')\" tabindex=\"0\"></div>\r\n\r\n\r\n");
$templateCache.put("views/texture.html","<button data-ng-click=\"ctrl.deleteTexture()\" type=\"button\">Delete texture</button>\r\n\r\n<label> image\r\n    <img style=\"width: 100%; height: auto\" data-ng-src=\"{{texture.image.src}}\">\r\n</label>\r\n\r\n<label> mapping\r\n    <select data-ng-model=\"texture.mapping\" data-ng-change=\"ctrl.changeTexture()\" data-ng-options=\"ctrl.mappingOptions[key] as key for (key, value) in ctrl.mappingOptions\">\r\n    </select>\r\n</label>\r\n\r\n\r\n<label> repeat x\r\n    <input type=\"number\" step=\"1\" data-ng-change=\"ctrl.changeTexture()\" data-ng-model=\"texture.repeat.x\">\r\n</label>\r\n\r\n<label> repeat y\r\n    <input type=\"number\" step=\"1\" data-ng-change=\"ctrl.changeTexture()\" data-ng-model=\"texture.repeat.y\">\r\n</label>\r\n\r\n<label> offset x\r\n    <input type=\"number\" step=\"0.05\" data-ng-change=\"ctrl.changeTexture()\" data-ng-model=\"texture.offset.x\">\r\n</label>\r\n\r\n<label> offset y\r\n    <input type=\"number\" step=\"0.05\" data-ng-change=\"ctrl.changeTexture()\" data-ng-model=\"texture.offset.y\">\r\n</label>\r\n\r\n<label> anisotropy\r\n    <input type=\"number\" step=\"1\" data-ng-change=\"ctrl.changeTexture()\" data-ng-model=\"texture.anisotropy\">\r\n</label>\r\n\r\n\r\n<label> wrapS\r\n    <select data-ng-model=\"texture.wrapS\" data-ng-change=\"ctrl.changeTexture()\" data-ng-options=\"ctrl.wrapOptions[key] as key for (key, value) in ctrl.wrapOptions\">\r\n    </select>\r\n</label>\r\n\r\n<label> wrapT\r\n    <select data-ng-model=\"texture.wrapT\" data-ng-change=\"ctrl.changeTexture()\" data-ng-options=\"ctrl.wrapOptions[key] as key for (key, value) in ctrl.wrapOptions\">\r\n    </select>\r\n</label>\r\n\r\n\r\n<label> format\r\n    <select data-ng-model=\"texture.format\" data-ng-change=\"ctrl.changeTexture()\" data-ng-options=\"ctrl.formatOptions[key] as key for (key, value) in ctrl.formatOptions\">\r\n    </select>\r\n</label>\r\n\r\n<label> encoding\r\n    <select data-ng-model=\"texture.encoding\" data-ng-change=\"ctrl.changeTexture()\" data-ng-options=\"ctrl.encodingOptions[key] as key for (key, value) in ctrl.encodingOptions\">\r\n    </select>\r\n</label>\r\n\r\n<label> type\r\n    <select data-ng-model=\"texture.type\" data-ng-change=\"ctrl.changeTexture()\" data-ng-options=\"ctrl.typeOptions[key] as key for (key, value) in ctrl.typeOptions\">\r\n    </select>\r\n</label>\r\n\r\n<label> flipY\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.flipY\">\r\n</label>\r\n\r\n<label> premultiplyAlpha\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.premultiplyAlpha\">\r\n</label>\r\n\r\n<label> generateMipmaps\r\n    <input type=\"checkbox\" data-ng-true-value=\"true\" data-ng-false-value=\"false\" data-ng-model=\"material.generateMipmaps\">\r\n</label>\r\n\r\n\r\n<label> magFilter\r\n    <select data-ng-model=\"texture.magFilter\" data-ng-change=\"ctrl.changeTexture()\" data-ng-options=\"ctrl.magFilterOptions[key] as key for (key, value) in ctrl.magFilterOptions\">\r\n    </select>\r\n</label>\r\n\r\n<label> minFilter\r\n    <select data-ng-model=\"texture.minFilter\" data-ng-change=\"ctrl.changeTexture()\" data-ng-options=\"ctrl.minFilterOptions[key] as key for (key, value) in ctrl.minFilterOptions\">\r\n    </select>\r\n</label>\r\n");
$templateCache.put("views/timeline.html","<div class=\"timeline\" data-ng-click=\"timeline.setPercent($event)\">\r\n    <div class=\"pointer\" ng-style=\"{ \'width\' : timeline.percent + \'%\' }\"></div>\r\n</div>\r\n\r\n\r\n");}]);