#version 110
// Simple vertex shader.
// Transforms and projects vertices and calculates parameters for lighting.

// Attributes: Position, normal, texture coordinates
attribute vec4 vertex;
attribute vec3 vnormal;
attribute vec2 texcoords;

// Same for the whole model or scene: Projection and Modelview matrices
uniform mat4 projection;
uniform mat4 polyview;
uniform mat4 cubeview;

// Parameters passed to the fragment shader.
varying vec3 unnormal;
varying vec2 texcoord;
varying vec4 unppos;

// Parameters
uniform int drawDistfield;

void main() {
	// Texture coordinates are passed through
	texcoord = texcoords;
	
	// Project and send to the fragment shader
	if( drawDistfield == 1 ) {
		gl_Position = vertex;
	}
	else {
		mat4 cubenorm = inverse( transpose( cubeview ) );
		
		unppos = vertex * cubeview;
		unnormal = normalize( vec4(vnormal,1.0) * cubenorm ).xyz;
		gl_Position = unppos * polyview * projection;
	}
}
