#version 110
// Simple fragment shader.
// Does texturing and phong shading.

// Parameters from the vertex shader or app
varying vec4 unppos;
varying vec3 unnormal;
varying vec2 texcoord;
uniform mat4 normalview;
uniform mat4 worldview;
uniform mat4 projection;
uniform int drawDistfield;

// Textures
uniform sampler2D texture;

// Other
uniform float time;

vec3 lightpos = vec3( 0.0, 0.0, 0.0);

float pnc(vec3 p) {
   vec3 i = floor(p);
   vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
   vec3 f = cos((p-i)*3.14)*(-.5) + .5;
   a = mix(sin(cos(a)*a), sin(cos(1.+a)*(1.+a)), f.x);
   a.xy = mix(a.xz, a.yw, f.y);
   return mix(a.x, a.y, f.z);
}

float pn(vec3 p) {
	int ix = int(floor(p.x));
	int iy = int(floor(p.y));
	int iz = int(floor(p.z));

	float ax = float(ix) * 1.0 + float(iy) * 57.0 + float(iz) * 21.0;
	float ay = ax + 57.0;
	float az = ax + 21.0;
	float aw = ax + 78.0;
	
	float fx = cos((p.x-ix)*3.14)*(-0.5) + 0.5;
	float fy = cos((p.y-iy)*3.14)*(-0.5) + 0.5;
	float fz = cos((p.z-iz)*3.14)*(-0.5) + 0.5;
	
	float a1x = sin(cos(ax)*ax);
	float a1y = sin(cos(ay)*ay);
	float a1z = sin(cos(az)*az);
	float a1w = sin(cos(aw)*aw);

	float a2x = sin(cos(1.0+ax)*(1.0+ax));
	float a2y = sin(cos(1.0+ay)*(1.0+ay));
	float a2z = sin(cos(1.0+az)*(1.0+az));
	float a2w = sin(cos(1.0+aw)*(1.0+aw));

	ax = (1.0 - fx) * a1x + fx * a2x;
	ay = (1.0 - fx) * a1y + fx * a2y;
	az = (1.0 - fx) * a1z + fx * a2z;
	aw = (1.0 - fx) * a1w + fx * a2w;

	ax = ay * fy + ax * (1.0 - fy);
	ay = aw * fy + az * (1.0 - fy);

	return mix(ax, ay, fz);
}

float fpn(vec3 p) {
   return pn(p*.006125)*.5 + pn(p*.125)*.25 + pn(p*.25)*.125;
}

float field( vec3 p ) {

	float ball = sqrt(p.x*p.x+p.y*p.y+(p.z+200.0)*(p.z+200.0))-7.0;

	float alpha = p.z/50.0;
	float tx = p.x;
	float ty = p.y;
	p.x = tx * cos(alpha) - ty * sin(alpha);
	p.y = tx * sin(alpha) + ty * cos(alpha);

	float hill = max(0, pow(sin(p.z/20.0+time/2.0),8)) * 0.5;
	float plane = -p.y + 30.0 - hill;
	float field = plane + pn(vec3(p.x, p.z, 0)/3.0);

	p.y = -p.y;
	float plane2 = -p.y + 30.0 - hill;
	float field2 = plane2 + pn(vec3(p.x, p.z, 0)/3.0);
	field = min( field, field2 );
	
	field = min( field, ball );
	
	return( field );
}

void main()
{
if( drawDistfield == 1 ) {
	float x = (1.0 - texcoord.x)*2.0-1.0;
	float y = (1.0 - texcoord.y)*2.0-1.0;
	vec3 r = normalize(vec3(-x,-y,2.41421356));
	vec3 pos = vec3(0,0,0);

	vec4 post = vec4(pos,1.0) * worldview;
	pos = post.xyz / post.w;	
	r = (vec4(r,1.0) * normalview).xyz;
	
	float c = 0;
	float dist = 200;
	float tdist = 0;
	float td = 0;
	float tc = 0;
	
	while( c < 255 && dist > 0.1 ) {

// 		Wrap sinefield around xy axis.
// 		float alpha = pos.z/50.0;
// 		mat3 rot = mat3(
// 			cos(alpha), sin(alpha), 0,
// 			-sin(alpha), cos(alpha), 0,
// 			0, 0, 1
// 		);
// 		vec3 rpos = pos;
// 		rpos *= rot;
		dist = field( pos );

// 		dist = field( pos );
// 		tdist += dist;
// 		dist = max( dist, 4.5 );
		pos += r * dist;
		c++;
	}

	// Normals for generic lambert things.
	float delta = 0.1;
	float nx1 = field( pos - vec3(delta, 0, 0) );
	float ny1 = field( pos - vec3(0, delta, 0) );
	float nz1 = field( pos - vec3(0, 0, delta) );
	float nx2 = field( pos + vec3(delta, 0, 0) );
	float ny2 = field( pos + vec3(0, delta, 0) );
	float nz2 = field( pos + vec3(0, 0, delta) );
	vec3 n = normalize( vec3( nx2-nx1, ny2-ny1, nz2-nz1 ) );
	
	
// 	if( dist <= 0.1 ) {
		gl_FragColor.rgb = vec3( 0.9, 0.9, 0.9 );
// 		gl_FragColor.rgb += max( 0.1,
// 			dot( n, normalize(lightpos - pos ) )
// 		);
// 	}
// 	else {
// 		gl_FragColor.rgb = vec3(0,0,0);
// 	}

		if( sqrt(pos.x*pos.x+pos.y*pos.y+(pos.z+200.0)*(pos.z+200.0))-7.0 <= dist ) {
			gl_FragColor.rgb =  vec3( min( max( 0.0, (float(c) / 50.0) ), 1.0) );
		}
		else {
			gl_FragColor.rgb *=  vec3( min( max( 0.0, 1.0 - (float(c) / 200.0) ), 1.0) );
			if( dist <= 0.1 ) {
				gl_FragColor.b += max(0, pow(sin(pos.z/20.0+time/2.0),8))/3.0;
			}
		}
		vec4 campos=vec4(pos,1.0) * inverse(normalview);
		gl_FragDepth = campos.z * 2.0;
			
	}
	else {
		gl_FragColor.rgb = vec3((1.0-unnormal.x)/2.0, (1.0-unnormal.y)/2.0, (1.0-unnormal.z)/2.0 )*4.0;
		gl_FragColor.rgb *= max( 0, -dot( unnormal, normalize(lightpos - unppos.xyz) ) );
		gl_FragDepth = gl_FragCoord.z;
	}
}
