#ifndef _GLHELPERS_H_
#define _GLHELPERS_H_


// Includes:
// C standard headers
// GL-Extension-Wrangler -> Shaders et cetera
// GLUT -> Useful interface to Window managment

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#ifdef __APPLE__
#include <GLUT/glut.h>
#else
#include <GL/glew.h>
#include <GL/glut.h>
#endif

GLuint makeBO( GLenum type, void* data, GLsizei size, int accessFlags );
GLuint loadShader( GLenum type, char *file);
GLuint makeShaderProgram( GLuint vertexShader, GLuint fragmentShader );
GLuint loadTexture( const char *filename );

#endif