#version 120

uniform sampler2D texture;
uniform float time = 1.0;
uniform float multiplier = 1.0;

#define DANCER_3_LEGS 1
#define DANCER_2_HANDS 2
uniform int scene = DANCER_3_LEGS;

float hipsterSmoothStep(float x)
{
	x = abs(x-0.5);
	float edge1 = 1.0;
	float edge0 = 0.0;
	float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
	float d = t * t * (3.0 - 2.0 * t);
	return (0.5-d)*2;
}

void main()
{
	vec2 coord=gl_TexCoord[0].xy;
	if (scene == DANCER_3_LEGS)
	{
		coord.s += sin(coord.t*5 + time*10)*0.058*multiplier*hipsterSmoothStep(coord.t);
	}
	else if (scene == DANCER_2_HANDS)
	{
		coord.t += sin(coord.s*5 + time*10)*0.058*multiplier*hipsterSmoothStep(coord.s);
	}

    vec4 color = texture2D(texture, coord) * gl_Color;
    gl_FragColor = color;
}
