/*
 * Decompiled with CFR 0.152.
 */
package com.github.bjakke;

import com.github.bjakke.CameraHandler;
import com.github.bjakke.PostProcessShader;
import com.github.bjakke.ShaderTest;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.KeyEvent;
import processing.opengl.PJOGL;

public class Main
extends PApplet {
    private static final int[] SCENE_SIZE = new int[]{640, 480};
    private static final String FILE_NAME = "Furious Freak.mp3";
    private static final int BPM = 160;
    private static final int RPB = 8;
    public static int screen = 0;
    private Moonlander ml;
    private ShaderTest st;
    private CameraHandler cameraHander;
    private PGraphics pg;
    private PostProcessShader pp;
    private PGraphics offboard;
    private long stop = 0L;

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            screen = Integer.parseInt(args[0]);
        }
        PApplet.main((String)"com.github.bjakke.Main");
    }

    public void draw() {
        System.out.println("FPS: " + this.frameRate);
        this.ml.update();
        int scene = this.ml.getIntValue("scene");
        if (this.stop == 0L && scene > 3) {
            this.stop = this.millis();
        }
        if (scene > 3) {
            this.background(0);
            this.textSize(36.0f);
            this.text("\"Paljon Toruja\"", 100.0f, 50.0f);
            this.textSize(24.0f);
            this.text("Code:", 100.0f, 100.0f);
            this.textSize(16.0f);
            this.text("BJAKKE", 100.0f, 150.0f);
            this.textSize(24.0f);
            this.text("Music:", 100.0f, 250.0f);
            this.textSize(16.0f);
            this.text("\"Furious Freak\" Kevin MacLeod (incompetech.com)", 100.0f, 300.0f);
            this.text("Licensed under Creative Commons: By Attribution 3.0 License", 100.0f, 350.0f);
            this.text("http://creativecommons.org/licenses/by/3.0/", 100.0f, 400.0f);
            if ((long)this.millis() - this.stop > 5000L) {
                this.exit();
            } else {
                return;
            }
        }
        this.pg.beginDraw();
        int bgcolor = this.ml.getIntValue("bgcolor");
        this.pg.background(bgcolor);
        float seconds = (float)this.ml.getCurrentTime();
        this.cameraHander.draw(seconds);
        this.st.draw(seconds);
        this.pg.endDraw();
        this.image((PImage)this.pg, 0.0f, 0.0f);
    }

    public void keyPressed(KeyEvent event) {
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D", screen);
        PJOGL.profile = 3;
    }

    public void setup() {
        this.pg = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.offboard = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.ml = Moonlander.initWithSoundtrack((PApplet)this, (String)FILE_NAME, (int)160, (int)8);
        this.cameraHander = new CameraHandler(this, this.pg, this.ml);
        this.st = new ShaderTest(this, this.pg, "shaders/vert.glsl", "shaders/frag.glsl", this.ml);
        this.pp = new PostProcessShader(this, this.offboard);
        this.ml.start("localhost", 1338, "syncdata.rocket");
    }
}

