/*
 * Decompiled with CFR 0.152.
 */
package com.github.bjakke;

import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;

public class CameraHandler {
    private final PApplet applet;
    private final PGraphics pg;
    private final Moonlander ml;

    public CameraHandler(PApplet applet, PGraphics pg, Moonlander ml) {
        this.applet = applet;
        this.pg = pg;
        this.ml = ml;
    }

    public void draw(float timeSeconds) {
        this.rocketCamera();
    }

    private void followCamera(float timeSeconds) {
        PVector lap = this.helix(timeSeconds, new PVector(50.0f, 50.0f));
        PVector cam = this.helix(timeSeconds - 10.0f, new PVector(50.0f, 50.0f));
        this.pg.camera(cam.x, cam.y, cam.z, lap.x, lap.y, lap.z, 0.0f, 1.0f, 0.0f);
    }

    private void fpsCamera() {
    }

    private PVector helix(float time, PVector params) {
        float a = params.x;
        float b = params.y;
        float x = a * PApplet.cos((float)time);
        float y = a * PApplet.sin((float)time);
        float z = b * time;
        return new PVector(x, y, z);
    }

    private float ml(String name) {
        return (float)this.ml.getValue(name);
    }

    private void peasyCamera() {
    }

    private void rocketCamera() {
        float eyeX = this.ml("eX");
        float eyeY = this.ml("eY");
        float eyeZ = this.ml("eZ");
        float centerX = this.ml("tX");
        float centerY = this.ml("tY");
        float centerZ = this.ml("tZ");
        this.pg.camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, 0.0f, 1.0f, 0.0f);
    }
}

