uniform sampler2D iChannel1;
uniform sampler2D tex0;
uniform sampler2D tex1;
uniform vec2 iResolution;
uniform float iGlobalTime;
vec2 iMouse = vec2(sin(iGlobalTime)*1000.,sin(iGlobalTime*1.3563453)*1000.);
//precision highp float;

//#define INVERT
mat2 rot2d(float angle){return mat2(cos(angle),-sin(angle),sin(angle),cos(angle));}
float r(float a, float b){return fract(sin(dot(vec2(a,b),vec2(12.9898,78.233)))*43758.5453);}
float h(float a){return fract(sin(dot(a,dot(12.9898,78.233)))*43758.5453);}

float noise(vec3 x){
    vec3 p  = floor(x);
    vec3 f  = fract(x);
    f       = f*f*(3.0-2.0*f);
    float n = p.x + p.y*57.0 + 113.0*p.z;
    return mix(mix(mix( h(n+0.0), h(n+1.0),f.x),
                   mix( h(n+57.0), h(n+58.0),f.x),f.y),
               mix(mix( h(n+113.0), h(n+114.0),f.x),
                   mix( h(n+170.0), h(n+171.0),f.x),f.y),f.z);
}

// http://www.iquilezles.org/www/articles/morenoise/morenoise.htm
// http://www.pouet.net/topic.php?post=401468
vec3 dnoise2f(vec2 p){
    float i = floor(p.x), j = floor(p.y);
    float u = p.x-i, v = p.y-j;
    float du = 30.*u*u*(u*(u-2.)+1.);
    float dv = 30.*v*v*(v*(v-2.)+1.);
    u=u*u*u*(u*(u*6.-15.)+10.);
    v=v*v*v*(v*(v*6.-15.)+10.);
    float a = r(i,     j    );
    float b = r(i+1.0, j    );
    float c = r(i,     j+1.0);
    float d = r(i+1.0, j+1.0);
    float k0 = a;
    float k1 = b-a;
    float k2 = c-a;
    float k3 = a-b-c+d;
    return vec3(k0 + k1*u + k2*v + k3*u*v,
                du*(k1 + k3*v),
                dv*(k2 + k3*u));
}

float fbm(vec2 uv){               
    vec2 p = uv;
	float f, dx, dz, w = 1.0;
    f = dx = dz = 0.0;
    uv.x += 20.0+iGlobalTime*0.5;
    for(int i = 0; i < 25; ++i){        
        vec3 n = dnoise2f(uv);
        dx += n.y;
        dz += n.z;
        f += w * n.x / (1.0 + dx*dx + dz*dz);
        w *= 0.99;
        
        uv *= vec2(0.85);
        //uv *= rot2d(0.25*noise(vec3(p*0.1, 0.012*iGlobalTime))+
        //            0.75*noise(vec3(p*0.1, 0.020*iGlobalTime)));
    }
    return f;
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float t = iGlobalTime*0.6;
    vec2 uv = -1.0+2.0*fragCoord / iResolution.xx;
    float val = fbm(1.0*uv);
    val = clamp(pow(val*0.1, 5.0)*8.0, -1.0, 8.0);
    val = 1.25*smoothstep(0.18, 1.0, val);
    vec3 c = vec3(val);
    fragColor = vec4(c,1.0);
    
}

void main() {
    vec4 fragColor = vec4( 0.);
    vec2 fragCoord = gl_FragCoord.xy;
    mainImage( fragColor, fragCoord);
    gl_FragColor = fragColor;
}