// Class for animating a sequence of GIFs

class Animation {
  PImage[] images;
  int imageCount;
  int frame;
  
  Animation(String imagePrefix, int count) {
    imageCount = count;
    images = new PImage[imageCount];

    for (int i = 0; i < imageCount; i++) {
      // Use nf() to number format 'i' into four digits
      String filename = imagePrefix + nf(i, 1) + ".png";
      images[i] = loadImage(filename);
    }
  }

  void display(float xpos, float ypos) {
    frame = (frame+1) % imageCount;
    image(images[frame], xpos, ypos);
  }
  
  int getWidth() {
    return images[0].width;
  }
}


class Building {
  int bwidth;
  int bheight;
  PImage b;
  
  Building(){
    int idx = (int) random(buildings.size());
    println(idx);
    b = buildings.get(idx);
    bwidth = b.width;
    bheight = b.height;
  }
  
  void draw(float x, float y){
    // x = bottom-left x where image is to be placed
    // y = bottom-left y where image is to be placed
    image(b, x, height-bheight+y);
  }
}