import moonlander.library.*;
import ddf.minim.*;

int numFrames = 5;
int currentFrame = 0;
PImage[] images = new PImage [numFrames];

Moonlander moon;

void setup() {
  size(1000, 1000);
  frameRate(7);
  
  moon = Moonlander.initWithSoundtrack(this, "Ason ID - Xander.wav", 4, 1); 
  moon.start();

  images[0]= loadImage("hirvi1.png");
  image(images[0], 0, 0);
  images[0].resize(300, 280);
  images[1]= loadImage("hirvi2.png");
  image(images[1], 0, 0);
  images[1].resize(300, 280);
  images[2]= loadImage("hirvi3.png");
  image(images[2], 0, 0);
  images[2].resize(300, 280);
  images[3]= loadImage("hirvi4.png");
  image(images[3], 0, 0);
  images[3].resize(300, 280);
  images[4]= loadImage("hirvi5.png");
  image(images[4], 0, 0);
  images[4].resize(300, 280);
}

void tree(int rekursio) {
  //translate(0, 50);
  line(0, 0, 0, -50);
  strokeWeight(0.5);
  //line()
  if(rekursio <= 0)
    return;
  translate(0, -50);
  pushMatrix();
  rotate(sin(millis()/1000.0));
  tree(rekursio - 1);
  popMatrix();
  
  pushMatrix();
  rotate(cos(millis()/1000.0));
  tree(rekursio - 1);
  popMatrix();
  
}

void draw() {
  background(255);
  currentFrame=(currentFrame+1) % numFrames;
  int offset = 0;
  for (int x = -100; x < width; x += images [0].width){
    image(images[(currentFrame+offset) % numFrames], x, -20);
    offset+=2;
    image(images[(currentFrame+offset) % numFrames], x, height/2);
  int luku = 7;
  pushMatrix();
  translate(550, 450);
  tree(luku);
  popMatrix();
}
}