import moonlander.library.*;
import ddf.minim.*;

Moonlander moonlander;
Pipe pipe;
PImage bg;
PShape ship;
PImage smoke;
ParticleSystem ps;
PFont mono;

void setup(){
  size(1920, 1080, P3D);
  pipe = new Pipe(1.0, 150, 100.0, 0.0, 0.0, 0.0);
  ship = loadShape("ship3.obj");
  ship.scale(10.0);
  ship.rotateY(radians(90));
  ship.rotateX(radians(180));
  smoke = loadImage("texture.png");
  mono = loadFont("Candara-16.vlw");
  bg = loadImage("stars2.png");
  ps = new ParticleSystem(smoke, 100);
  moonlander = Moonlander.initWithSoundtrack(this, "music2.wav", 126, 4);
  moonlander.start();
}  

void draw(){
  clear();
  moonlander.update();
  ps.update();
  background(bg);
  colorMode(HSB, 360, 1.0, 1.0);
  //ambientLight(0, 0, 0.1);
  
  translate(width/2, height/2, (height/2.0) / tan(PI*30.0 / 180.0));
  
  if(moonlander.getCurrentRow() < 56){
    background(0);
    translate(0, 50, -200);
    int spot = (int)moonlander.getValue("spot");
    float spotL = (float)moonlander.getValue("spotL");
    spotLight(0, 0.0, spotL, 0, -50, 0, 0, 1, 0, PI, spot);
    shape(ship, 0, 0);
    translate(0, -30, 0);
    drawBox();
  }
  else{
  
  float[] pos = pipe.getPoint((int)((moonlander.getCurrentRow()-56) / 4) + 3, (float)(((moonlander.getCurrentRow()-56) % 4) / 4.0));
  float rotX = (float)moonlander.getValue("rotX");
  float rotY = (float)moonlander.getValue("rotY");
  float rotZ = (float)moonlander.getValue("rotZ");
  
  translate(-pos[0],  -pos[1]+50, -pos[2]-150);
  
  ps.spawn(pos[0], pos[1], pos[2]+10);
  //ps.spawn(pos[0]-15, pos[1], pos[2]+40);
  
   if(moonlander.getCurrentRow() > 320){
    ps.spawn(pos[0]+100, pos[1]-20, pos[2]+10);
    //ps.spawn(pos[0]-15+100, pos[1]-20, pos[2]+40);
    ps.spawn(pos[0]-100, pos[1]-20, pos[2]+10);
    //ps.spawn(pos[0]-15-100, pos[1]-20, pos[2]+40);
  }

  pushMatrix();
  translate(pos[0], pos[1]-50, pos[2]);
  pointLight(0, 0.0, 0.2, 0, 0, 0);
  popMatrix();
  
  
  pushMatrix();
  translate(pos[0], pos[1] , pos[2]);
  
  pushMatrix();
  int c1 = (int)moonlander.getValue("color");
  int p1 = (int)moonlander.getValue("play");
  int c2 = (int)moonlander.getValue("c2"); 
  int p2 = (int)moonlander.getValue("p2");
  spotLight(c1, 100, p1, 0, 0, 0, 1, 0, -1, PI, 2);
  spotLight(c2, 100, p2, 0, 0, 0, -1, 0, -1, PI, 2);
  
  if(moonlander.getCurrentRow() > 320){
    spotLight(c1, 100, p1, 100, -20, 0, 1, 1, -1, PI, 2);
    spotLight(c2, 100, p2, 100, -20, 0, -1, 1, -1, PI, 2);
    spotLight(c1, 100, p1, -100, -20, 0, 1, 1, -1, PI, 2);
    spotLight(c2, 100, p2, -100, -20, 0, -1, 1, -1, PI, 2);
  }
  
  
  popMatrix();
  colorMode(RGB, 1.0);
  fill(1.0);
  noStroke();
  pushMatrix();
  rotateX(radians(rotX));
  rotateY(radians(rotY));
  rotateZ(radians(rotZ));
  shape(ship, 0, 0);
  popMatrix();
  
  if(moonlander.getCurrentRow() > 320){
    pushMatrix();
    translate(100, -20, 0);
      pushMatrix();
    rotateX(radians(rotX));
    rotateY(radians(rotY));
    rotateZ(radians(rotZ));
    shape(ship, 0, 0);
    popMatrix();
    translate(-200, 0, 0);
      pushMatrix();
    rotateX(radians(rotX));
    rotateY(radians(rotY));
    rotateZ(radians(rotZ));
    shape(ship, 0, 0);
    popMatrix();
    popMatrix();
  }
  
  popMatrix();
  
  pushMatrix();
  rotateX(radians(15));
  popMatrix();
  pipe.draw();
  
  lights();
  ps.render();
    if(moonlander.getCurrentRow() > 576){
      translate(pos[0], pos[1] , pos[2]);
      noLights();
      fill(1.0, 1.0, 1.0);
      textFont(mono);
      textAlign(CENTER, CENTER);
      text("GFX", -50, -110, 0);
      text("raki", -50, -90, 0); 
      text("Sound", 50, -110, 0);
      text("raki", 50, -90, 0);
      text("Mental support", 0, -50, 0);
      text("Visa & Maxim", 0, -30, 0);
    }
  }
}

class Pipe{
  
  float[][] pipe;
  int n;
  
  public Pipe(float radius, int elements, float stepsize, float xStart, float yStart, float zStart){
    this.n = elements;
    pipe = new float[elements+3][3]; 
    pipe[0][0] = pipe[1][0] = xStart;
    pipe[0][1] = pipe[1][1] = yStart;
    pipe[0][2] = pipe[1][2] = zStart;
    for(int i = 2; i < elements+2; ++i){
      float ax = random(-1.0, 1.0);
      float ay = random(-1.0, 1.0);
      pipe[i][0] = pipe[i-1][0] + stepsize * ax;
      pipe[i][1] = pipe[i-1][1] + stepsize * ay;
      pipe[i][2] = pipe[i-1][2] - stepsize;
    }
    pipe[elements+2][0] = pipe[elements+1][0];
    pipe[elements+2][1] = pipe[elements+1][1];
    pipe[elements+2][2] = pipe[elements+1][2];
  }
  
  public float[] getPoint(int i, float t){
    
    float x = curvePoint(pipe[i-1][0], pipe[i][0], pipe[i+1][0], pipe[i+2][0], t);
    float y = curvePoint(pipe[i-1][1], pipe[i][1], pipe[i+1][1], pipe[i+2][1], t);
    float z = curvePoint(pipe[i-1][2], pipe[i][2], pipe[i+1][2], pipe[i+2][2], t);
    
    
    return new float[] {x, y, z};
  }
  
  public void draw(){
    noStroke();
    int size = 4;
    int pieces = 16;
    colorMode(HSB, 1.0, 1.0 , 1.0);
    
    
    
    for(int i = 1; i <= n; ++i){
      for(int j = 0; j < size; ++j){
        float t1 = j / float(size);
        float x1 = curvePoint(pipe[i-1][0], pipe[i][0], pipe[i+1][0], pipe[i+2][0], t1);
        float y1 = curvePoint(pipe[i-1][1], pipe[i][1], pipe[i+1][1], pipe[i+2][1], t1);
        float z1 = curvePoint(pipe[i-1][2], pipe[i][2], pipe[i+1][2], pipe[i+2][2], t1);
        
        float t2 = (j+1) / float(size);
        float x2 = curvePoint(pipe[i-1][0], pipe[i][0], pipe[i+1][0], pipe[i+2][0], t2);
        float y2 = curvePoint(pipe[i-1][1], pipe[i][1], pipe[i+1][1], pipe[i+2][1], t2);
        float z2 = curvePoint(pipe[i-1][2], pipe[i][2], pipe[i+1][2], pipe[i+2][2], t2);
        
        float[][] gate = new float[pieces][3];
        
        int k = 0;
        int k_e = pieces;
        if(i > 69){
          k_e = pieces/2;
        }
        
        for(; k < k_e; ++k){

          float a1 = (k / (float)pieces) * TAU;
          float a2 = ((k + 1) / (float)pieces) * TAU;
          /*
          if(i > 35){
            a1 = (k / (float)pieces) * HALF_PI;
            a2 = ((k + 1) / (float)pieces) * HALF_PI;
          }*/
          
          float _x11 = x1 + 200 * cos(a1);
          float _y11 = y1 + 200 * sin(a1);
          float _x12 = x1 + 200 * cos(a2); 
          float _y12 = y1 + 200 * sin(a2);
          float _x21 = x2 + 200 * cos(a1);
          float _y21 = y2 + 200 * sin(a1);
          float _x22 = x2 + 200 * cos(a2);
          float _y22 = y2 + 200 * sin(a2);
             
          shininess(5.0); 
          beginShape();  
          
          //float p1 = (float)moonlander.getValue("P1");   
          //float octave = (float)moonlander.getValue("octave");
  
          float n1 = 0.5 + 0.5 * noise(z1);
          float n2 = 0.5 + 0.5 * noise(z2);
          
          fill(t1, 0.5, n1);
          vertex(_x11, _y11, z1);
 
          fill(t2, 0.5, n2);
          vertex(_x21, _y21 , z2);

          fill(t2, 0.5, n2);
          vertex(_x22, _y22, z2);

          fill(t1, 0.5, n1);
          vertex(_x12, _y12, z1);
          endShape(CLOSE);
          
        }
        
      }
    }
  }
}

void drawBox(){
  fill(0, 0, 1);
  noStroke();
  beginShape();
  normal(-1, 0, 0);
  vertex(-50, -50, -50);
  vertex(-50, -50, 50);
  vertex(-50, 50, 50);
  vertex(-50, 50, -50);
  endShape();
  
  beginShape();
  vertex(50, -50, -50);
  vertex(50, -50, 50);
  vertex(50, 50, 50);
  vertex(50, 50, -50);
  endShape(CLOSE);
  
  beginShape();
  vertex(-50, -50, -50);
  vertex(-50, -50, 50);
  vertex(50, -50, 50);
  vertex(50, -50, -50);
  endShape(CLOSE);

  beginShape();
  vertex(-50, 50, -50);
  vertex(-50, 50, 50);
  vertex(50, 50, 50);
  vertex(50, 50, -50);
  endShape(CLOSE);

  beginShape();
  vertex(-50, -50, -50);
  vertex(-50, 50, -50);
  vertex(50, 50, -50);
  vertex(50, -50, -50);
  endShape(CLOSE);
  
  beginShape();
  vertex(-50, -50, -50);
  vertex(-50, 50, -50);
  vertex(50, 50, -50);
  vertex(50, -50, -50);
  endShape(CLOSE);
  
  
}