class ParticleSystem{
  
  private ArrayList<Particle> particles;
  private PImage _image;
  private int _lifetime;
  
  public ParticleSystem(PImage image, int lifetime){
    particles = new ArrayList<Particle>();
    _lifetime = lifetime;
    _image = image;
  }
  
  public void render(){
    for (int i = particles.size()-1; i >= 0; i--) {
      Particle p = particles.get(i);
      pushMatrix();
      translate(p._x, p._y, p._z);
      //sphere(5);
      imageMode(CENTER);
      colorMode(RGB, 1.0);
      fill(0.0, 0.5, 1.0);
      scale(0.1);
      tint(1.0, 0.5);
      image(_image, 0, 0);
      popMatrix();
    } //<>//
  }
  
  public void update(){
  for (int i = particles.size()-1; i >= 0; i--) {
      Particle p = particles.get(i);
      p._lifetime--;
      if (p._lifetime <= 0) {
        particles.remove(i);
      }
    }
  }
  
  public void spawn(float x, float y, float z){
    particles.add(new Particle(x, y, z, _lifetime));
  }
}