#version 120

uniform sampler2D texture;
uniform float time = 1.0;
uniform float multiplier = 1.0;
uniform vec2 morph = vec2(10,10);
uniform vec2 morphMultiplier = vec2(1,1);

float hipsterSmoothStep(float x)
{
	x = abs(x-0.5);
	float edge1 = 1.0;
	float edge0 = 0.0;
	float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
	float d = t * t * (3.0 - 2.0 * t);
	return (0.5-d)*2;
}

void main()
{
	vec2 coord=gl_TexCoord[0].xy;
	coord.s += sin(coord.t*morph.x + time*10)*morphMultiplier.x*multiplier*hipsterSmoothStep(coord.s);
	coord.t += sin(coord.s*morph.y + time*10)*morphMultiplier.y*multiplier*hipsterSmoothStep(coord.t);

    vec4 color = texture2D(texture, coord) * gl_Color;
    gl_FragColor = color;
}
