var TICK;

Demo.prototype.init = function()
{
	TICK = timerGetBeatInSeconds();

	this.preInitScienceLogo(0,20);
	this.preInitUfo(35,18);
	this.preInitPlanetEarth(17,19);
	this.preInitTelevision(71,19);
	this.preInitRadar(52,20);
	this.preInitCommentator(89,18+21);
	this.preInitPoster(89,18+21);
}

var uvSpeed = 0.0;
Demo.prototype.preInitUfo = function(startTime, durationTime)
{
	var layer = 1;
	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"ufoTunnelFboFirstPass", action:"begin","width":getScreenWidth(),"height":getScreenHeight()}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "stars.png"
		,"scale":[
			 {"uniform2d":1.0}
		]
		,"warpSlowStart2":12
		,"warpSlowDuration2":3
		,"runFunction":"{getWarpUvSpeed(animation);}"
		,"uvMax": 1
		,"uv": {
			 "uMin": 0.0
			,"vMin": "{return (getSceneTimeFromStart()*uvSpeed)%animation.uvMax;}"
			,"uMax": 1.0
			,"vMax": "{return (getSceneTimeFromStart()*uvSpeed)%animation.uvMax-animation.uvMax;}"
		}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"ufoTunnelFboFirstPass", action:"unbind"}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"ufoTunnelFboSecondPass", action:"begin","width":getScreenWidth(),"height":getScreenHeight()}
	}]);

	var samples = 12;
	var spread = 0.005;
	var intensity = 0.14;
	var alpha = 0.7;

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"ufoTunnelFboFirstPass", action:"draw"}
		,"warpSlowStart":13
		,"warpSlowDuration":1
		,"shader":{"name":"data/shader/glow.fs","variable":[
			 {"name":"direction","value":[0,1]}
			,{"name":"glowAlpha","value":["{return getGlowValue(animation, 0, \"glowAlpha\");}"]}
			,{"name":"spread","value":["{return getGlowValue(animation, 0, \"spread\");}"]}
			,{"name":"intensity","value":["{return getGlowValue(animation, 0, \"intensity\");}"]}
			,{"name":"samples","type":"int","value":["{return getGlowValue(animation, 0, \"samples\");}"]}
		]}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"ufoTunnelFboSecondPass", action:"unbind"}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"ufoTunnelFbo", action:"begin","width":getScreenWidth(),"height":getScreenHeight()}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"ufoTunnelFboSecondPass", action:"draw"}
		,"warpSlowStart":13
		,"warpSlowDuration":1
		,"shader":{"name":"data/shader/glow.fs","variable":[
			 {"name":"direction","value":[1,0]}
			,{"name":"glowAlpha","value":["{return getGlowValue(animation, 1, \"glowAlpha\");}"]}
			,{"name":"spread","value":["{return getGlowValue(animation, 1, \"spread\");}"]}
			,{"name":"intensity","value":["{return getGlowValue(animation, 1, \"intensity\");}"]}
			,{"name":"samples","type":"int","value":["{return getGlowValue(animation, 1, \"samples\");}"]}
			,{"name":"showOnlyGlow","type":"int","value":["{return getGlowValue(animation, 1, \"showOnlyGlow\");}"]}
			,{"name":"alpha","value":["{return getGlowValue(animation, 1, \"alpha\");}"]}
		]}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"ufoTunnelFbo", action:"unbind"}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer
		,"object":"ufoTunnel","shape":{"type":"MATRIX"}
		,"initFunction": "{initUfoTunnel();}"
		,"runFunction": "{drawUfoTunnel(animation);}"
		,"position":[{"z":0}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime, "light":{"index":0, "action":"begin"}
		,"layer": layer
		,"diffuseColor":[
			 {"r":255, "g":255, "b":255, "a":255}
		]
		,"ambientColor":[
			 {"r":0xDD, "g":"{return 0xDD*((Math.sin(getSceneTimeFromStart()*3)-1)/2);}", "b":"{return 0xDD*((Math.sin(getSceneTimeFromStart()*3)-1)/2);}", "a":255}
		]
		,"specularColor":[
			 {"r":255, "g":255, "b":255, "a":255}
		]
		,"position":[
			 {"x":0.0, "y":0.1, "z":1.0}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "object": "data/vitunufo2.3ds"
		,"scale":[{"uniform2d":1.0}]
		,"pivot":[
			{"z":-2}
		]
		,"angle":[
			{
				 "degreesX":"{return 5*Math.sin(getSceneTimeFromStart()*2);}"
				,"degreesY":"{return -getSceneTimeFromStart()*60;}"
				,"degreesZ":"{return 5*Math.cos(getSceneTimeFromStart()*2)-90;}"
			}
		]
		,"position":[
			{
				 "x":"{return 0.15*Math.random();}"
				,"y":"{return 0.15*Math.random()-0.1;}"
				,"z":-2
			}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime, "light":{"index":0, "action":"end"}
		,"layer": layer
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": layer
		,"image": "data/black.png"
		,"color": [
			 {"a":255}
			,{"duration":1,"a":0}
			,{"duration":durationTime-2}
			,{"duration":1,"a":255}
		]
	}]);

}

function getWarpUvSpeed(animation)
{
	uvSpeed = 0.5;
}

function getGlowValue(animation, type, name)
{
	var p = 1-Utils.calculateProgress(animation.start+animation.warpSlowStart, animation.warpSlowDuration);

	var samples = 12;
	var spread = 0.005*p;
	var intensity = 0.14*p;
	var alpha = 1-p;

	if (name === "samples")
	{
		return samples;
	}
	else if (name === "spread")
	{
		if (type == 0)
		{
			return spread*1.1;
		}
		else if (type == 1)
		{
			return spread*0.1;
		}
		return spread;
	}
	else if (name === "intensity")
	{
		if (type == 0)
		{
			return intensity*1.6;
		}
		else if (type == 1)
		{
			return intensity*11;
		}
		return intensity;
	}
	else if (name === "alpha")
	{
		return alpha;
	}
	else if (name === "glowAlpha")
	{
		return 1.0;
	}
	else if (name === "showOnlyGlow")
	{
		if (p < 1.0)
		{
			return 0;
		}
		return 1;
	}
	
	return void null;
}

var testTexture;
var ufoTunnelFbo = {};
function initUfoTunnel()
{
	testTexture = imageLoadImage("group_satori.png");
	ufoTunnelFbo.ref = fboInit("ufoTunnelFbo");
}

function drawUfoTunnel(animation)
{
	glPushMatrix();

	var precision = 10;
	var radius = 10.0;
	var length = -100.0;

	glEnable(GL_BLEND);

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, ufoTunnelFbo.ref.color.id);

	glColor3f(1,1,1);
	glPointSize(10);
	glBegin(GL_QUADS);
	for (var i=0; i < precision; i++)
	{
		var angle = (i+precision)*2*Math.PI/precision;
		var x1 = Math.cos(angle) * radius;
		var y1 = Math.sin(angle) * radius;
		var z1 = 0;

		angle = ((i+1)+precision)*2*Math.PI/precision;
		var x2 = Math.cos(angle) * radius;
		var y2 = Math.sin(angle) * radius;
		var z2 = length;

		var uMin = i/precision;
		var uMax = (i+1)/precision;
		var vMin = 0.0;
		var vMax = 1.0;

		//glColor3f(1,0,0);
		glTexCoord2f(uMin,vMin);
		glVertex3f(x1,y1,z1);
		//glColor3f(0,1,0);
		glTexCoord2f(uMin,vMax);
		glVertex3f(x1,y1,z2);
		//glColor3f(0,0,1);
		glTexCoord2f(uMax,vMax);
		glVertex3f(x2,y2,z2);
		//glColor3f(1,1,0);
		glTexCoord2f(uMax,vMin);
		glVertex3f(x2,y2,z1);
	}
	glEnd();

	glDisable(GL_TEXTURE_2D);

	glPopMatrix();
}

Demo.prototype.preInitRadar = function(startTime, durationTime)
{
	var layer = 1;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/function.png"
		,"layer": layer
		,"color":[
			  {"r":0,"g":0xED,"b":0,"a":0}
			 ,{"duration":1,"a":80}
			 ,{"duration":durationTime-2}
			 ,{"duration":1,"a":0}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": layer
		,"ufoPosition":[
			 {"x":-0.6,"y":0.6}
			,{"x": -0.1,"y":0.1}
		]
		,"shader":{"name":"data/shader/radar.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"ufoPosition","value":"{return getRadarUfoPosition(animation);}"}
			]
		}
		,"color":[
			  {"r":0,"g":0xED,"b":0,"a":0}
			 ,{"duration":1,"a":255}
			 ,{"duration":durationTime-2}
			 ,{"duration":1,"a":0}
		]
	}]);
}

function getRadarUfoPosition(animation)
{
	var time = getSceneTimeFromStart();
	var p = Utils.calculateProgress(animation.start, animation.duration);

	return [
		interpolate(p,animation.ufoPosition[0].x,animation.ufoPosition[1].x)+0.01*Math.sin(time)+0.02*Math.sin(time*1.4),
		interpolate(p,animation.ufoPosition[0].y,animation.ufoPosition[1].y)+0.02*Math.sin(time)
	];
}

Demo.prototype.preInitCommentator = function(startTime, durationTime)
{
	var layer = 1;
	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "commentator_background.png"
		,"scale":[
			 {}
			,{"duration":18}
			,{"duration":2,"uniform2d":1.5}
		]
		,"position":[
			 {"x":getScreenWidth()/2,"y":getScreenHeight()/2}
			,{"duration":18}
			,{"duration":2,"x":getScreenWidth()*0.7,"y":getScreenHeight()*0.4}
		]
		,"color":[
			 {"a":0}
			,{"duration":1,"a":255}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "commentator.png"
		,"scale":[
			 {"uniform2d":1.4}
			,{"duration":18}
			,{"duration":2,"uniform2d":1.38}
		]
		,"position":[
			 {"x":getScreenWidth()*0.78,"y":getScreenHeight()/2}
			,{"duration":18}
			,{"duration":3,"x":getScreenWidth()*1.4,"y":-50}
		]
		,"color":[
			 {"a":0}
			,{"duration":1,"a":255}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": 17
		,"image": "data/blank.png"
		,"layer": layer
		,"sphereStart":0
		,"sphereFade":1
		,"sphereDuration":16
		,"shader":{"name":"data/shader/raymarching.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"spherePos1","value":"{return getSpherePosition(animation, 1);}"}
				,{"name":"spherePos2","value":"{return getSpherePosition(animation, 2);}"}
				,{"name":"spherePos3","value":"{return getSpherePosition(animation, 3);}"}
				,{"name":"spherePos4","value":"{return getSpherePosition(animation, 4);}"}
				,{"name":"spherePos5","value":"{return getSpherePosition(animation, 5);}"}
				,{"name":"masterScale","value":["{return getSphereMasterScale(animation);}"]}
			]
		}
		,"color":[
			 {"a":0}
			,{"duration":1,"a":255}
		]

	}]);

	this.loader.addAnimation([{
		 "start": startTime+2, "duration": durationTime
		,"layer": layer+1, "image": "commentator_text1.png"
		,"position":[{"x":getScreenWidth()/2,"y":getScreenHeight()*0.90}]
		,"color":[
			 {"a":0}
			,{"duration":0.5,"a":255}
			,{"duration":8}
			,{"duration":0.5,"a":0}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime+5, "duration": durationTime
		,"layer": layer+1, "image": "commentator_text2.png"
		,"position":[{"x":getScreenWidth()/2,"y":getScreenHeight()*0.10}]
		,"color":[
			 {"a":0}
			,{"duration":0.5,"a":255}
			,{"duration":5}
			,{"duration":0.5,"a":0}
		]
	}]);
}

function getSpherePosition(animation, sphereI)
{
	var array = [0,0,0];
	var time = getSceneTimeFromStart()*5;

	if (sphereI == 1)
	{
		array[0] = Math.cos(time)*0.5+0.2;
		array[1] = Math.sin(time)*0.8+0.3;
		array[2] = Math.sin(time)*0.5;
	}
	else if (sphereI == 2)
	{
		array[0] = Math.sin(time)*0.5-0.5;
		array[1] = Math.cos(time)*0.5-0.25;
		array[2] = Math.sin(time)+0.5;
	}
	else if (sphereI == 3)
	{
		array[0] = Math.cos(time)*0.5-0.5;
		array[1] = Math.sin(time)*0.7-0.25;
		array[2] = Math.cos(time)*0.6+0.3;
	}
	else if (sphereI == 4)
	{
		array[0] = Math.cos(time)*0.8;
		array[1] = Math.sin(time)*0.4;
		array[2] = Math.cos(time)*0.8;
	}
	else if (sphereI == 5)
	{
		array[0] = Math.sin(time)*0.9;
		array[1] = Math.sin(time)*0.9;
		array[2] = Math.sin(time)*0.2;
	}

	return array;
}

function getSphereMasterScale(animation)
{
	var progress = Utils.calculateProgress(animation.start+animation.sphereStart, animation.sphereFade);
	if (progress >= 1.0)
	{
		progress = 1 - Utils.calculateProgress(animation.start+animation.sphereStart+animation.sphereDuration, animation.sphereFade);
	}
	return progress;
}

Demo.prototype.preInitTelevision = function(startTime, durationTime)
{
	var layer = 1;
	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"fbo1", action:"begin","width":getScreenWidth(),"height":getScreenHeight()}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "stars.png"
		,"scale":[
			 {"uniform2d":0.8}
		]
		,"angle":[
			 {}
			,{"duration":durationTime,"degreesZ":360}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "planet_earth_moon.png"
		,"scale":[
			 {"uniform2d":3.0}
			,{"duration":durationTime,"uniform2d":0.8}
		]
		,"angle":[
			 {}
			,{"duration":durationTime,"degreesZ":360}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/alien.png"
		,"layer": layer
		,"scale":[{"uniform2d":0.7}]
		,"position":[{"x":350,"y":300}]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/alien.png"
		,"layer": layer
		,"scale":[{"uniform2d":0.7}]
		,"position":[{"x":750,"y":300}]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/alien.png"
		,"layer": layer
		,"scale":[{"uniform2d":0.8}]
		,"position":[{"x":550,"y":200}]
	}]);

	var TEXT_DURATION = 0.3;
	var transmission_text_images = [
		 {"name":"transmission_do.png","start":1,"duration":TEXT_DURATION}
		,{"name":"transmission_you.png","start":1.5,"duration":TEXT_DURATION}
		,{"name":"transmission_want.png","start":2,"duration":TEXT_DURATION}
		,{"name":"transmission_total.png","start":3.5,"duration":TEXT_DURATION}
		,{"name":"transmission_war.png","start":4.0,"duration":TEXT_DURATION}
		,{"name":"transmission_yes.png","start":6,"duration":TEXT_DURATION}
		,{"name":"transmission_you.png","start":6.5,"duration":TEXT_DURATION}
		,{"name":"transmission_want.png","start":7,"duration":TEXT_DURATION}
		,{"name":"transmission_total.png","start":8.5,"duration":TEXT_DURATION}
		,{"name":"transmission_war.png","start":9.0,"duration":TEXT_DURATION}
	];

	for(var i = 0; i < transmission_text_images.length; i++)
	{
		var transmission = transmission_text_images[i];
		this.loader.addAnimation([
		{
			 "start": startTime+transmission.start, "duration": transmission.duration
			,"image": transmission.name
			,"layer": layer
			,"scale":[{"uniform2d":1.3}]
			,"position":[{"x":550,"y":350}]
			,"color":[{"a":200}]
		}]);		
	}

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": layer
		,"shader":{"name":"data/shader/noise.fs",
			"variable":[
				{"name":"time","value":["{return Math.floor(getSceneTimeFromStart()*30);}"]}
			]
		}
		,"color":[{"a":70}]
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"fbo1", action:"unbind"}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "fbo1.color.fbo"
		,"layer": layer
		,"color":[
			 {"a":0}
			,{"duration":0.5,"a":255}
		]
		,"shader":{
			"name":"data/shader/distortion.fs",
			"variable":[
				  {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				 ,{"name":"distortionResolutionX","value":[7.8]}
				 ,{"name":"distortionResolutionY","value":[7.3]}
				 ,{"name":"distortionX","value":[0.1]}
				 ,{"name":"distortionY","value":[0.05]}
				 ,{"name":"distortionSpeed","value":[2.0]}
				 ,{"name":"shakeSizeY","value":[0.005]}
				 ,{"name":"glitchSize","value":[0.005]}
				 ,{"name":"noiseAlpha","value":[0.0]}
			]
		}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/old_tv.png"
		,"layer": layer
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/old_tv_screen.png"
		,"position": [{"x":520,"y":357}]
		,"color": [{"a":120}]
		,"layer": layer
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": layer
		,"image": "data/black.png"
		,"color": [
			 {"a":255}
			,{"duration":1,"a":0}
			,{"duration":durationTime-2}
			,{"duration":1,"a":255}
		]
	}]);
}

Demo.prototype.preInitPlanetEarth = function(startTime, durationTime)
{
	var layer = 5;
	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "stars.png"
		,"scale":[
			 {"uniform2d":0.7}
			,{"duration":2}
			,{"duration":10, "uniform2d":0.75}
		]
		,"position":[
			 {"x":getScreenWidth()/2,"y":getScreenHeight()/2}
			,{"duration":12}
			,{"duration":4,"x":getScreenWidth()*0.47}
		]
		,"color":[
			 {}
			,{"start":startTime+durationTime-1,"duration":1,"a":0}
		]
	}]);


	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "planet_earth.png"
		,"perspective": "3d"
		,"scale":[{"uniform2d":2.0}]
		,"position":[
			 {"z":-12}
			,{"duration":12}
			,{"duration":2,"x":3}
		]
		,"color":[
			 {}
			,{"start":startTime+durationTime-1,"duration":1,"a":0}
		]
	}]);

	var signalStart = 14;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": layer
		,"signalStart": signalStart
		,"signalDuration": 6
		,"shader":{"name":"data/shader/signal.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"scale","value":["{return getSignalScale(animation, 5.5);}"]}
				,{"name":"position","value":[0,0.5]}
			]
		}
		,"color":[
			 {"a":0,"r":0xDD,"g":0,"b":0}
			,{"duration":signalStart}
			,{"duration":0.5,"a":255}
			,{"start":startTime+durationTime-1,"duration":1,"a":0}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "crosshair.png"
		,"perspective": "3d"
		,"scale":[{"uniform2d":3}]
		,"position":[
			 {"z":-12}
			,{"duration":12}
			,{"duration":2,"x":3}
		]
		,"color":[
			 {"a":0,"r":0xDD,"g":0,"b":0,}
			,{"duration":12}
			,{"a":"{return getCrosshairAlpha(animation);}"}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "planet_earth_moon.png"
		,"perspective": "3d"
		,"scale":[{"uniform2d":2.0}]
		,"position":[
			 {"z":-12}
			,{"duration":2}
			,{"duration":10, "z":0.5}
			,{"duration":4, "x":-1}
		]
		,"color":[
			 {}
			,{"start":startTime+durationTime-1,"duration":1,"a":0}
		]
	}]);
}

function getCrosshairAlpha(animation)
{
	var p = ((Math.sin(getSceneTimeFromStart()*5)+1)/2);
	p = p * (1-Utils.calculateProgress(animation.start+animation.duration-1, 1));

	return 0xFF*p;
}

Demo.prototype.preInitScienceLogo = function(startTime, durationTime)
{
	var layer = 1;

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"fbo1", action:"begin","width":getScreenWidth(),"height":getScreenHeight()}
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer
		,"warningStripFadeStart":18
		,"warningStripFadeDuration":2
		,"runFunction":"{drawWarningStripes(animation);}"
	}]);

	var signalStart = 9;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": layer
		,"signalStart": signalStart
		,"signalDuration": 2
		,"shader":{"name":"data/shader/signal.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"scale","value":["{return getSignalScale(animation, 3.7);}"]}
				,{"name":"position","value":[0.5,0.5]}
			]
		}
		,"color":[
			 {"a":0,"r":0xDD,"g":0,"b":0}
			,{"duration":signalStart}
			,{"duration":0.5,"a":255}
			,{"start":startTime+durationTime-1,"duration":1,"a":0}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"logoDrawDuration": 6
		,"layer": layer
		,"signalStart": signalStart
		,"logoDrawStart":3
		,"initFunction":"{initJmlLogo();}"
		,"runFunction":"{drawJmlLogo(animation);}"
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "ancient_signals.png"
		,"scale":[{"uniform2d":2.0}]
		,"color":[
			 {"a":0, "r":0xDD,"g":0,"b":0}
			,{"duration":0.5,"a":255}
			,{"duration":2.5}
			,{"duration":2,"a":0}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime+11.5, "duration": 2
		,"layer": layer, "image": "credit_code.png"
		,"scale":[{"uniform2d":1.0}]
		,"position":[{"x":getScreenWidth()*0.76,"y":175}]
		,"color":[
			 {"a":0, "r":0xDD,"g":0,"b":0}
			,{"duration":0.5,"a":255}
			,{"duration":1}
			,{"duration":0.5,"a":0}
		]
	}]);
	this.loader.addAnimation([{
		 "start": startTime+13.5, "duration": 2
		,"layer": layer, "image": "credit_music.png"
		,"scale":[{"uniform2d":1.0}]
		,"position":[{"x":getScreenWidth()*0.78,"y":175}]
		,"color":[
			 {"a":0, "r":0xDD,"g":0,"b":0}
			,{"duration":0.5,"a":255}
			,{"duration":1}
			,{"duration":0.5,"a":0}
		]
	}]);
	this.loader.addAnimation([{
		 "start": startTime+15.5, "duration": 2
		,"layer": layer, "image": "credit_gfx.png"
		,"scale":[{"uniform2d":1.0}]
		,"position":[{"x":getScreenWidth()*0.83,"y":125}]
		,"color":[
			 {"a":0, "r":0xDD,"g":0,"b":0}
			,{"duration":0.5,"a":255}
			,{"duration":1}
			,{"duration":0.5,"a":0}
		]
	}]);

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "fbo": {name:"fbo1", action:"unbind"}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "fbo1.color.fbo"
		,"layer": layer+10
		,"color":[
			 {"a":0}
			,{"duration":0.5,"a":255}
		]
	}]);
}

function getSignalScale(animation, scaleMax)
{
	var progress = Utils.calculateProgress(animation.start+animation.signalStart, animation.signalDuration);
	return progress*scaleMax;
}

var jml_fist;
var jml_ball;

function atomCircle(position, percent, startPointPercent)
{
	var CIRCLE_PRECISION = 100;
	glPushMatrix();
	glTranslatef(getScreenWidth()/2, getScreenHeight()/2, 0);
	glRotatef(360/3.*position,0,0,1);
	var radius = 92.0;	
	glColor3f(0,0,0);
	glBegin(GL_LINE_STRIP);
	
	for (var i=0; i <= CIRCLE_PRECISION*percent; i++)
	{
		var angle = (i+CIRCLE_PRECISION*startPointPercent)*2*Math.PI/CIRCLE_PRECISION;
		glVertex2f(Math.cos(angle) * radius, Math.sin(angle) * radius * 3.5);
	}
	glEnd();
	
	glPushMatrix();
	var angle = (CIRCLE_PRECISION*percent+CIRCLE_PRECISION*startPointPercent)*2*Math.PI/CIRCLE_PRECISION;
	glTranslatef(-(jml_ball.w/2.)+Math.cos(angle) * radius,-(jml_ball.h/2.)+Math.sin(angle) * radius * 3.5, 0);

	glColor3f(1,1,1);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, jml_ball.id);
	glBegin(GL_QUADS);
	glTexCoord2f(1.0,1.0);
	glVertex2f(jml_ball.w,jml_ball.h);
	glTexCoord2f(0.0,1.0);
	glVertex2f(0,jml_ball.h);
	glTexCoord2f(0.0,0.0);
	glVertex2f(0, 0);
	glTexCoord2f(1.0,0.0);
	glVertex2f(jml_ball.w,0);
	glEnd();
	glDisable(GL_TEXTURE_2D);
	glPopMatrix();

	glPopMatrix();
}

function drawScreen(w,h)
{
	perspective2dBegin(w,h);
	glColor3f(1,0,0);
	glBegin(GL_QUADS);
	glVertex2f(0,0);
	glVertex2f(0,h);
	glVertex2f(w,h);
	glVertex2f(w,0);
	glEnd();
	glColor3f(0,0,1);
	glBegin(GL_LINE_STRIP);
	glVertex2f(0,0);
	glVertex2f(0,h);
	glVertex2f(w,h);
	glVertex2f(w,0);
	glVertex2f(0,0);
	glEnd();
	perspective2dEnd();
	glColor3f(1,1,1);
}


function initJmlLogo()
{
	jml_fist = imageLoadImage("data/jml_fist.png");
	jml_ball = imageLoadImage("data/jml_ball.png");
}

function drawWarningStripes(animation)
{
	glPushMatrix();
	perspective2dBegin(getScreenWidth(), getScreenHeight());
	glTranslatef(getScreenWidth()/2,getScreenWidth()/2,0);
	glRotatef(30,0,0,-1);
	glTranslatef(-getScreenWidth()/2,-getScreenWidth()/2,0);
	var columns = 12;
	var w = getScreenWidth()/8.0;
	var h = getScreenWidth()+400;
	var x = 0;
	var y = -400;

	var fade = Utils.calculateProgress(animation.start+animation.warningStripFadeStart, animation.warningStripFadeDuration);
	for(var i = 0; i < columns; i++)
	{
		var fadePositionY = 0;
		if (i%2 == 0)
		{
			fadePositionY = h*fade;
			glColor3ub(50,50,50);
		}
		else
		{
			fadePositionY = 1-h*fade;
			glColor3ub(0xE8,0xBF,0x28); //nuclear yellowish
		}

		glBegin(GL_QUADS);
		glVertex2f(x,y+fadePositionY);
		glVertex2f(x,y+h+fadePositionY);
		glVertex2f(x+w,y+h+fadePositionY);
		glVertex2f(x+w,y+fadePositionY);
		glEnd();

		x += w;
	}
	glColor3f(1,1,1);
	perspective2dEnd();
	glPopMatrix();
}

function drawJmlLogo(animation)
{
	glColor3f(1,1,1);
	var time_from_start = getSceneTimeFromStart();
	var element_coverage_width = 380;

	var alpha = Utils.calculateProgress(animation.start+animation.logoDrawStart, animation.logoDrawDuration);
	var progress = Utils.calculateProgress(animation.start, animation.duration);

	var max = 0.9;
	if (progress > max)
	{
		alpha = 1-(progress-max)/0.1;
	}

	glPushMatrix();
	perspective2dBegin(getScreenWidth(), getScreenHeight());

	setTextureCenterAlignment(jml_fist.ptr, 1);
	setTextureScale(jml_fist.ptr, 0.3,0.3);
	var signalStartProgress = Utils.calculateProgress(animation.start+animation.signalStart, 0.35);
	glColor4f(1,1,1,alpha);
	if (signalStartProgress > 0)
	{
		glColor4ub(0xDD*signalStartProgress,0,0,0xFF*alpha);
	}
	drawTexture(jml_fist.ptr);
	perspective2dEnd();
	glPopMatrix();

	glPushMatrix();
	glEnable( GL_POINT_SMOOTH );
    glEnable( GL_BLEND );
	glEnable(GL_BLEND);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_LINE_STIPPLE);
	glLineWidth(10.0);

	perspective2dBegin(getScreenWidth(), getScreenHeight());
	atomCircle(1, alpha, -0.1);
	atomCircle(2, alpha, -0.1);
	atomCircle(3, alpha, -0.1);
	perspective2dEnd();
	glPopMatrix();
}

Demo.prototype.preInitPoster = function(startTime, durationTime)
{
	var layer = 1;

	this.loader.addAnimation([{
		 "start": startTime, "duration": durationTime
		,"layer": layer, "image": "poster.png"
		,"position":[
			 {"x":getScreenWidth()*0.37,"y":getScreenHeight()*0.55}
			,{"duration":18}
			,{"duration":2,"x":getScreenWidth()*0.51,"y":getScreenHeight()*0.48}
		]
		,"scale":[
			 {"uniform2d":0.45}
			,{"duration":18}
			,{"duration":2,"uniform2d":0.68}
		]
		,"color":[
			 {"a":0}
			,{"duration":1,"a":255}
		]
	}]);
	this.loader.addAnimation([{
		 "start": startTime, "duration": 20.5
		,"layer": layer, "image": "poster_ufo.png"
		,"position":[
			 {"x":getScreenWidth()*0.37,"y":getScreenHeight()*0.5+150}
			,{"duration":18}
			,{"duration":2,"x":getScreenWidth()*0.51,"y":getScreenHeight()*0.7}
		]
		,"scale":[
			 {"uniform2d":0.4}
			,{"duration":18}
			,{"duration":2,"uniform2d":0.63}
		]
		,"color":[
			 {"a":0}
			,{"duration":1,"a":255}
		]
	}]);

	var group_images = [
		 "poster_ufo.png"
		,"group_conspiracy.png"
		,"group_ivory_labs.png"
		,"group_mercury.png"
		,"group_kewlers.png"
		,"group_poobrain.png"
		,"group_satori.png"
		,"poster_ufo.png"
	];

	var GROUP_DURATION = 2.5;
	var GROUP_FADE = 0.25;
	for(var i = 0; i < group_images.length; i++)
	{
		var color = [
			 {"a":0}
			,{"duration":GROUP_FADE, "a":255}
			,{"duration":GROUP_DURATION-GROUP_FADE*2}
			,{"duration":GROUP_FADE, "a":0}
		];
		var scale = [
			 {"uniform2d":0.0}
			,{"duration":GROUP_FADE, "uniform2d":0.63}
			,{"duration":GROUP_DURATION-GROUP_FADE*2}
			,{"duration":GROUP_FADE, "uniform2d":0.0}
		];

		if (i == 0)
		{
			color = [
				 {}
				,{"duration":GROUP_FADE}
				,{"duration":GROUP_DURATION-GROUP_FADE*2}
				,{"duration":GROUP_FADE, "a":0}
			];
			scale = [
				 {"uniform2d":0.63}
				,{"duration":GROUP_FADE}
				,{"duration":GROUP_DURATION-GROUP_FADE*2}
				,{"duration":GROUP_FADE, "uniform2d":0.0}
			];
		}
		else if (i+1 >= group_images.length)
		{
			color = [
				 {"a":0}
				,{"duration":GROUP_FADE, "a":255}
			];
			scale = [
				 {"uniform2d":0.0}
				,{"duration":GROUP_FADE, "uniform2d":0.63}
			];
		}

		this.loader.addAnimation([{
			 "start": 20.5+startTime+i*(GROUP_DURATION-GROUP_FADE), "duration": GROUP_DURATION
			,"layer": layer, "image": group_images[i]
			,"color": Utils.deepCopyJson(color)
			,"scale": Utils.deepCopyJson(scale)
			,"position":[{"x":getScreenWidth()*0.51,"y":getScreenHeight()*0.7}]
			,"shader":{"name":"data/shader/group_logo_fade.fs",
				"variable":[
					 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
					,{"name":"multiplier","value":["{return getGroupLogoFade(animation, "+i+", "+group_images.length+");}"]}
					,{"name":"morph","value":[random()*10+5,random()*10+5]}
					,{"name":"morphMultiplier","value":[random(),random()]}
				]
			}
		}]);
	}
}

function getGroupLogoFade(animation, i, maxLength)
{
	var progress = Utils.calculateProgress(animation.start, animation.duration);
	var fadeIn = 0.15;
	var fadeOut = 0.85;
	if (progress < fadeIn)
	{
		if (i == 0)
		{
			return 0;
		}

		return 1-progress/fadeIn;
	}
	else if (progress > fadeOut)
	{
		if (i+1 >= maxLength)
		{
			return 0;
		}

		return (progress-fadeOut)/(1.0-fadeOut);
	}
	return 0;
}
