using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID12f7617a_4fd3_428a_892e_0899084c0635
{
    public class Class_CompareValue : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Condition = 1,
            A = 2,
            B = 3,
            ValueIfTrue = 4,
            ValueIfFalse = 5
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Condition = (int) inputs[(int)InputId.Condition].Eval(context).Value;
            var A = inputs[(int)InputId.A].Eval(context).Value;
            var B = inputs[(int)InputId.B].Eval(context).Value;
            var ValueIfTrue = inputs[(int)InputId.ValueIfTrue].Eval(context).Value;
            var ValueIfFalse = inputs[(int)InputId.ValueIfFalse].Eval(context).Value;
            //<<< _params
                               
            if( Condition == 0) {
                context.Value = (Value < A)? ValueIfTrue:ValueIfFalse;
            }
            else if ( Condition == 1) {
                context.Value = Value > A ? ValueIfTrue:ValueIfFalse;
            }
            else if (Condition == 2) {
                if (A > B) {
                    var t= A;
                    A=B;
                    B=t;
                }
            
                context.Value = (Value > A && Value < B) ? ValueIfTrue:ValueIfFalse;
            }
            else {
                context.Value = Value == A ? ValueIfTrue:ValueIfFalse;
            }

            return context;
        }
    }
}

