var Cake = function() {
	this.loader = new Loader();
	this.player = new Player();
}

Cake.prototype.init = function()
{
	this.loader.addAnimation([
	{
		 "start": 0, "duration": "1:31"
		,"layer": "00002", "image": "data/bg3.png"
	}]);
	this.loader.addAnimation([
	{
		 "start": 0, "duration": "0:38"
		,"layer": "00002", "image": "data/bg.png"
		,"shader":{"name":"Wavy",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart()/3.0;}"]}
			]
		}
		,"color":[
			 {"a":255}
			,{"start":"0:33","duration":5,"a":0}
		]
	}]);
	this.loader.addAnimation([
	{
		 "start": 0, "duration": "1:31"
		,"layer": "00002", "image": "data/bg2.png"
	}]);

	this.loader.addAnimation([
	{
		 "start": "1:25", "duration": "1:31"
		,"layer": "00100", "image": "data/black.png"
		,"color": [{"a":0},{"duration":3,"a":255}]
	}]);

	this.loader.addAnimation([
	{
		 "start": "1:08", "end": "1:31"
		,"layer": "00010"
		,"initFunction":"{initGreetParticles(animation);}"
		,"runFunction":"{drawGreetParticles(animation);}"
	}]);

	this.preInitCredits("0:00", "0:08");
	this.preInitCake(8, 40);
	this.preInitCube(8, 90);

	this.loader.processAnimation();
}

Cake.prototype.run = function()
{
	this.player.drawAnimation(this.loader.animationLayers);
}

Cake.prototype.deinit = function()
{
}

var colorPalette = [
	{"r":234,"g":53,"b":86,"a":0xFF},
	{"r":97,"g":210,"b":214,"a":0xFF},
	{"r":237,"g":229,"b":226,"a":0xFF},
	{"r":237,"g":20,"b":111,"a":0xFF},
	{"r":237,"g":222,"b":69,"a":0xFF},
	{"r":155,"g":240,"b":233,"a":0xFF}
];

/*********************
 * Cube scene
 *********************/
var decoStartTime = 4;
Cake.prototype.preInitCube = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00001"
		,"fbo":{"name":"fboCube","action":"begin","width":1024,"height":1024}
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00001"
		,"initFunction":"{initCubeTextureReplace(animation);}"
		,"runFunction":"{drawCubeTextureReplace(animation);}"
	}]);
	for(var i = 0; i <= 20; i++)
	{
		this.loader.addAnimation([
		{
			 "start": 57+4*3-4, "duration": durationTime
			,"layer": "00001", "image": "bar.png"
			,"position": [
				 {"x":i*125,"y":getScreenHeight()}
				,{"duration":0.5, "y":0}
			]
		}]);
	}
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00001"
		,"fbo":{"name":"fboCube","action":"unbind"}
	}
	]);

	this.loader.addAnimation([
	{
		 "start": 40, "duration": 20
		,"layer": "00026"
		,"initFunction":"{initDCircle(animation);}"
		,"runFunction":"{drawDCircle(animation);}"
	}]);

	var dCount = 10;
	for(var i=0; i<dCount; i++)
	{
		var duration = 25.5;
		var start = 40;
		var scale=0.2;
		var px = 2000;
		var position = 360/dCount*i;
		if (i%2 == 0)
		{
			this.loader.addAnimation([{
				 "start": start, "duration": duration
				,"layer": "00026", "image": "d0.png"
				,"scale": [{"x":0.3, "y":0.3}]
				,"angle": [{"degreesZ":position,"pivot":{"x":px*scale,"y":0}},{"duration":duration,"degreesZ":360*3+position}]
				,"position": [{"x":100, "y":getScreenHeight()/2-80}]
				,"color": [{"a":0}, {"duration":1,"a":255},{"start":start+duration-1,"duration":1,"a":0}]
				,"shader":{"name":"Wavy2",
					"variable":[
						 {"name":"time","value":["{return getSceneTimeFromStart()/3.0;}"]}
					]
				}
			}]);

			this.loader.addAnimation([{
				 "start": start, "duration": duration
				,"layer": "00026", "image": "d0.png"
				,"scale": [{"x":0.3, "y":0.3}]
				,"angle": [{"degreesZ":position,"pivot":{"x":px*scale,"y":0}},{"duration":duration,"degreesZ":360*3+position}]
				,"position": [{"x":getScreenWidth()+px*scale+100, "y":getScreenHeight()/2-80}]
				,"color": [{"a":0}, {"duration":1,"a":255},{"start":start+duration-1,"duration":1,"a":0}]
				,"shader":{"name":"Wavy2",
					"variable":[
						 {"name":"time","value":["{return getSceneTimeFromStart()/3.0;}"]}
					]
				}			
			}]);
		}
		else
		{
			this.loader.addAnimation([{
				 "start": start, "duration": duration
				,"layer": "00026", "image": "d1.png"
				,"scale": [{"x":0.3, "y":0.3}]
				,"angle": [{"degreesZ":position,"pivot":{"x":px*scale,"y":0}},{"duration":duration,"degreesZ":360*3+position}]
				,"position": [{"x":100, "y":getScreenHeight()/2-80}]
				,"color": [{"a":0}, {"duration":1,"a":255},{"start":start+duration-1,"duration":1,"a":0}]
				,"shader":{"name":"Wavy2",
					"variable":[
						 {"name":"time","value":["{return getSceneTimeFromStart()/3.0;}"]}
					]
				}
			}]);

			this.loader.addAnimation([{
				 "start": start, "duration": duration
				,"layer": "00026", "image": "d1.png"
				,"scale": [{"x":0.3, "y":0.3}]
				,"angle": [{"degreesZ":position,"pivot":{"x":px*scale,"y":0}},{"duration":duration,"degreesZ":360*3+position}]
				,"position": [{"x":getScreenWidth()+px*scale+100, "y":getScreenHeight()/2-80}]
				,"color": [{"a":0}, {"duration":1,"a":255},{"start":start+duration-1,"duration":1,"a":0}]
				,"shader":{"name":"Wavy2",
					"variable":[
						 {"name":"time","value":["{return getSceneTimeFromStart()/3.0;}"]}
					]
				}			
			}]);
		}
	}

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime, "object":"cubes","shape":{"type":"MATRIX"}
		,"layer": "00026"
		,"initFunction":"{initCubes(animation);}"
		,"runFunction":"{drawCubes(animation);}"
		,"angle": [
			  {"pivot":{"z":-2}, "degreesZ":-90} 
			 ,{"duration":durationTime, "degreesX":360*9, "degreesY":900*3, "degreesZ":1000*3}
		]
		,"position":[
			 {"z":-13,"y":10}
			,{"duration":25}
			,{"duration":5,"z":-0,"y":0}
			,{"end":"1:08"}
			,{"duration":2,"z":-2,"y":0}
		]
	}]);
}

function initDCircle(animation)
{
}

function drawDCircle(animation)
{
}

var particleContainer2;
function particleInit2(particleContainer, particle)
{
	var scale = 0.1+random()*0.2;	
	setParticleScaleRange(particle.ptr, scale, scale, 0, scale, scale, 0);
	
	var precision = getScreenHeight();
	var radius = getScreenWidth()*1.1;
	setParticleAngleRange(particle.ptr, 0, 0, random()*360, 0, 0, random()*360*(random()*2-1));

	var starW = 512;
	var starH = 512;
	var x = getScreenWidth()/2-(starW*scale)/2;
	var y = getScreenHeight()/2-(starH*scale)/2;
	var angle = (random()*precision+precision)*2*Math.PI/precision;
	var endX = Math.cos(angle) * radius;
	var endY = Math.sin(angle) * radius;
	setParticlePositionRange(particle.ptr, x, y, 0, endX, endY, 0);
	
	var lifeSeconds = 3;	
	var startTime = getSceneTimeFromStart()+random()*lifeSeconds*2;
	var duration = lifeSeconds+random()*lifeSeconds;
	setParticleTime(particle.ptr, startTime, duration);
	
	/*var color = colorPalette[Utils.getRandomArrayIndex(colorPalette)];
	particle.color = color;
	setParticleColor(particle.ptr, color.r/255, color.g/255, color.b/255, 1);*/
}

function initGreetParticles(animation)
{
	particleContainer2 = initParticleContainer();
	setParticleContainerTime(particleContainer2.ptr, animation.start, animation.duration);
	setParticleContainerPerspective3d(particleContainer2.ptr, 0);
	bindParticleContainerInitParticleFunction(particleContainer2.ptr, "particleInit2");
	setParticleContainerDefaultTextureList(particleContainer2.ptr,
		[
			 imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/heart.png").ptr
			,imageLoadImage("data/markka.png").ptr
		]
	);
	initParticleContainerParticles(particleContainer2.ptr, 0, 150);
}

function drawGreetParticles(animation)
{
	drawParticleContainer(particleContainer2.ptr);
}


Cake.prototype.preInitCake = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime, "light":{"index":0, "action":"begin"}
		,"layer": "00020"
		,"diffuseColor":[
			 {"r":255, "g":255, "b":255, "a":255}
		]
		,"ambientColor":[
			 {"r":255, "g":255, "b":255, "a":255}
		]
		,"specularColor":[
			 {"r":255, "g":255, "b":255, "a":255}
		]
		,"position":[
			 {"x":0.6, "y":0.2, "z":1.0}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime+7, "duration": durationTime, "object":"particles","shape":{"type":"MATRIX"}
		,"layer": "00021"
		,"initFunction":"{initParticles(animation);}"
		,"runFunction":"{drawParticles(animation);}"
		,"angle": [
			   {"pivot":{"z":-0}, "degreesX":90} 
//			  ,{"duration": durationTime, "degreesZ":900} 
		]
		,"position":[{"z":-13,"y":-2}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime, "object":"cake","shape":{"type":"MATRIX"}
		,"layer": "00020"
		,"initFunction":"{initCake(animation);}"
		,"runFunction":"{drawCake(animation);}"
		,"angle": [
			   {"pivot":{"z":-0}, "degreesX":90} 
			  ,{"duration": durationTime, "degreesZ":900} 
		]
		,"position":[{"z":-13,"y":-2},{"duration":25},{"duration":5,"z":-1,"y":-8}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime, "light":{"index":0, "action":"end"}
		,"layer": "00020"
	}]);
	
	this.loader.addAnimation([
	{
		 "start": startTime+decoStartTime, "duration": durationTime-decoStartTime, "object":"deco","shape":{"type":"MATRIX"}
		,"layer": "00022"
		,"initFunction":"{initCakeDecoration(animation);}"
		,"runFunction":"{drawCakeDecoration(animation);}"
		,"angle": [
			   {"pivot":{"z":-0}, "degreesX":90} 
			  ,{"duration": durationTime, "degreesZ":-600} 
		]
		,"position":[{"z":-13,"y":-2},{"duration":25-decoStartTime},{"duration":5,"z":-1,"y":-7}]
		,"color":[
			{"a":0},{"duration":1,"a":255}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00025", "image": "data/bg.png"
		,"shader":{"name":"Wavy",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart()/3.0;}"]}
			]
		}
		,"color":[
			 {"a":255}
			,{"duration":1,"a":0}
		]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00025", "image": "data/bg2.png"
		,"color":[
			 {"a":255}
			,{"duration":1,"a":0}
			,{"duration":durationTime-2}
			,{"duration":1,"a":255}
		]
	}]);

}


var accessoriesImages;
function initCubeTextureReplace(animation)
{
	accessoriesImages = [
		  imageLoadImage("data/heart.png")
		 ,imageLoadImage("data/naali.png")
		 ,imageLoadImage("data/t101.png")
		 ,imageLoadImage("data/duncan.png")
	];
}

function drawCubeFaceTexture(animation, index, x, y)
{
	var time = getSceneTimeFromStart();
	var scale = 0.6+0.25*(Math.sin(time*13.05)+1)/2;
	var pic = 0;

	var scalePositioning = 512*(1-scale)/2;
	glColor4f(1,1,1,1);
	
	setTexturePosition(accessoriesImages[pic].ptr, x+scalePositioning, y+scalePositioning, 0);
	setTextureScale(accessoriesImages[pic].ptr, scale, scale);
	setTextureCanvasDimensions(accessoriesImages[pic].ptr, 1024, 1024);
	drawTexture(accessoriesImages[pic].ptr);

	var naaliStart = 54;
	var t101Start = naaliStart+4;
	var duncanStart = t101Start+4;
	var alpha = 0;
	scale = 1;
	if (time >= naaliStart && index == 0)
	{
		alpha = (time-naaliStart)/1.0;
		pic = 1;
	}
	else if (time >= t101Start && index == 1)
	{
		alpha = (time-t101Start)/1.0;
		pic = 2;
	}
	else if (time >= duncanStart && index == 2)
	{
		alpha = (time-duncanStart)/1.0;
		pic = 3;
	}
	if (alpha > 1.0) { alpha = 1.0; }

	var scalePositioning = 512*(1-scale)/2;
	glColor4f(1,1,1,alpha);	
	setTexturePosition(accessoriesImages[pic].ptr, x+scalePositioning, y+scalePositioning, 0);
	setTextureScale(accessoriesImages[pic].ptr, scale, scale);
	setTextureCanvasDimensions(accessoriesImages[pic].ptr, 1024, 1024);
	drawTexture(accessoriesImages[pic].ptr);
}

function drawCubeTextureReplace(animation)
{
	drawCubeFaceTexture(animation, 0, 0, 0);
	drawCubeFaceTexture(animation, 1, 0, 512);
	drawCubeFaceTexture(animation, 2, 512, 512);
}

var cubeObject = {};
function initCubes(animation)
{
	cubeObject.ref = loadObject("cube.3ds");
	useObjectLighting(cubeObject.ref.ptr, 0);
	useObjectCamera(cubeObject.ref.ptr, 0);
	
	replaceObjectTexture(cubeObject.ref.ptr, "gfx_cube.png", "fboCube.color.fbo");
}

function drawCubes(animation)
{
	//setObjectPivot
	drawObject(cubeObject.ref.ptr, "Camera01", 0, 0);
}

var particleX = 0;
var particleY = 0;
var particleZ = 0;
var particleContainer;
function particleInit(particleContainer, particle)
{
	var scale = 2+random()*9.9;	
	setParticleScaleRange(particle.ptr, scale, scale, scale, scale, scale, scale);
	
	var precision = 20;
	var radius = 0.5;

	var x = particleX;
	var y = particleY;
	var z = particleZ;
	var angle = (random()*precision+precision)*2*Math.PI/precision;
	var endX = x + random() * radius*2 - radius;
	var endY = y + random() * radius*2 - radius;
	var endZ = z + random() * radius*2 - radius;
	setParticlePositionRange(particle.ptr, x, y, z, endX, endY, endZ);
	
	var lifeSeconds = 0.6;	
	var startTime = getSceneTimeFromStart()+random()*3;
	var duration = lifeSeconds+random()*lifeSeconds;
	if (particleX+particleY+particleZ==0) {duration=0;}
	setParticleTime(particle.ptr, startTime, duration);
	
	var color = colorPalette[Math.floor(random()*colorPalette.length)];
	setParticleColor(particle.ptr, color.r/255,color.g/255,color.b/255, 1);	
}

var particleDuration = 18;
function initParticles(animation)
{
	particleContainer = initParticleContainer();
	setParticleContainerTime(particleContainer.ptr, 15, particleDuration);
	setParticleContainerPerspective3d(particleContainer.ptr, 1);
	setParticleContainerParticleInitDelay(particleContainer.ptr, 0.01);
	setParticleContainerParticleInitCountMax(particleContainer.ptr, 250);

	bindParticleContainerInitParticleFunction(particleContainer.ptr, "particleInit");
	initParticleContainerParticles(particleContainer.ptr, 0, 10000);
}

function drawParticles(animation)
{
	var time = getSceneTimeFromStart()-animation.start;
	var percent = time/particleDuration;
	
	var precision = 120;
	var radius = 5.5;
	var x = -0;
	var y = -1.5;
	var z = -1.5;
	
	var i = percent*precision;
	var x1 = x;
	var y1 = y;
	var angle = (i+precision)*13*Math.PI/precision;
	var x2 = Math.cos(angle) * radius * (1-i/precision*0.7);
	var y2 = Math.sin(angle) * radius * (1-i/precision*0.7);
	
	var dx = x + x2;
	var dy = y + y2;
	var dz = z+i/precision*8;
	
	particleX = dx;
	particleY = dy;
	particleZ = dz;

	drawParticleContainer(particleContainer.ptr);

	glColor3f(1,1,1);
}

var cakeObject = {};
function initCake(animation)
{
	cakeObject.ref = loadObject("cake.3ds");
	useObjectLighting(cakeObject.ref.ptr, 0);
	useObjectCamera(cakeObject.ref.ptr, 0);
}

function drawCake(animation)
{
	drawObject(cakeObject.ref.ptr, "Camera01", 0, 0);
}

var cakeDecorationImage;
var penisImage;
function initCakeDecoration(animation)
{
	cakeDecorationImage = imageLoadImage("soldiers_01.png");
	penisImage = imageLoadImage("d0.png");
}

function drawCakeDecorationTier(animation, x,y,z,radius,precision)
{
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	for (var i=0; i <= precision; i++)
	{
		var x1 = x;
		var y1 = y;
		var angle = (i+precision)*2*Math.PI/precision;
		var x2 = Math.cos(angle) * radius;
		var y2 = Math.sin(angle) * radius;
		
		angle = (i+1+precision)*2*Math.PI/precision;
		var x3 = Math.cos(angle) * radius;
		var y3 = Math.sin(angle) * radius;

		var dx2 = x + x2;
		var dy2 = y + y2;
		var dz2 = z;

		var dx3 = x + x3;
		var dy3 = y + y3;
		var dz3 = z+2;

		glBindTexture(GL_TEXTURE_2D, cakeDecorationImage.id);
		glBegin(GL_QUADS);
		glTexCoord2f(1,0);
		glVertex3f(dx2, dy2, dz2);
		glTexCoord2f(1,1);
		glVertex3f(dx2, dy2, dz3);
		glTexCoord2f(0,1);
		glVertex3f(dx3, dy3, dz3);
		glTexCoord2f(0,0);
		glVertex3f(dx3, dy3, dz2);
		glEnd();

	}
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
}

function drawCakeDecoration(animation)
{
	drawCakeDecorationTier(animation, 0,0,-2, 5.0, 25);
	drawCakeDecorationTier(animation, 0,0,1.8, 3.0, 15);
}

Cake.prototype.preInitCredits = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00030", "image": "fag.png"
		,"color":[
			 {"a":0}
			,{"duration":0.5,"a":255}
			,{"duration":3,"a":255}
			,{"duration":0.5,"a":0}
		]
		,"shader":{"name":"Wavy",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00030", "image": "kakkua.png"
		,"color":[
			 {"start":3.5,"a":0}
			,{"duration":0.5,"a":255}
			,{"duration":3,"a":255}
			,{"duration":1,"a":0}
		]
		,"shader":{"name":"Wavy",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
}
