/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.nio.fs.AbstractFileTypeDetector;

class MimeTypesFileTypeDetector
extends AbstractFileTypeDetector {
    private final Path mimeTypesFile;
    private Map<String, String> mimeTypeMap;
    private volatile boolean loaded = false;

    public MimeTypesFileTypeDetector(Path path) {
        this.mimeTypesFile = path;
    }

    @Override
    protected String implProbeContentType(Path path) {
        String string;
        Path path2 = path.getFileName();
        if (path2 == null) {
            return null;
        }
        String string2 = MimeTypesFileTypeDetector.getExtension(path2.toString());
        if (string2.isEmpty()) {
            return null;
        }
        this.loadMimeTypes();
        if (this.mimeTypeMap == null || this.mimeTypeMap.isEmpty()) {
            return null;
        }
        do {
            if ((string = this.mimeTypeMap.get(string2)) != null) continue;
            string2 = MimeTypesFileTypeDetector.getExtension(string2);
        } while (string == null && !string2.isEmpty());
        return string;
    }

    private static String getExtension(String string) {
        int n;
        String string2 = "";
        if (string != null && !string.isEmpty() && (n = string.indexOf(46)) >= 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMimeTypes() {
        if (!this.loaded) {
            MimeTypesFileTypeDetector mimeTypesFileTypeDetector = this;
            synchronized (mimeTypesFileTypeDetector) {
                if (!this.loaded) {
                    List<String> list = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

                        @Override
                        public List<String> run() {
                            try {
                                return Files.readAllLines(MimeTypesFileTypeDetector.this.mimeTypesFile, Charset.defaultCharset());
                            }
                            catch (IOException iOException) {
                                return Collections.emptyList();
                            }
                        }
                    });
                    this.mimeTypeMap = new HashMap<String, String>(list.size());
                    String string = "";
                    for (String string2 : list) {
                        if ((string = string + string2).endsWith("\\")) {
                            string = string.substring(0, string.length() - 1);
                            continue;
                        }
                        this.parseMimeEntry(string);
                        string = "";
                    }
                    if (!string.isEmpty()) {
                        this.parseMimeEntry(string);
                    }
                    this.loaded = true;
                }
            }
        }
    }

    private void parseMimeEntry(String string) {
        block6: {
            block5: {
                String[] stringArray;
                String string2;
                Pattern pattern;
                Matcher matcher;
                if ((string = string.trim()).isEmpty() || string.charAt(0) == '#') {
                    return;
                }
                int n = (string = string.replaceAll("\\s*#.*", "")).indexOf(61);
                if (n <= 0) break block5;
                String string3 = "\\btype=(\"\\p{Graph}+?/\\p{Graph}+?\"|\\p{Graph}+/\\p{Graph}+\\b)";
                Pattern pattern2 = Pattern.compile(string3);
                Matcher matcher2 = pattern2.matcher(string);
                if (!matcher2.find()) break block6;
                String string4 = matcher2.group().substring("type=".length());
                if (string4.charAt(0) == '\"') {
                    string4 = string4.substring(1, string4.length() - 1);
                }
                if (!(matcher = (pattern = Pattern.compile(string2 = "\\bexts=(\"[\\p{Graph}|\\p{Blank}]+?\"|\\p{Graph}+\\b)")).matcher(string)).find()) break block6;
                String string5 = matcher.group().substring("exts=".length());
                if (string5.charAt(0) == '\"') {
                    string5 = string5.substring(1, string5.length() - 1);
                }
                for (String string6 : stringArray = string5.split("[\\p{Blank}|\\p{Punct}]+")) {
                    this.putIfAbsent(string6, string4);
                }
                break block6;
            }
            String[] stringArray = string.split("\\s+");
            int n = 1;
            while (n < stringArray.length) {
                this.putIfAbsent(stringArray[n++], stringArray[0]);
            }
        }
    }

    private void putIfAbsent(String string, String string2) {
        if (!(string == null || string.isEmpty() || string2 == null || string2.isEmpty() || this.mimeTypeMap.containsKey(string))) {
            this.mimeTypeMap.put(string, string2);
        }
    }
}

