import ddf.minim.*;
import moonlander.library.*;

Moonlander moonlander;

static int xCenter;
static int yCenter;

Dust d[];

void setup() 
{
  moonlander = Moonlander.initWithSoundtrack(this, "Flotsam.mp3", 100, 4);
  
  fullScreen( P3D );
  //size(640, 480, P3D);
  xCenter = width / 2;
  yCenter = height / 2;
  
  d = new Dust[8000];
  for(int u=0; u<d.length; u++)
    d[u] = new Dust();
    
  //confetti = new Dust[100];  
  //for(int u=0; u<confetti.length; u++)
   // confetti[u] = new Dust(2);
    colorMode( HSB );
    strokeWeight(2);
    noSmooth();
    //ortho();
    moonlander.start();
}


void draw()
{
  print( moonlander.getCurrentTime());
  if( moonlander.getCurrentTime() >= 38.45) 
    exit();
  
  moonlander.update();
  
  background(0,0.5);
  
  float rho = (float)moonlander.getValue("rho");
  float phi = radians((float)moonlander.getValue("phi"));
  float theta = radians((float)moonlander.getValue("theta"));
  
  //camera(width/2, height/2, (height/2) / tan(PI/6), width/2, height/2, 0, 0, 1, 0);
  float xD = rho * sin(phi) * cos(theta);
  float zD = rho * sin(phi) * sin(theta);
  float yD = - rho * cos(phi);
  
  //println("x and y nad z : " + xD + " " + yD + " " + zD );
  
  float camLookX = (float)moonlander.getValue("CamLookX");
  float camLookY = (float)moonlander.getValue("CamLookY");
  float camLookZ = (float)moonlander.getValue("CamLookZ");
  
  fill(0);
  strokeWeight(10);
  //point( camLookX, camLookY, camLookZ);
   
  camera( xD, yD,  zD, camLookX,  camLookY, camLookZ, 0, 1, 0);
  
  fill(50);
  rectMode( CENTER );
  noFill();
  //rect( xCenter, yCenter, 400, 200);
 
  double numb = moonlander.getValue("cube_number");

 pushMatrix();
  for( int q = 0; q < numb ; q++ )
  {
    rotateY( PI / 3 * sin( radians( frameCount ) ) + PI/3 );
    pushMatrix();
    rotateX(PI / 5.0);
    rotateZ(PI / 4.0 );
    strokeWeight(1);   
    stroke(150,255,220);
    //sphereDetail(2);
    //sphere(200 - q * 25);
    //stroke(210 - q * 5,255,220 + q * 5);
   
    box(200 - q * 25);
    
    popMatrix();
  }
 popMatrix();
  
  for( int i=0; i < d.length ; i++ )
  {
    strokeWeight(2);
    stroke(120,255,220);
    fill(0,255,0);
    Dust du = d[i];
    if( (frameCount >> i >> 13 ) % 4 != 0)
      stroke(0);
     point( du.x, du.y, du.z);
    //ellipse( du.x, du.y, 10, 10);
    du.move();
  }
  
  int ccTimer = (int)moonlander.getValue("ConcentricPhase");
  int numCircs = (int)moonlander.getValue("NumCircs");
  
  //concentric circles
  for(int a=2; a<numCircs; a++)
  {
    pushMatrix();
      float vertDisp =  150 / sqrt(a) * sin( radians( (28 - a) * ccTimer / 5) );
      stroke( (vertDisp + 120) % 256, 100, 200 );
      
      strokeWeight( (int) lerp(2, 1, vertDisp / 150 ));
      noFill();
      translate(0, height + vertDisp , 0);
      rotateX(PI / 2 );
      //translate(0, height/3, 0);
      int radius = a * 25;
      ellipse(0,0, radius, radius);
    popMatrix();
  }
  
  drawRingCubes();
  /*for( int i=0; i < confetti.length ; i++ )
  {
     stroke(0);
     colorMode(HSB);
     fill( random(140, 190), 200, 200);
     pushMatrix();
     rotateX( random(0, PI/2) );
     
     popMatrix();
     
  }*/
}

void drawRingCubes() {
  
  
  int num = (int)moonlander.getValue("cubeRings");
  final int radius = 400;
  for( int a=0; a<num; a++ )
   {
     pushMatrix();
     translate( radius * sin( PI * 2 * a / num ), height * 3/4,  radius * cos(PI * 2 * a/num));
     float shift = 20 * sin( frameCount / 10.0 + a * 5 );
     float pShift = 20 * sin( frameCount / 10.0 + a * 5 + PI/3);
     translate(0, -shift, 0);
     rotateY( (frameCount + a * 7 )/ 10 );
     strokeWeight(1);
     stroke(90,110,215);
     box(50,50+pShift,50);
     popMatrix();
   }
}