//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID19ffd740_32bb_4f31_a976_2ea9dee64b32
{
    public class Class_Displace2dAngle : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Displacement = 1,
            Image = 2,
            SampleRadius = 3,
            DisplaceAmount = 4,
            DisplaceOffset = 5,
            SampleCount = 6,
            ShiftX = 7,
            ShiftY = 8,
            Angle = 9
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Displacement = inputs[(int)InputId.Displacement].Eval(context).Image; // Needs to be checked for null!
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var SampleRadius = inputs[(int)InputId.SampleRadius].Eval(context).Value;
            var DisplaceAmount = inputs[(int)InputId.DisplaceAmount].Eval(context).Value;
            var DisplaceOffset = inputs[(int)InputId.DisplaceOffset].Eval(context).Value;
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            var ShiftX = inputs[(int)InputId.ShiftX].Eval(context).Value;
            var ShiftY = inputs[(int)InputId.ShiftY].Eval(context).Value;
            var Shift = new Vector2(ShiftX, ShiftY);
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                SampleCount = (float)Math.Floor(SampleCount);
                //>>> _setup
                using (var DisplacementView = new ShaderResourceView(context.D3DDevice, Displacement))
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Displacement").AsShaderResource().SetResource(DisplacementView);
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("SampleRadius").AsScalar().Set(SampleRadius);
                    _effect.GetVariableByName("DisplaceAmount").AsScalar().Set(DisplaceAmount);
                    _effect.GetVariableByName("DisplaceOffset").AsScalar().Set(DisplaceOffset);
                    _effect.GetVariableByName("SampleCount").AsScalar().Set(SampleCount);
                    _effect.GetVariableByName("Shift").AsVector().Set(new Vector2(ShiftX, ShiftY));
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

