//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID2c8befc6_3768_4da0_b4fa_11032beb981a
{
    public class Class_4ColorGradient : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            ColorRadiusA = 1,
            ColorRadiusB = 2,
            ColorRadiusC = 3,
            ColorAR = 4,
            ColorAG = 5,
            ColorAB = 6,
            ColorAA = 7,
            ColorBR = 8,
            ColorBG = 9,
            ColorBB = 10,
            ColorBA = 11,
            ColorCR = 12,
            ColorCG = 13,
            ColorCB = 14,
            ColorCA = 15,
            ColorDR = 16,
            ColorDG = 17,
            ColorDB = 18,
            ColorDA = 19,
            FromX = 20,
            FromY = 21,
            ToX = 22,
            ToY = 23
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var ColorRadiusA = inputs[(int)InputId.ColorRadiusA].Eval(context).Value;
            var ColorRadiusB = inputs[(int)InputId.ColorRadiusB].Eval(context).Value;
            var ColorRadiusC = inputs[(int)InputId.ColorRadiusC].Eval(context).Value;
            var ColorRadius = new Vector3(ColorRadiusA, ColorRadiusB, ColorRadiusC);
            var ColorAR = inputs[(int)InputId.ColorAR].Eval(context).Value;
            var ColorAG = inputs[(int)InputId.ColorAG].Eval(context).Value;
            var ColorAB = inputs[(int)InputId.ColorAB].Eval(context).Value;
            var ColorAA = inputs[(int)InputId.ColorAA].Eval(context).Value;
            var ColorA = new Color4(ColorAR, ColorAG, ColorAB, ColorAA);
            var ColorBR = inputs[(int)InputId.ColorBR].Eval(context).Value;
            var ColorBG = inputs[(int)InputId.ColorBG].Eval(context).Value;
            var ColorBB = inputs[(int)InputId.ColorBB].Eval(context).Value;
            var ColorBA = inputs[(int)InputId.ColorBA].Eval(context).Value;
            var ColorB = new Color4(ColorBR, ColorBG, ColorBB, ColorBA);
            var ColorCR = inputs[(int)InputId.ColorCR].Eval(context).Value;
            var ColorCG = inputs[(int)InputId.ColorCG].Eval(context).Value;
            var ColorCB = inputs[(int)InputId.ColorCB].Eval(context).Value;
            var ColorCA = inputs[(int)InputId.ColorCA].Eval(context).Value;
            var ColorC = new Color4(ColorCR, ColorCG, ColorCB, ColorCA);
            var ColorDR = inputs[(int)InputId.ColorDR].Eval(context).Value;
            var ColorDG = inputs[(int)InputId.ColorDG].Eval(context).Value;
            var ColorDB = inputs[(int)InputId.ColorDB].Eval(context).Value;
            var ColorDA = inputs[(int)InputId.ColorDA].Eval(context).Value;
            var ColorD = new Color4(ColorDR, ColorDG, ColorDB, ColorDA);
            var FromX = inputs[(int)InputId.FromX].Eval(context).Value;
            var FromY = inputs[(int)InputId.FromY].Eval(context).Value;
            var From = new Vector2(FromX, FromY);
            var ToX = inputs[(int)InputId.ToX].Eval(context).Value;
            var ToY = inputs[(int)InputId.ToY].Eval(context).Value;
            var To = new Vector2(ToX, ToY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("ColorRadius").AsVector().Set(new Vector3(ColorRadiusA, ColorRadiusB, ColorRadiusC));
                    _effect.GetVariableByName("ColorA").AsVector().Set(new Vector4(ColorAR, ColorAG, ColorAB, ColorAA));
                    _effect.GetVariableByName("ColorB").AsVector().Set(new Vector4(ColorBR, ColorBG, ColorBB, ColorBA));
                    _effect.GetVariableByName("ColorC").AsVector().Set(new Vector4(ColorCR, ColorCG, ColorCB, ColorCA));
                    _effect.GetVariableByName("ColorD").AsVector().Set(new Vector4(ColorDR, ColorDG, ColorDB, ColorDA));
                    _effect.GetVariableByName("From").AsVector().Set(new Vector2(FromX, FromY));
                    _effect.GetVariableByName("To").AsVector().Set(new Vector2(ToX, ToY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



