//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#define SCR_WIDTH			80
#define SCR_HEIGHT			200

#define COLOR_BLACK			0x00    // Void
#define COLOR_BLUE          0x01    // Nothing
#define COLOR_BRIGHT_BLUE   0x02    // Basic tile
#define COLOR_SKY_BLUE      0x03    // Nothing
#define COLOR_BRIGHT_CYAN   0x04    // Nothing
#define COLOR_PASTEL_CYAN   0x05    // Nothing
#define COLOR_CYAN          0x06    // Nothing
#define COLOR_BRIGHT_GREEN  0x07    // Nothing
#define COLOR_SEA_GREEN     0x08    // Nothing
#define COLOR_RED           0x09    // Nothing
#define COLOR_BRIGHT_RED    0x0A    // Map End.
#define COLOR_PURPLE        0x0B    // Kill Tile - Vertical
#define COLOR_PINK          0x0C    // Kill Tile - Horizontal
#define COLOR_ORANGE        0x0D    // Deform Block
#define COLOR_BRIGHT_YELLOW 0x0E    // Moving Block
#define COLOR_BRIGHT_WHITE  0x0F    // Player Start.

#define MAP_VOID                COLOR_BLACK
#define MAP_BASIC_01            COLOR_BRIGHT_BLUE
#define MAP_END                 COLOR_BRIGHT_RED
#define MAP_LASER_VERTICAL      COLOR_PURPLE
#define MAP_LASER_HORIZONTAL    COLOR_PINK
#define MAP_DEFORM_BLOCK        COLOR_ORANGE
#define MAP_MOVING_BLOCK        COLOR_BRIGHT_YELLOW
#define MAP_PLAYER_START        COLOR_BRIGHT_WHITE

#define MAP_WIDTH			20
#define MAP_HEIGHT			12
#define MAP_HALF_WIDTH      10

#define TILE_WIDTH          4
#define TILE_HEIGHT         16

#define BIT_1				0x01
#define BIT_2				0x02
#define BIT_3				0x04
#define BIT_4				0x08
#define BIT_5				0x10
#define BIT_6				0x20
#define BIT_7				0x40
#define BIT_8				0x80
#define MAX_U8_VALUE		0xFF

#define JUMP_SIZE			18
#define MAX_SPEED           12
#define HALF_MAX_SPEED      6

#define NUM_MAPS            78

#define DEATH_TIME          25
#define WIN_TIME            50

#define MAX_DEFORM_BLOCKS   32
#define DEFORM_BLOCK_TIME   90

#endif
