;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Dragon Attack - An entry for CPCRetroDev2016
;;  Copyright (C) 2016  Paul Kooistra
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;
;;  For questions about the source you can PM me, Axelay, on the CPCWiki forums
;;-------------------------------------------------------------------------------
nolist
org &9000
run &9000
write direct "a:disc-ni.bin"

;Int_start equ &17d5

; experiment
    ld hl,(&be7d)
    ld a,(hl)
    ld (drive+1),a
;
    ld c,&ff
    ld hl,startldr
    call &bd16
.startldr
    call &bb57 ; TXT_VDU_DISABLE
    call &bccb ; KL_ROM_WALK
    call &bb54 ; TXT_VDU_ENABLE
.drive
    ld a,0
    ld hl,(&be7d)
    ld (hl),a
; needed above?

; set mode 0
    ld a,0
    call &bc0e
; set border black
    ld bc,&d0d
    call &bc38
; set loader colours
    ld hl,LoaderCols
    ld a,15
    call SetColours

; set width of display window
ld bc,&bc01
out (c),c
ld bc,&bd00+32
out (c),c

;; set horizontal sync position and therefore the
;; horizontal position of the display window
;; within the monitor display
ld bc,&bc02
out (c),c
ld bc,&bd00+42
out (c),c

;; set height of display window
ld bc,&bc06
out (c),c
ld bc,&bd00+32 ;45 ;35
out (c),c

;; set vertical sync position and therefore the
;; vertical position of the display window
;; within the monitor display
ld bc,&bc07
out (c),c
ld bc,&bd00+34 ;47 ;35
out (c),c

; load code file
    ld b,EndFN-CodeFN
    ld hl,CodeFN
    ld de,&40
    call LoadFile

    di
    ld sp,&38
;; set interrupt jump instruction
    ld a,&c3
    ld (&0038),a

; go to game
    jp &1800

.SetColours
; HL points to list, A holds 15 or 3

    ld b,(hl)
    ld c,b
    push af
    push hl
    call &bc32
    pop hl
    pop af
    inc hl
    cp a,0
    ret z
    dec a
    jr SetColours

; load a file
.LoadFile
; B has filename length, HL points to
; filename, DE location to load file

    push de
    ld de,&9000
    call &bc77
    pop hl
    call &bc83
    call &bc7a
    ret

.ErrorCols
    defb 6,14,26,0
.LoaderCols
    defb 25,25,25,20
    defb 25,0,25,25
    defb 23,14,4,26
    defb 0,0,0,13

.CodeFN
    text "CODE.BIN"
.EndFN
