<?
error_reporting(E_ALL);
ini_set('display_errors', true);

//--- part 1 - border
$b_chunks = array();
$scr_chunks = array();

$wait_arr = array(
	4 => 'NOP',
	5 => 'RET C',
	6 => 'DEC BC',
	7 => 'OR 0',
	8 => 'NOP:NOP',
	9 => 'LD R,A',
	10 => 'RET C:RET C',
	11 => 'NOP:OR 0',
	12 => 'NOP:NOP:NOP',
	13 => 'NOP:NOP:RET C',
	14 => 'NOP:RET C:RET C',
	15 => 'RET C:RET C:RET C',
);
for ($i=16; $i<512; $i++) {
	$wait_arr[$i] = 'NOP:' . $wait_arr[$i-4];
}

$out_arr = array(
	0 => 'OUT (C),E',
	1 => 'OUT (C),D',
);

$code = array();
$img_mask = imagecreatefrompng("preview/truba/4x4/truba-mask.png");
//--- top border
for ($y=0; $y<16; $y++) {
	$code_ln = array();
	$x = -4;
	$tl = $t = 0;
	$c0 = imagecolorat($img_mask, 0, $y) == 0 ? 0 : 1;
	while ($tl < 224) {
		$bx = $x<0 ? 0 : ($x>95 ? 95 : $x);
		$c = imagecolorat($img_mask, $bx, $y) == 0 ? 0 : 1;
		if ($c != $c0) {
			$code_ln[] = $out_arr[$c0];
			$t -= 12;
			if ($t != 0) {
				$code_ln[] = 'W' . $t;
			}
			$t = 0;
			$c0 = $c;
		}
		$t += 2;
		$tl += 2;
		$x++;
	}
	$code_ln[] = $out_arr[$c0];
	$t -= 12;
	if ($t != 0) {
		$code_ln[] = 'W' . $t;
	}
	$code[$y] = $code_ln;
}

//--- screen
for ($y=16; $y<64; $y++) {
	$code_ln = array();
	$x = -4;
	$tl = $t = 0;
	$c0 = imagecolorat($img_mask, 0, $y) == 0 ? 0 : 1;
	while ($tl < 224) {
		$bx = $x<0 ? 0 : ($x>95 ? 95 : $x);
		if ($bx >= 16 && $x < 80) {
			$bx = 15;
		}
		$c = imagecolorat($img_mask, $bx, $y) == 0 ? 0 : 1;
		if ($c != $c0) {
			$code_ln[] = $out_arr[$c0];
			$t -= 12;
			if ($t != 0) {
				$code_ln[] = 'W' . $t;
			}
			$t = 0;
			$c0 = $c;
		}
		$t += 2;
		$tl += 2;
		$x++;
	}
	$code_ln[] = $out_arr[$c0];
	$t -= 12;
	if ($t != 0) {
		$code_ln[] = 'W' . $t;
	}
	$code[$y] = $code_ln;
}

//--- bottom border
for ($y=64; $y<75; $y++) {
	$code_ln = array();
	$x = -4;
	$tl = $t = 0;
	$c0 = imagecolorat($img_mask, 0, $y) == 0 ? 0 : 1;
	while ($tl < 224) {
		$bx = $x<0 ? 0 : ($x>95 ? 95 : $x);
		$c = imagecolorat($img_mask, $bx, $y) == 0 ? 0 : 1;
		if ($c != $c0) {
			$code_ln[] = $out_arr[$c0];
			$t -= 12;
			if ($t != 0) {
				$code_ln[] = 'W' . $t;
			}
			$t = 0;
			$c0 = $c;
		}
		$t += 2;
		$tl += 2;
		$x++;
	}
	$code_ln[] = $out_arr[$c0];
	$t -= 12;
	if ($t != 0) {
		$code_ln[] = 'W' . $t;
	}
	$code[$y] = $code_ln;
}
	
	
//echo '<pre>'; print_r($code);
$code_txt = '';
foreach ($code as $ln=>$code_ln) {
	$code_txt .= ";----------- ln " . $ln . "\r\n";
	foreach ($code_ln as $cdln) {
		if (strstr($cdln, 'W')) {
			$code_txt .= "\t;" . $cdln . "\r\n";
			$tw = str_replace('W','',$cdln);
			$code_txt .= "\t" . $wait_arr[$tw] . "\r\n";
		} else {
			$code_txt .= "\t" . $cdln . "\r\n";
		}
		
	}
}
file_put_contents('../demo/kernal/effects/05/generated/out_code.asm', $code_txt);

//--- part 2 - screen
$lines = file_get_contents('../demo/kernal/effects/05/generated/out_code_color.asm');
$lines = explode("\r\n", $lines);
$ln_code_arr = array(
	'00' => 'LD (HL),E ;7',
	'01' => 'LD (HL),D ;7',
	'10' => 'LD (HL),C ;7',
	'11' => 'LD (HL),B ;7',
);
foreach ($lines as $ln_id=>$line) {
	if (strstr($line, ';----------- ln ')) {
		$zxln = (int)str_replace(';----------- ln ', '', $line);
		if ($zxln >= 15 && $zxln < 63 ) { //<63
			//E=00, D=01, C=10, B=11
			if ($zxln==21 || $zxln==22 || $zxln==51 || $zxln==52) {
				$code = array(
					'POP BC ;10',
					'POP DE ;10',
				);
			} else {
				$code = array(
					'POP BC ;10',
					'PUSH BC ;11',
					'LD A,C ;4',
					'ADD A,A ;4',
					'ADD A,A ;4',
					'ADD A,A ;4',
					'LD D,A ;4',
					'ADD A,C ;4',
					'LD E,A ;4',
					'LD A,D ;4',
					'ADD A,B ;4',
					'LD D,A ;4',
					'LD A,B ;4',
					'ADD A,A ;4',
					'ADD A,A ;4',
					'ADD A,A ;4',
					'ADD A,B ;4',
					'LD B,A ;4',
					'AND HX ;8',
					'ADD A,C ;4',
					'LD C,A ;4',
				);
			}
			$zxlnZ = $zxln+1;
			for ($x=0; $x<32; $x++) {
				$bx = 16 + $x*2;
				$clr_l = imagecolorat($img_mask, $bx, $zxlnZ) == 0 ? 0 : 1;
				$clr_r = imagecolorat($img_mask, $bx+1, $zxlnZ) == 0 ? 0 : 1;
				$code[] = $ln_code_arr[$clr_l . $clr_r];
				if ($x==31) {
					if ($zxln%2==0) {
						$code[] = 'LD DE,#8000-1 ;10';
						$code[] = 'SBC HL,DE ;15';
					} else {
						$code[] = 'LD DE,#8000-31 ;10';
						$code[] = 'ADD HL,DE ;11';
					}
				} else {
					$code[] = 'INC L ;4';
				}
			}
			$code_ln = array();
			foreach ($code as $c) {
				$c = explode(' ;', $c);
				if ((int)$c[1] == 0) {
					die('err');
				}
				$code_ln[] = array(
					'code' => $c[0],
					't' => $c[1],
				);
			}
            if ($zxln == 15)  {
                $t = 0;
                foreach ($code_ln as $c) {
                    $t += $c['t'];
                    echo $c['code'] . ':';
                }
                echo '<br>t=' . $t . '<br>';
            } else {
                $code_ln_id = 0;
                $l = $ln_id + 1;
                while (!strstr($lines[$l], ';----------- ln ')) {
                    if (strstr($lines[$l], '	;W')) {
                        if ($code_ln_id != sizeof($code_ln)) {
                            $tc = 8;
                            $lnw_code = array();
                            $lnw = (int)str_replace('	;W', '', $lines[$l]);
                            $lnw0 = $lnw -=8;
                            while ($code_ln_id != sizeof($code_ln) && 
                                (
                                    $lnw-$code_ln[$code_ln_id]['t'] == 0
                                    || $lnw-$code_ln[$code_ln_id]['t'] == 4
                                    || $lnw-$code_ln[$code_ln_id]['t'] == 5
                                    || $lnw-$code_ln[$code_ln_id]['t'] >= 7
                                )
                            ) {
                                $lnw_code[] = $code_ln[$code_ln_id]['code'];
                                $lnw -= $code_ln[$code_ln_id]['t'];
                                $tc += $code_ln[$code_ln_id]['t'];
                                $code_ln_id++;
                            }
                            if ($lnw0 != $lnw) {
                                if ($lnw > 0) {
                                    $lnw_code[] = $wait_arr[$lnw];
                                    $tc += $lnw;
                                }
                                $lines[$l+1] = "\tEXX:" . implode(':', $lnw_code) . ":EXX" . "\r\n;--- tc = " . $tc;
                            }
                        }
                    }
                    $l++;
                }
                if ($code_ln_id != sizeof($code_ln)) {
                    echo 'error line ' . $zxln . ': ' . $code_ln_id . '/' . sizeof($code_ln) . '<br>';
                }
            }
		}
	}
}
file_put_contents('../demo/kernal/effects/05/generated/out_code_all.asm', implode("\r\n", $lines));

//echo '<pre>'; print_r($lines);



//--- part 3 - color tables
$colors = array(
	0x000000 => 'BCLR0',
	//---
	0x000050 => 'BCLR1',
	0x730073 => 'BCLR2',
	0x7300CA => 'BCLR3',
	//---
	0x000073 => 'SCLR11',
	0x0000CA => 'SCLR12',
	0x0073CA => 'SCLR13',
	0x00CACA => 'SCLR14',
	0xCACACA => 'SCLR15',
	//---
	0x007300 => 'SCLR21',
	0x007373 => 'SCLR22',
	0x00CA00 => 'SCLR23',
	0xCACA00 => 'SCLR24',
	0xFFFFFF => 'SCLR25',
);

//$img_mask
$frames = 16;
$color_tbl = array();
for ($i=1; $i<=16; $i++) {
	$color_tbl[$i] = array();
	$img = imagecreatefrompng("preview/truba/4x4/" . sprintf('%02d',$i) . ".png");
	for ($y=0; $y<75; $y++) {
		$clr = imagecolorat($img,48,$y) == 0 ? 0 : 1;
		$clr_fx = array('BCLR0', 'BCLR0');
        $cx = 0; $x = 0;
        while ($cx == 0 && $x < 96) {
            $cx = imagecolorat($img,$x,$y);
            $x++;
        }
        $clr_id = $colors[$cx];
        if ($y < 21 or $y > 52) {
            $clr_id = $colors[imagecolorat($img_mask, 97, $y)];
        }
		$clr_fx[$clr] = $clr_id;
		$color_tbl[$i][$y] = $clr_fx;
	}
}
$incl_tbl = '';
foreach ($color_tbl as $f=>$frame) {
	$f0 = fopen("../demo/kernal/effects/05/generated/tbl_frame_" . $f . "A.asm", "w");
	$f1 = fopen("../demo/kernal/effects/05/generated/tbl_frame_" . $f . "B.asm", "w");
    
    fwrite($f0, "\tDW\t256 * " . $frame[16][1] . "A + " . $frame[16][0] . "A\r\n");
    fwrite($f1, "\tDW\t256 * " . $frame[16][1] . "B + " . $frame[16][0] . "B\r\n");
    
	foreach ($frame as $y=>$ln) {
		fwrite($f0, "\tDW\t256 * " . $ln[1] . "A + " . $ln[0] . "A\r\n");
		fwrite($f1, "\tDW\t256 * " . $ln[1] . "B + " . $ln[0] . "B\r\n");
		if ($y==21 || $y==22 || $y==51 || $y==52) {
			$lnx = $frame[$y+1];
			//POP BC:POP DE
			//E=00, D=01, C=10, B=11
			fwrite($f0, "\t\tDW\t256 * (8*" . $lnx[1] . "A + " . $lnx[1] . "A) + 8*" . $lnx[1] . "A + " . $lnx[0] . "A; xcolor\r\n");
			fwrite($f0, "\t\tDW\t256 * (8*" . $lnx[0] . "A + " . $lnx[1] . "A) + 8*" . $lnx[0] . "A + " . $lnx[0] . "A; xcolor\r\n");
			fwrite($f1, "\t\tDW\t256 * (8*" . $lnx[1] . "B + " . $lnx[1] . "B) + 8*" . $lnx[1] . "B + " . $lnx[0] . "B; xcolor\r\n");
			fwrite($f1, "\t\tDW\t256 * (8*" . $lnx[0] . "B + " . $lnx[1] . "B) + 8*" . $lnx[0] . "B + " . $lnx[0] . "B; xcolor\r\n");
		}
		
		
	}
	$incl_tbl .= ";---\r\n";
	$incl_tbl .= "FRAME" . $f . "A\tINCLUDE\t\"generated/tbl_frame_" . $f . "A.asm\"\r\n";
	$incl_tbl .= "FRAME" . $f . "B\tINCLUDE\t\"generated/tbl_frame_" . $f . "B.asm\"\r\n";
	
	fclose($f0);
	fclose($f1);
}
//echo '<pre>' . $incl_tbl;

//--- part 4 - rotate table
$f = fopen("../demo/kernal/effects/05/generated/rotate_tbl.bin", "w");
$frame_r = 80;
for ($alpha=0; $alpha<256; $alpha++) {
    $r = round($frame_r + $frame_r * cos($alpha * pi() / 128));
    $r = $r % 16;
    fputs($f, chr($r), 1);
}
fclose($f);

?>
<html>
	<head>
		<title>ACROSS THE EDGE - TRUBA</title>
		<link rel="shortcut icon" href="/favicon.png" type="image/png">
		<script>
			var alpha = 0;
			var alpha_step = 1.0666;	//0.53;
			var frame_r = 64;	//96;
			var frame = 0;
			function do_anim() {
				frame = Math.round(frame_r + frame_r * Math.cos(alpha * Math.PI / 128));
				frame = (frame % 16) + 1;
				frame = String(frame);
				if (frame.length == 1) {
					frame = '0' + frame;
				}
				document.getElementById('image').src = 'preview/truba/4x4/' + frame + '.png';
				alpha += alpha_step;
				if (alpha >= 256) {
					alpha -= 256;
				}
			}
			setInterval(function(){
				do_anim();
			},20);
			
		</script>
	</head>
	<body>
		<h1>ACROSS THE EDGE - TRUBA</h1>
		<div class="selector"><a href="index.php">back</a></div>
		<img id="image" src="preview/truba/4x4/01.png" width="256px" />
		
	</body>
</html>