//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
CLR0_1	EQU	1
CLR1_1	EQU	4

//======================================================== FX_INIT
EFF_INI_
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	XOR	A
	OUT	(#FE),A

	LD	BC,393
W1	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W1
	SCF
	RET	NC
	RET	NC
	NOP:NOP:NOP

	CALL	TRUBA

	SCF
	;RET	NC
	;RET	NC
	;RET	NC
	RET
//======================================================== FX_PROCEDURES
TRUBA	LD	(SOHRSP1),SP
	LD	SP,LN_TBL
	XOR	A
	LD	BC,#00FE
	EXX
	LD	BC,#7FFD
	LD	HL,#17*256 + #15+#08
	EXX
	SCF
	RET
TRUBA_RET
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;-------
LN0	LD	D,CLR0_1	;7
	OUT	(C),D	;12
	NOP:NOP ;8
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	NOP ;4
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	INC HL ;6
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	DEC HL ;6
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	NOP ;4
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	LD B,0 ;7
	RET		;10
;-------
LN1	LD	D,CLR1_1	;7
	OUT	(C),D	;12
	NOP ;4
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	INC HL ;6
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	NOP:NOP ;8
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	NOP:NOP ;8
	OUT	(C),B	;12
	NOP:NOP ;8
	OUT	(C),D	;12
	DEC HL ;6
	OUT	(C),B	;12
	LD B,0 ;7
	OUT	(C),D	;12
	NOP	;4
	RET		;10
;-------
LN3	LD	D,CLR1_1	;7
	OUT	(C),D	;12
	OUT	(C),B	;12
	NOP:NOP	;8
	OUT	(C),D	;12
	NOP:NOP	;8
	OUT	(C),B	;12
	NOP:NOP	;8
	OUT	(C),D	;12
	RET NC:RET NC ;10
	OUT	(C),B	;12
	NOP:NOP	;8
	OUT	(C),D	;12
	RET NC:RET NC ;10
	OUT	(C),B	;12
	NOP:NOP	;8
	OUT	(C),D	;12
	NOP:NOP	;8
	OUT	(C),B	;12
	LD B,0 ;7
	OUT	(C),D	;12
	RET		;10

//======================================================== FX_INCLUDE_DATA

//======================================================== FX_TABLES
LN_TBL
	DW	LN0, LN0
	DW	LN1, LN1, LN1, LN1, LN1, LN1
	DW	LN3, LN3
	DW	TRUBA_RET


	
	

; минимальная длина со сторон - 8px
; имеем ~220t на смену 32байт => 6.875 на байт
; HL - full ink
; IX - full paper
; DE - only ink
; где 1-цвет, 0-black
; необходимо подготовить сетку, некоторые столбцы будут залиты, некоторыe подстроены под атрибуты

; или менять байты - 20*128=2560 знакомест за 2 фрейма (в основном потоке меняем цвет по 2м линиям)
; по факту меньше => 144+72+192+24+256 =688 *2=1376



	PUSH	HL	;11
	PUSH	DE	;11
	PUSH	IX	;15 => 6.17 per byte

	PUSH	HL	;11
	PUSH	DE	;11
	PUSH	ИС	;11 => 5.5 per byte


;--- LINEAR DATA MOVING

	;---------- 16t
	;custom attr, custom len
	;x32=512, x64=1024
	LDI		;16
	;---------- 11t
	;presetted attr, custom len
	;x32=352, x64=704
	LD	(HL),E	;7
	INC	L	;4
	LD	(HL),D	;7
	INC	L	;4
	LD	(HL),B	;7
	INC	L	;4
	LD	(HL),C	;7
	INC	L	;4 => 11 per byte
	;---------- 10.5t
	;custom attr
	; x32=336t, x64=672t
	LD	HL,0	;10
	PUSH	HL	;11 /21 => 10.5 
	;---------- 5.5t
	;(presetted attr HL,DE, len = 16/32/48/64/...)
	;x32=176, x64=352
	PUSH	HL	;11
	PUSH	DE	;11 => 5.5 per byte
	;---------- 7.5t
	;(presetted attr IX,IY, len = 16/32/48/64/...)
	;x32=240, x64=480
	PUSH	IX	;15
	PUSH	IY	;15 => 7.5 per byte
	;---------- 6.5t
	;(presetted attr IX,HL, len = 16/32/48/64/...)
	;x32=208, x64=416
	PUSH	HL	;11
	PUSH	IX	;15 => 6.5 per byte
	;---------- 6.3t
	;(presetted attr IX,IY,HL,DE,BC len = 16/32/48/64/...)
	;x32=201.6, x64=403.2
	PUSH	BC	;11
	PUSH	HL	;11
	PUSH	DE	;11
	PUSH	IX	;15
	PUSH	IY	;15	=> 6.3 per byte
	