SWAP_FRAME_WAIT	EQU	0

	;use only attributes 1/0 (fast speed, best sync)
	DEFINE	ONLYATTR 0
	;border-move-speed 1/2
	DEFINE	BGSTEP 2

	ORG	#6B00		;#6B00	;#6CF8
LNNC	INCLUDE	"lines_nocorr.asm"
	DISPLAY	"lines_nocorr start: ", /A, LNNC
	DISPLAY	"lines_nocorr len: ", /A, $-LNNC
	DISPLAY	"lines_nocorr end: ", /A, $
	SAVEBIN "04_codeadd.bin", #6B00, $-#6B00
	ORG	#8000
//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST\
INI_CHUNK_BYTE1	EQU	%00001111	;255/0
INI_CHUNK_BYTE2	EQU	%00001111
INI_MOVE_SIZE	EQU	1024	;1024/512/256

INI_ATTR	EQU	#5800
INI_SCRPG	EQU	#00
INI_SCRPG_1	EQU	#00

B_CLR0	EQU	0
B_CLR1	EQU	1

;-------- BG COLORS
CLR0A	EQU	0
CLR0B	EQU	0
;-
CLR1A	EQU	1
CLR1B	EQU	1
;-
CLR2A	EQU	5
CLR2B	EQU	1
;-------- SOSISKA COLORS
CLR3A	EQU	5
CLR3B	EQU	5
;-
CLR4A	EQU	5
CLR4B	EQU	4
;-
CLR5A	EQU	6
CLR5B	EQU	4
;-
CLR6A	EQU	7
CLR6B	EQU	7
;-
CLR7A	EQU	7
CLR7B	EQU	7
;-
CLR8A	EQU	6
CLR8B	EQU	2
;-
CLR9A	EQU	2
CLR9B	EQU	0
;-
CLR10A	EQU	3
CLR10B	EQU	0
;-
CLR11A	EQU	3
CLR11B	EQU	1
;-
CLR12A	EQU	5
CLR12B	EQU	1

CLRFA	EQU	7
CLRFB	EQU	7


BLN_STEP EQU	4	;4 default
;#6615

CBUFF_A_0	EQU	#7400	;1110100
CBUFF_B_0	EQU	#7700	;1110111
CBUFF_A_1	EQU	#7A00	;1111010
CBUFF_B_1	EQU	#7D00	;1111101
;---
SWAP_CBUFF_A	EQU	%00001110
SWAP_CBUFF_B	EQU	%00001010
CBUFF_DIFF	EQU	#0600

;low kernal free = 0DEB (3563)
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	LD	A,#17
	CALL	PAGER
	LD	A,7
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),7*8+7 ;debug
	LDIR
	;--
	CALL	SWAP
	CALL	SWAP_FRAME_INI
	LD	A,#10
	CALL	PAGER
	;---

	EXX
	LD	DE,CBUFF_A_0 + 768 - 1
	LD	BC,CBUFF_B_0 + 768
	EXX
	LD	HL,ATTR4
	CALL	FINI2
	INC HL:INC HL
	CALL	FINI2
	;---
	LD	A,#17
	CALL	PAGER
	;---
	RET
	
	
	LD	A,#17
	CALL	PAGER
	;---
	LD	HL,#4000
	LD	A,INI_CHUNK_BYTE1
	CALL	INI_LN
	LD	HL,#C000
	LD	A,INI_CHUNK_BYTE2
	CALL	INI_LN
	
	AND	A
	RET	C
	;RET	C
	;RET	C
	RET
INI_LN	LD	D,H
	LD	E,L
	INC	E
	LD	(HL),A
	LD	LX,6144/INI_MOVE_SIZE
FINI1	LD	BC,INI_MOVE_SIZE-1
	LDIR
	DEC	LX
	RET	Z
	LD	A,(HL)
	XOR	255
	INC	HL
	INC	DE
	LD	(HL),A
	JP	FINI1
	RET
	
FINI2	LD	BC,384
FINI0	LD	A,(HL)
	INC	HL
	;--
	EXX
	;--
	LD	L,A
	LD	H,TBL_C/256 ;7 /23
	;-
	LDD		;16
	INC	H	;4 /20
	;-
	LD	A,(HL)	;7
	LD	(BC),A	;7
	DEC	H	;4 /18
	;--
	EXX	;8 /8 //138
	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,FINI0
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
;---------------
	EI
	HALT
	;---
	CALL	CLRLDI
	;---
	LD	BC,#7FFD
	LD	A,#10 + INI_SCRPG_1
FPG10_1	EQU	$-1
	OUT	(C),A
	;---
	LD	(SOHRSP1),SP
	CALL	LINES_RGB_1
B_RET_1	OUT	(C),E
	LD	SP,0
SOHRSP1	EQU	$-2
	;---
	CALL	SWAP
	;---
	AND	A
	RET	C
	;RET	C
	;RET	C
;----------------
	EI
	HALT
	;---
	CALL	CLRLDI
	;---
	LD	BC,#7FFD
	LD	A,#10 + INI_SCRPG_1
FPG10_2	EQU	$-1
	OUT	(C),A
	;---
	LD	(SOHRSP2),SP
	CALL	LINES_RGB_2
B_RET_2	OUT	(C),E
	LD	SP,0
SOHRSP2	EQU	$-2
	;---
	IF	ONLYATTR = 1
		CALL	SWAP_FRAME
		CALL	SWAP
		;---
		AND	A
		RET	C
		RET	C
		RET	C
		RET
	ELSE
		CALL	SWAP
		;---
		AND	A
		RET	C
		;RET	C
		;RET	C
	ENDIF
;-----------------
	EI
	HALT
	;---
	CALL	CLRLDI
	;---
	LD	BC,#7FFD
	LD	A,#17 + INI_SCRPG_1
FPG17_1	EQU	$-1
	OUT	(C),A
	;---
	LD	(SOHRSP3),SP
	CALL	LINES_RGB_3
B_RET_3	OUT	(C),E
	LD	SP,0
SOHRSP3	EQU	$-2
	;---
	CALL	SWAP_FRAME
	CALL	SWAP
	;---
	AND	A
	RET	C
	RET	C
	RET	C
	;---
	RET

//======================================================== FX_PROCEDURES
SWAP	LD	A,0
	XOR	#FF
	LD	(SWAP+1),A
	AND	1
	;LD	(SWAP_B_1),A
	;LD	(SWAP_B_2),A
	;LD	(SWAP_B_3),A
	JP	Z,SWAP1
	;--
	LD	HL,CBUFF_A_0
SWCB_A_0 EQU	$-2
	LD	DE,CLR2A * 256 + CLR0A
	LD	A,CLR1A
	JP	SWAP2
SWAP1	;--
	LD	HL,CBUFF_B_0
SWCB_B_0 EQU	$-2
	LD	DE,CLR2B * 256 + CLR0B
	LD	A,CLR1B
	JP	SWAP2
SWAP2	LD	(CLRLDI+1),HL
	LD	(SWAP_B_1),A
	LD	(SWAP_B_2),A
	LD	(SWAP_B_3),A
	EX	DE,HL
	LD	(SWAP_BB_1),HL
	LD	(SWAP_BB_2),HL
	LD	(SWAP_BB_3),HL
	;---
	RET
;---
SWAP_FRAME
	LD	A,0
	INC	A
	AND	SWAP_FRAME_WAIT
	LD	(SWAP_FRAME+1),A
	RET	NZ
	DEC BC

SWAP_FRAME_INI
	;--- swap border - clear BLN
	LD	C,2*4
TBL_BLN_A EQU	$-1	
	LD	B,0
	LD	HL,TBL_BLN
	ADD	HL,BC
	;-
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	A,#ED
	LD	(DE),A
	;--- swap border - clear CLN
	LD	A,C
	RRA
	AND	63
	ADD	A,C
	LD	C,A
	LD	HL,TBL_CLN
	ADD	HL,BC
	PUSH	BC
	;--
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	A,#ED
	LD	(DE),A
	INC	DE
	LDI
	LDI
	;--- swap border - clear NCLN
	POP	BC
	LD	HL,TBL_NCLN
	ADD	HL,BC
	;-
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	A,#ED
	LD	(DE),A
	INC	DE
	LDI
	LDI
	;--- swap border - next step
	LD	A,(TBL_BLN_A)
	ADD	A,BLN_STEP
	CP	30*4-1
	;-
	JP	NC,SWAP1_1
	AND	A
	JP	SWAP2_1
SWAP1_1	XOR	A
	JP	SWAP2_1
SWAP2_1	LD	(TBL_BLN_A),A
	;--- swap border - next BLN
	LD	B,0
	LD	C,A
	LD	HL,TBL_BLN
	ADD	HL,BC
	;-
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	A,#C9
	LD	(DE),A
	;-
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(BLN_JP_1),DE
	LD	(BLN_JP_2),DE
	;--- swap border - next CLN
	LD	A,C
	RRA
	AND	63
	ADD	A,C
	LD	C,A
	LD	HL,TBL_CLN
	ADD	HL,BC
	;-
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	EX	DE,HL
	LD	(HL),#C3
	INC	HL
	LD	(HL),LOW B_RET_3
	INC	HL
	LD	(HL),HIGH B_RET_3
	EX	DE,HL
	;--
	INC	HL
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(BLN_JP_3),DE
	;--- swap border - next NCLN
	LD	HL,TBL_NCLN
	ADD	HL,BC
	;-
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	EX	DE,HL
	LD	(HL),#C3
	INC	HL
	LD	(HL),LOW B_RET_3
	INC	HL
	LD	(HL),HIGH B_RET_3
	EX	DE,HL
	;--- swap colors
	LD	A,(TBL_BLN_A)
	LD	E,A
	LD	D,0
	LD	HL,TBL_RGB
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	EX	DE,HL
	LD	(BLNSP1),HL
	LD	BC,384 + 2
	ADD	HL,BC
	LD	(BLNSP2),HL
	EX	DE,HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(BLNSP3),DE
	;---
;--swap buffers

	LD	A,INI_SCRPG
SCRPG	EQU	$-1
	XOR	#08
	LD	(SCRPG),A
	JP	Z,SWP_AB_1
	LD	HL,CBUFF_A_0
	LD	DE,CBUFF_A_1 + 384 - 1
	JP	SWP_AB_2
SWP_AB_1;---
	LD	HL,CBUFF_A_1
	LD	DE,CBUFF_A_0 + 384 - 1
	JP	SWP_AB_2
SWP_AB_2;---
	LD	(SWCB_A_0),HL
	LD	BC,#0300
	ADD	HL,BC
	LD	(SWCB_B_0),HL
	EX	DE,HL
	LD	(SWCB_A_2),HL
	LD	BC,#0301
	ADD	HL,BC
	LD	(SWCB_B_2),HL
	LD	BC,384
	ADD	HL,BC
	LD	(SWCB_B_1),HL
	LD	BC,0-#0301
	ADD	HL,BC
	LD	(SWCB_A_1),HL
	;---
	LD	A,(SWP_ATTR_ADR)
	ADD	A,#80
	LD	(SWP_ATTR_ADR),A
	LD	A,(SCRPG)
	OR	#10
	LD	(FPG10_1),A
	LD	(FPG10_2),A
	OR	#07
	LD	(FPG17_1),A
	RET

;--------------------------
CLRLDI	LD	HL,CBUFF_A_0
	LD	DE,INI_ATTR
SWP_ATTR_ADR EQU $-1
	;---
	LD	A,24
CLDI1	;---
	DUP	32
	LDI
	EDUP	;512
	;---
	DEC	A	;4
	JP	NZ,CLDI1 ;10 /12624
	;---
	LD	A,247
	DEC	A
	JP	NZ,$-1
	NOP:NOP
	RET
;--------------------------
LINES_RGB_3	;out correction chunks
	LD	HL,0
BLNSP3	EQU	$-2
	LD	A,(HL)	;7
	INC	HL	;6
	LD	SP,HL	;6 19

	NOP
	
	LD	BC,CHUNK_TBL + %11011000
	EXX
	;---
	LD	L,A
	LD	H,#03
	AND	A
	XOR	A
	;----
	LD	BC,#00FE
SWAP_B_3 EQU	$-1
	LD	DE,B_CLR1 * 256 + B_CLR0
SWAP_BB_3 EQU	$-2
	JP	CLN0
BLN_JP_3 EQU	$-2
;----------------
LINES_RGB_1
	LD	SP,ATTR1
BLNSP1	EQU	$-2
	;--
	LD	IY,BLN164ATTR
	LD	DE,CBUFF_A_1 + 768 - 1
SWCB_A_1 EQU	$-2
	LD	BC,CBUFF_B_1 + 768
SWCB_B_1 EQU	$-2
	EXX
	;---
	AND	A
	XOR	A
	LD	HL,#0300
	;----
	LD	BC,#00FE
SWAP_B_1 EQU	$-1
	LD	DE,B_CLR1 * 256 + B_CLR0
SWAP_BB_1 EQU	$-2
	JP	BLN0
BLN_JP_1 EQU	$-2
;----------------
LINES_RGB_2
	LD	SP,ATTR1 + 384 + 2
BLNSP2	EQU	$-2
	;--
	LD	IY,BLN164ATTR
	LD	DE,CBUFF_A_1 + 384 - 1
SWCB_A_2 EQU	$-2
	LD	BC,CBUFF_B_1 + 384
SWCB_B_2 EQU	$-2
	EXX
	;---
	AND	A
	XOR	A
	LD	HL,#0300
	;----
	LD	BC,#00FE
SWAP_B_2 EQU	$-1
	LD	DE,B_CLR1 * 256 + B_CLR0
SWAP_BB_2 EQU	$-2
	JP	BLN0
BLN_JP_2 EQU	$-2
;----------------
		INCLUDE "lines_attr.asm"
		INCLUDE	"lines_corr.asm"
;----------------
TBL_RGB		INCLUDE	"tbl_rgb.asm"
	IF BGSTEP = 1
TBL_BLN		INCLUDE	"tbl_bln.asm"
TBL_CLN		INCLUDE	"tbl_cln.asm"
TBL_NCLN	INCLUDE	"tbl_ncln.asm"
	ELSE
TBL_BLN		INCLUDE	"tbl_bln_x2.asm"
TBL_CLN		INCLUDE	"tbl_cln_x2.asm"
TBL_NCLN	INCLUDE	"tbl_ncln_x2.asm"
	ENDIF
//======================================================== FX_INCLUDE_DATA
;------------
ATTR22	INCLUDE	"generated/attr_22_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_22_1.asm"
	DW	B_RET_2	
;------------
ATTR23	INCLUDE	"generated/attr_23_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_23_1.asm"
	DW	B_RET_2
;------------
ATTR24	INCLUDE	"generated/attr_24_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_24_1.asm"
	DW	B_RET_2
;------------
ATTR25	INCLUDE	"generated/attr_25_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_25_1.asm"
	DW	B_RET_2
;------------
ATTR26	INCLUDE	"generated/attr_26_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_26_1.asm"
	DW	B_RET_2
;------------
ATTR27	INCLUDE	"generated/attr_27_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_27_1.asm"
	DW	B_RET_2
;------------
ATTR28	INCLUDE	"generated/attr_28_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_28_1.asm"
	DW	B_RET_2
;------------
ATTR29	INCLUDE	"generated/attr_29_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_29_1.asm"
	DW	B_RET_2
;------------
ATTR30	INCLUDE	"generated/attr_30_0.asm"
	DW	B_RET_1
	INCLUDE	"generated/attr_30_1.asm"
	DW	B_RET_2
	
	
	ORG	(($+255)/256)*256
TBL_C	INCLUDE	"generated/tbl_c_a.asm"
	INCLUDE	"generated/tbl_c_b_corr.asm"
CHUNK_TBL
	INCBIN	"generated/chunktbl.bin"
	INCBIN	"generated/chunktbl_hi.bin"
	
	DISPLAY	"CLINES SIZE: ", /A, CLINES_END-CLINES
	DISPLAY	"NOCLINES SIZE: ", /A, NOCLINES_END-NOCLINES
	
	DISPLAY	"CHUNK_TBL ", /A, CHUNK_TBL
