//based on UncleSporky's four color example
#include <SPI.h>
#include <EEPROM.h>
#include "arduboy.h"
#include "ArduboyExt.h"
#include "music.h"

#define B_BUTTON 1
#define A_BUTTON 2
#define DOWN 4
#define RIGHT 8
#define UP 16
#define LEFT 32

#define B2_BLACK 0
#define B2_GRAY 1
#define B2_WHITE 2
#define B2_BLANK 3


ArduboyExt display;
byte buttons;

byte musicMode = 1;   //the current user-selected music mode (1 = play music)

unsigned long lTime;
const byte FPS = 1000/68;

const byte PROGMEM tileset1 [] = {
0xFE,0x01,0x05,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x05,0x01,0xFE,
0xF1,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x1F,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
0xFE,0x01,0x55,0xA9,0x55,0xA9,0x55,0xA9,0x55,0xA9,0x55,0xA9,0x55,0xA9,0xFD,0xFE,
0xF9,0x15,0x99,0x55,0x99,0x55,0x99,0x55,0x9F,0x51,0x99,0x55,0x99,0x55,0x99,0x55,
0xFE,0x01,0xFD,0xF5,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xF5,0xFD,0xFF,0xFE,
0x1C,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xC1,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
0x00,0x00,0x00,0x10,0x60,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x80,0x00,
0x00,0xC0,0x10,0x2C,0x4A,0x28,0x05,0x21,0x18,0x71,0x3D,0xFE,0x7C,0x68,0xA0,0x40,

0x7F,0x80,0xA0,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xA0,0x80,0x7F,
0xF1,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x1F,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
0x7F,0x80,0xD5,0xEA,0xD5,0xEA,0xD5,0xEA,0xD5,0xEA,0xD5,0xEA,0xD5,0xEA,0xFF,0x7F,
0xF9,0x15,0x99,0x55,0x99,0x55,0x99,0x55,0x9F,0x51,0x99,0x55,0x99,0x55,0x99,0x55,
0x7F,0xC0,0xFF,0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,0xFF,0xFF,0x7F,
0x1C,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xC1,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,
0x00,0x00,0x10,0x20,0x00,0x00,0x06,0x01,0x00,0x00,0x00,0x00,0x00,0x31,0x00,0x00,
0x03,0x04,0x0A,0x11,0x88,0xCB,0xFC,0xFC,0xFF,0xFB,0xDF,0x9F,0x17,0x09,0x0F,0x07,

0xF8,0x08,0x70,0x40,0xC0,0x40,0x40,0xC0,0x7E,0x42,0xFE,0x40,0x40,0xC0,0x40,0xC0,
0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x80,0x80,0x98,0x98,0x80,0x80,0x80,0x98,0x98,0x80,0x80,0x80,0x80,0x00,
0x00,0x00,0x00,0x00,0x00,0x3E,0x22,0xE2,0x2A,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3E,0x22,0xE2,0x2A,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,
0xF8,0x08,0x70,0x40,0xC0,0x40,0x40,0xC0,0x7E,0x42,0xFE,0x40,0x40,0xC0,0x40,0xC0,
0x00,0x80,0x40,0x40,0x7C,0x44,0x57,0x45,0x55,0x57,0x54,0xC4,0x54,0x44,0x28,0x10,
0x08,0x0C,0xC6,0xE6,0x76,0x3E,0x3E,0x1C,0xFC,0x5E,0xFE,0x3F,0x37,0x63,0xC3,0x02,

0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x7E,0x40,0x7E,0x02,0x02,0x02,0x02,0x03,
0x00,0x1C,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x1C,0x00,
0x00,0x1F,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1F,0x00,
0x00,0x00,0x00,0x00,0xC0,0xA0,0x10,0xFF,0x82,0x84,0x08,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x82,0x04,0x08,0x00,0x00,0x00,0x00,0x00,
0x03,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x7E,0x40,0x7E,0x02,0x02,0x02,0x02,0x03,
0x01,0x02,0x04,0x25,0xC4,0x05,0xFC,0x0D,0xAD,0xFD,0x04,0x87,0x40,0x00,0x00,0x00,
0x00,0x00,0x01,0x00,0x80,0xC0,0xE0,0xD8,0xAF,0xD5,0xBF,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x07,0xCE,0x7D,0xAA,0x55,0xAA,0x55,0xA2,0x55,0x22,0x55,0x2A,0x55,0xAA,
0x55,0xAA,0x51,0xAA,0x55,0xAA,0x15,0xAA,0x15,0xAA,0x15,0x82,0x55,0xA2,0x55,0xAA,
0x54,0xAA,0x14,0xAA,0x15,0xAA,0x51,0xAA,0x55,0xAA,0xF5,0x3A,0x1F,0x03,0x00,0x00,
0xFC,0x10,0x10,0x10,0xFC,0x10,0x10,0x10,0xFC,0x10,0x10,0x10,0xFC,0x10,0x10,0x10,
0xFC,0x10,0x08,0x08,0xFE,0x04,0x82,0xFE,0x80,0xFE,0x82,0x04,0xFE,0x08,0x08,0x10,
0x00,0x00,0x60,0x44,0x88,0x0E,0x7C,0xF2,0xC0,0xE3,0x3C,0x02,0x00,0x98,0xE0,0x10,
0x00,0x00,0x00,0xE0,0x18,0xE4,0x54,0x7A,0x12,0x7A,0x54,0xE4,0x18,0xE0,0x00,0x00,
0x00,0x00,0x00,0x70,0x50,0x50,0xDE,0x02,0xDE,0x50,0x50,0x70,0x00,0x00,0x00,0x00,

0x00,0x00,0x7F,0xAB,0x55,0xA8,0x55,0xA8,0x55,0xA2,0x55,0xA2,0x55,0xA2,0x55,0x2A,
0x55,0x28,0x55,0xA8,0x45,0xAA,0x45,0xAA,0x51,0xAA,0x51,0xAA,0x11,0xAA,0x15,0xAA,
0x55,0xA8,0x55,0x88,0x55,0x8A,0x55,0xAA,0x15,0xAA,0x17,0xAE,0x78,0xE0,0x00,0x00,
0xFF,0x40,0x40,0x40,0xFF,0x40,0x40,0x40,0xFF,0x40,0x40,0x40,0xFF,0x40,0x40,0x40,
0xFF,0x40,0x40,0x40,0xFF,0x40,0x47,0xFF,0x07,0xFF,0x47,0x40,0xFF,0x40,0x40,0x40,
0x04,0x05,0x02,0x02,0x01,0x83,0xC6,0xFF,0xFF,0xFF,0x82,0x02,0x05,0x04,0x02,0x00,
0x00,0x40,0x80,0xFF,0x00,0xAB,0xD5,0xBF,0x50,0xBF,0xD5,0xEB,0x00,0xFF,0xC0,0x20,
0x40,0x80,0x00,0xF8,0x04,0x54,0xA7,0x50,0xA7,0x54,0xA4,0xF8,0x00,0xC0,0x20,0x00,

0x00,0x00,0xE0,0xBF,0x55,0xAA,0x51,0xAA,0x51,0xAA,0x15,0xAA,0x15,0xAA,0x55,0xA8,
0x55,0xA8,0x45,0xAA,0x45,0xAA,0x55,0x2A,0x55,0x22,0x55,0xA2,0x55,0xAA,0x55,0xAA,
0x45,0xAA,0x45,0xAA,0x55,0xAA,0x51,0xAA,0x51,0xAA,0xF5,0x1A,0x0D,0x07,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x00,0x00,0x40,0x50,0xF4,0xFE,0xE8,0xC8,0x00,0x00,0x00,0x00,0x00,
0x3F,0x50,0xCD,0x8A,0x55,0x7F,0x25,0x25,0xFF,0xC1,0x6A,0xB6,0x9F,0xA1,0xEA,0xF5,
0x3F,0x50,0xCD,0x8A,0x55,0x7F,0x25,0x25,0x7F,0x41,0x6A,0x36,0x1F,0x01,0x01,0x00,
0x03,0x04,0x0D,0x0A,0x15,0x0B,0x05,0x0F,0x7F,0xC1,0x6A,0xB6,0x9F,0xA1,0xEA,0xF5,

0x00,0x00,0x03,0x06,0x05,0x1E,0x34,0x2A,0x34,0x6A,0x55,0x6A,0x55,0x6A,0x75,0x2A,
0x35,0x1A,0x0D,0x0E,0x05,0x06,0x0D,0x0A,0x15,0x1A,0x15,0x1A,0x15,0x38,0x35,0x3A,
0x15,0x1A,0x0D,0x0A,0x0D,0x0A,0x0F,0x02,0x03,0x03,0x01,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x00,0x28,0x6E,0x2D,0x3D,0xFF,0xFF,0xFF,0x3F,0x3F,0x7D,0x6C,0x28,0x00,
0x80,0x55,0x2A,0x3F,0x41,0x82,0x56,0xAA,0xD7,0x7F,0x20,0x40,0xAA,0x55,0xAA,0x7F,
0x80,0x55,0x2A,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x20,0x40,0x6A,0x55,0xAA,0x7F
};

const static unsigned char PROGMEM font[] = {
    0x04,0x04,0x04,0x00,0x04,   // <space> !
    0xAA,0xAE,0x0A,0x0E,0x0A,   // " #
    0x6A,0xC2,0xE4,0x68,0xCA,   // 0x %
    0x44,0xE4,0xC0,0xA0,0xE0,   // & '
    0x24,0x42,0x42,0x42,0x24,   // ( )
    0x00,0xA4,0x4E,0xA4,0x00,   // * +
    0x00,0x00,0x0E,0x40,0x80,   // , -
    0x02,0x02,0x04,0x08,0x88,   // . /
    0x4C,0xA4,0xA4,0xA4,0x4E,   // 0 1
    0xCE,0x22,0x44,0x82,0xEE,   // 2 3
    0xAE,0xA8,0xEC,0x22,0x2C,   // 4 5
    0x6E,0x82,0xE4,0xA4,0xE4,   // 6 7
    0xEE,0xAA,0x4E,0xA2,0xEC,   // 8 9
    0x00,0x44,0x00,0x44,0x08,   // : //
    0x20,0x4E,0x80,0x4E,0x20,   // < =
    0x8C,0x42,0x24,0x40,0x84,   // > ?
    0x44,0xAA,0xEE,0x8A,0x6A,   // @ A
    0xEE,0xA8,0xC8,0xA8,0xEE,   // B C
    0xCE,0xA8,0xAC,0xA8,0xCE,   // D E
    0xE6,0x88,0xCA,0x8A,0x8E,   // F G
    0xAE,0xA4,0xE4,0xA4,0xAE,   // H I
    0x2A,0x2A,0x2C,0xAA,0xEA,   // J K
    0x8A,0x8E,0x8E,0x8A,0xEA,   // L M
    0xCE,0xAA,0xAA,0xAA,0xAE,   // N O
    0xEE,0xAA,0xEA,0x8E,0x8E,   // P Q
    0xCE,0xA8,0xCE,0xA2,0xAE,   // R S
    0xEA,0x4A,0x4A,0x4A,0x4E,   // T U
    0xAA,0xAA,0xAE,0xAE,0x4A,   // V W
    0xAA,0xAA,0x4E,0xA4,0xA4,   // X Y
    0xE6,0x24,0x44,0x84,0xE6,   // Z [
    0x86,0x82,0x42,0x22,0x26,   // \ ]
    0x40,0xA0,0x00,0x00,0x0E,   // ^ _
    0x80,0x40,0x0E,0x0A,0x06,   // ` a
    0x00,0x80,0xC6,0xA8,0xC6,   // b c
    0x00,0x24,0x6A,0xAC,0x66,   // d e
    0x00,0x24,0x4A,0x66,0x4C,   // f g
    0x00,0x84,0xC0,0xA4,0xA4,   // h i
    0x40,0x08,0x4A,0x4C,0x8A,   // j k
    0x00,0x40,0x4E,0x4E,0x2A,   // l m
    0x00,0x00,0xCE,0xAA,0xAE,   // n o
    0x00,0x44,0xAA,0xC6,0x82,   // p q
    0x00,0x04,0x28,0x44,0x48,   // r s
    0x00,0x40,0x6A,0x4A,0x26,   // t u
    0x00,0x00,0xAA,0xAE,0x4E,   // v w
    0x00,0x00,0xAA,0x46,0xAC,   // x y
    0x06,0x84,0x48,0x84,0x46,   // z {
    0x0C,0x44,0x42,0x44,0x4C,   // | }
    0x0E,0x2E,0xEE,0x8E,0x0E    // ~ <block>
};

void setup()
{
  SPI.begin();
  display.start();
  
  buttons = display.getInput();  //begin with a quick check of the A button
  if(buttons & A_BUTTON) {musicMode = 0;}  //if the user wants to start the program muted
  display.tune_playscore(score);
  lTime = millis();
}

float off;

void drawBigChar(char c, int x, int y, int tile) {
    int xo = cos(c*0.1+lTime*0.001+x*0.25)*4;
    int yo = sin(c*0.1+lTime*0.001+y*0.25)*4;
    
    unsigned long currentBit;
    if (c % 2)  currentBit = (c-33) * (5 * 4) + 4;
    else        currentBit = (c-32) * (5 * 4);

    for (uint8_t b = 0; b < 5; b++) {
        for (uint8_t a = 0; a < 4; a++) {
          if ( pgm_read_byte(font+(currentBit/8)) & ( 1 << (7-currentBit%8) ) ) {

            if (x+a*8 >= -8 && x+a*8 <= 127)
              display.drawBitmap(x+a*8+xo, y+b*8+yo, tileset1+tile,8,8,0);
          }
          currentBit++;
        }
      currentBit+=4;
    }
}

void drawBigString(char* s, int x, int y, int tile) {
  int len = strlen(s);
  for(int i = 0; i < len; i++) {
    drawBigChar(s[i],x+i*4*8,y,tile);
  }
}

float wipeStart;

void wipe(int m) {
  int lim = 0;
  if (m == 0) lim = (int)((lTime-wipeStart)*0.05);
  else lim = 128-(int)((lTime-wipeStart)*0.05);
  
  for (int y = 0; y < lim; y++) {
    if (y > 64) break;
    display.drawLine(0,y,128,y,0);
  }
}


void intro() {
  display.setTextSize(2);
  int offs = cos(lTime*0.01)*8;
  if (lTime > 6000.0) { display.setCursor(16+offs, 2+2); display.print(F("- #tukka -")); }
  if (lTime > 1000.0) { display.setCursor(2, 13+2); display.print(F("the story of")); }
  if (lTime > 3000.0) { display.setCursor(2, 13+11+2); display.print(F(" our journey")); }
  if (lTime > 4000.0) { display.setCursor(2, 13+22+2); display.print(F("in the scene")); }
  if (lTime > 8000.0) { display.setCursor(6, 13+33+2); display.print(F(" since 1985")); }

  if (lTime < 3000.) {
    wipeStart = -500.;
    wipe(1);
  }


  if (lTime > 10000.) {
    wipeStart = 10000.;
    wipe(0);
  }
}

void drawFloor() {
    off += 0.8;
    uint8_t offU2 = (uint8_t)off;

    //floor
    for (int i = 0; i < 18; i++) {
      if (i*16-((offU2*2) % 128) > 128) break;  
    display.drawBitmap(i*16-((offU2*2) % 128), 64-8, tileset1+32,16,8,0);
    }
}

void bigscroller() {
    for (int y = 0; y < 8; y++) {
      for (int x = 0; x < 8; x++) {
        display.drawBitmap(x*16, y*8, tileset1+512+(int)((lTime-34500.)*0.01),16,8,0);
      }
    }
    drawBigString("    GREETS TO EVERYBODY!    ",(int)(0.0-(lTime-38500.)*0.05),8,(lTime-34500.)*0.01);    

  if (lTime < 33500.) {
    wipeStart = 28500.;
    wipe(1);
  }

  if (lTime > 52000.) {
    wipeStart = 52000.;
    wipe(0);
  }

}

void drawPlane(int x, int y) {
  display.drawBitmap(x, y, tileset1+256,16,8,0);      
  display.drawBitmap(x, y+8, tileset1+256+128,16,8,0);      
}

void drawGuy(int x, int y) {
  int oo = ((int)off*0.2);
  int f = 0;
  if (oo % 2 == 1) f = 16; 
  display.drawBitmap(x, y, tileset1+256+48+f,16,8,0);      
  display.drawBitmap(x, y+8, tileset1+256+128+48+f,16,8,0);      
}

int py = 15;
float off2 = 0.0;
void snow() {
      drawFloor();
      uint8_t offU = (uint8_t)off % 8;
      for (int a = 0; a < 17; a++)
      {
          for (int b = -1; b < 7; b++)
          {
            display.drawPixel((a * 8-offU+cos(off*0.1+a*0.1)*4*(b+10)*0.1) + 2 + display.gray, (b * 8+a%8) + 2 + offU+sin(off*0.02+a*0.1)*2, 0);
          }
      }
  if (off > 144.) {
    off = 0.;
    py = rand() % 26;
  }

  off2=(lTime-12000.)*0.007;
  
  drawPlane(-16+((int)(off)) % 144,py+cos(lTime*0.001+py)*4);

  drawGuy(-16+((int)(off2)) % 144,40);

  if (lTime < 15000.) {
    wipeStart = 12000.;
    wipe(1);
  }

  if (lTime > 25500.) {
    wipeStart = 25500.;
    wipe(0);
  }

  if (lTime > 16000.) {
    display.setTextSize(1);
    if (lTime > 16000. + 2000.) {display.setCursor(8, 16-6); display.print(F("Make your own way"));}
    if (lTime > 16000. + 4000.) {display.setCursor(8, 16); display.print(F("enjoy the trip"));}
    if (lTime > 16000. + 6000.) {display.setCursor(8, 16+6); display.print(F("and don't listen"));}
    if (lTime > 16000. + 8000.) {display.setCursor(8, 16+12); display.print(F("or give in to hate."));}
  }

}


void blockeffu() {
    for (int y = 0; y < 10; y++) {
      for (int x = 0; x < 18; x++) {
        int c = x*y;
        display.drawBitmap((x-2)*8, (y-2)*8, tileset1+(int)(lTime*0.01)+c*8,8,8,0);      
    }
  }

  for (int y = 0; y < 64; y+=1) {
    int w = sin(y*0.02+lTime*0.001+sin(lTime*0.002))*128*cos(lTime*0.0005);
    display.drawFastHLine(64-abs(w/2),y,abs(w),w < 0 ? 0 : 1);
  }

  if (lTime < 58000.) {
    wipeStart = 55000.;
    wipe(1);
  }

  if (lTime > 63000.) {
    wipeStart = 63000.;
    wipe(0);
  }

}

void blockeffu2() {
  off=lTime*0.02;

  if (lTime < 76000.) {
    for (int y = 0; y < 9; y++) {
      for (int x = -1; x < 16; x++) {
          int c = 32;
          display.drawBitmap(x*8+((int)off)%8, y*8-((int)off)%8, tileset1+c,8,8,0);      
      }
    }
  }

  if (lTime < 75000.) {
    for (int y = 1; y < 64; y+=2) {
      int w = cos(y*0.02+lTime*0.001+sin(lTime*0.002))*128*cos(lTime*0.0005);
      display.drawFastHLine(64-abs(w/2),y,abs(w),w < 0 ? 0 : 1);
    }
    for (int y = 0; y < 64; y+=4) {
      int w = sin(y*0.02+lTime*0.001+cos(lTime*0.002))*128*cos(lTime*0.0005);
      display.drawFastHLine(64-abs(w/2),y,abs(w),w < 0 ? 1 : 0);
    }
  
  }

  if (lTime > 73000. && lTime < 78000.) {
    display.setTextSize(4);
    display.setCursor(8, 32-10+(int)((cos(lTime*0.003))*8)); display.print(F("TheEnd"));
  }

  if (lTime > 79000.) {
    display.setTextSize(1);
    display.setCursor(2, 40-12); display.print(F("released at B30 party"));
    display.setCursor(2, 40); display.print(F("code: visy"));
    display.setCursor(2, 46); display.print(F("music & gfx: paaris"));
  }

  if (lTime < 68000.) {
    wipeStart = 65000.;
    wipe(1);
  }

  if (lTime > 84000.) {
    wipeStart = 84000.;
    wipe(0);
  }

}

int part = 0;

void loop() {
  if (millis() > lTime + FPS)
  {
    lTime = millis();
    
    buttons = display.getInput();

//    display.cycleGray();
    display.clearDisplayWhite();

    if (lTime > 12000. && lTime < 28500.) part = 1;
    if (lTime > 28500. && lTime < 55000.) part = 2;
    if (lTime > 55000. && lTime < 65000.) part = 3;
    if (lTime > 65000. && lTime < 100000.) part = 4;

    if (part == 0) intro();
    else if (part == 1) snow();
    else if (part == 2) bigscroller();
    else if (part == 3) blockeffu();
    else if (part == 4) blockeffu2();

    if (lTime > 86000.) {
      display.tune_stopscore();  
    }
    
    display.display();
  }
}
