#version 120

uniform float time = 1.0;
uniform vec2 resolution = vec2(1280,720)*0.45;

vec2 pixelate(vec2 coord)
{
	vec2 d = vec2(1.0,1.0)/resolution;
	coord.s = floor(coord.s/d.s)*d.s;
	coord.t = floor(coord.t/d.t)*d.t;
	return coord;	
}

float rand(vec2 coord)
{
	return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

void main()
{
	vec2 coord=pixelate(gl_TexCoord[0].st);
	gl_FragColor = vec4(vec3(rand(coord)),1) * gl_Color;
}
