var SCREENSHOT_DURATION = 1;
var SCREENSHOT_NOISE_DURATION = 0.2;
var SCREENSHOT_COUNT = 5;
var hirmuStart = 3+SCREENSHOT_DURATION*6;

var timings = {
	"rotozoomer": {
		"start":8, "duration":16
	}
	,"hirmu": {
		"start":hirmuStart, "duration":24-hirmuStart
	}
	,"plasma": {
		"start":24, "duration":24
	}
	,"scroller": {
		"start":24, "duration":24
	}
	,"twister": {
		"start":48, "duration":24
	}
	,"tunnel": {
		"start":72, "duration":43
	}
};

Demo.prototype.init = function()
{
	this.preInitRotozoomer(timings.rotozoomer.start, timings.rotozoomer.duration);
	this.preInitHirmu(timings.hirmu.start, timings.hirmu.duration);

	this.preInitPlasma(timings.plasma.start, timings.plasma.duration);
	this.preInitScroller(timings.scroller.start, timings.scroller.duration);

	this.preInitTwister(timings.twister.start, timings.twister.duration);

	this.preInitTunnel(timings.tunnel.start, timings.tunnel.duration);

	this.preInitTelevision(0,120);
}

Demo.prototype.preInitHirmu = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/hirmu.png"
		,"layer": 110
		,"position": [
			 {"x":-250,"y":215}
			,{"duration":1,"x":210}
			,{"duration":12}
			,{"duration":1,"x":-250}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime+1.5, "duration": 11
		,"image": "data/speech_bubble.png"
		,"layer": 110
		,"position": [{"x":750,"y":350}]
		,"scale": [{"uniform2d":1.25}]
		,"color": [
			 {"duration":0.5,"a":225}
			,{"duration":9.0}
			,{"duration":0.5,"a":0}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime+1.5, "duration": 3
		,"image": "data/speech_yes.png"
		,"layer": 110
		,"position": [{"x":760,"y":350}]
		,"scale": [{"uniform2d":1.10}]
		,"color": [
			 {"a":0}
			,{"duration":0.5,"a":255}
			,{"duration":2}
			,{"duration":0.5,"a":0}
		]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime+1.5+2.5, "duration": 5
		,"image": "data/speech_second_favorite_group.png"
		,"layer": 110
		,"position": [{"x":760,"y":310}]
		,"scale": [{"uniform2d":1.10}]
		,"color": [
			 {"a":0}
			,{"duration":0.5,"a":255}
			,{"duration":4}
			,{"duration":0.5,"a":0}
		]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime+1.5+7.0, "duration": 3
		,"image": "data/speech_something_watchable.png"
		,"layer": 110
		,"position": [{"x":840,"y":360}]
		,"scale": [{"uniform2d":1.0}]
		,"color": [
			 {"a":0}
			,{"duration":0.5,"a":255}
			,{"duration":2}
			,{"duration":0.5,"a":0}
		]
	}]);
}

Demo.prototype.preInitTelevision = function(startTime, durationTime)
{
	var byteStart = 115;
	this.loader.addAnimation([
	{
		 "start": byteStart, "duration": 2
		,"image": "data/byterapers.png"
		,"layer": 10
		,"position": [{"x":525}]
		,"align":3
		,"scale": [{"uniform2d":1.8}]
		,"color": [{"a":0},{"duration":0.5,"a":255},{"duration":1},{"duration":0.5,"a":0}]
	}]);

	var screenshotStartTime = startTime+3;
	this.loader.addAnimation([
	{
		 "start": screenshotStartTime, "duration": SCREENSHOT_DURATION
		,"image": "data/screenshot_variform.png"
		,"layer": 10
		,"position": [{"x":525}]
		,"align":3
		,"scale": [{"uniform2d":2.55}]
	}]);
	this.loader.addAnimation([
	{
		 "start": screenshotStartTime+SCREENSHOT_DURATION, "duration": SCREENSHOT_DURATION
		,"image": "data/screenshot_the_popular_demo.png"
		,"layer": 10
		,"position": [{"x":525}]
		,"align":3
		,"scale": [{"uniform2d":2.2}]
	}]);
	this.loader.addAnimation([
	{
		 "start": screenshotStartTime+SCREENSHOT_DURATION*2, "duration": SCREENSHOT_DURATION
		,"image": "data/screenshot_lifeforce.png"
		,"layer": 10
		,"position": [{"x":525}]
		,"align":3
		,"scale": [{"uniform2d":2.3}]
	}]);
	this.loader.addAnimation([
	{
		 "start": screenshotStartTime+SCREENSHOT_DURATION*3, "duration": SCREENSHOT_DURATION
		,"image": "data/screenshot_starstruck.png"
		,"layer": 10
		,"position": [{"x":525}]
		,"align":3
		,"scale": [{"uniform2d":2.2}]
	}]);
	this.loader.addAnimation([
	{
		 "start": screenshotStartTime+SCREENSHOT_DURATION*4, "duration": SCREENSHOT_DURATION
		,"image": "data/screenshot_higher_state_of_resolution.png"
		,"layer": 10
		,"position": [{"x":525}]
		,"align":3
		,"scale": [{"uniform2d":2.7}]
	}]);

	this.loader.addAnimation([
	{
		 "start": screenshotStartTime+SCREENSHOT_DURATION*5, "end": byteStart
		,"image": "data/jml_logo_mtv.png"
		,"color":[{"a":240}]
		,"position": [{"x":860,"y":570}]
		,"scale": [{"uniform2d":0.2}]
		,"layer": 98
	}]);

	var MIN_SCREENSHOT_NOISE = 50;
	var LOW_NOISE = 30;
	var SWITCH_DURATION = 0.2;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": 99
		,"shader":{"name":"data/shader/noise.fs",
			"variable":[
				{"name":"time","value":["{return Math.floor(getSceneTimeFromStart()*30);}"]}
			]
		}
		,"color": [
			 {"a":0}
			,{"duration":screenshotStartTime-startTime-SCREENSHOT_NOISE_DURATION/2}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":255}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":MIN_SCREENSHOT_NOISE}
			,{"duration":SCREENSHOT_DURATION-SCREENSHOT_NOISE_DURATION}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":255}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":MIN_SCREENSHOT_NOISE}
			,{"duration":SCREENSHOT_DURATION-SCREENSHOT_NOISE_DURATION}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":255}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":MIN_SCREENSHOT_NOISE}
			,{"duration":SCREENSHOT_DURATION-SCREENSHOT_NOISE_DURATION}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":255}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":MIN_SCREENSHOT_NOISE}
			,{"duration":SCREENSHOT_DURATION-SCREENSHOT_NOISE_DURATION}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":255}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":MIN_SCREENSHOT_NOISE}
			,{"duration":SCREENSHOT_DURATION-SCREENSHOT_NOISE_DURATION}
			,{"duration":SCREENSHOT_NOISE_DURATION/2,"a":255}
			,{"duration":SCREENSHOT_NOISE_DURATION,"a":LOW_NOISE}

			,{"start":timings.plasma.start-SWITCH_DURATION, "duration": SWITCH_DURATION, "a":255}
			,{"duration": SWITCH_DURATION, "a":LOW_NOISE}
			,{"start":timings.twister.start-SWITCH_DURATION, "duration": SWITCH_DURATION, "a":255}
			,{"duration": SWITCH_DURATION, "a":LOW_NOISE}
			,{"start":timings.tunnel.start-SWITCH_DURATION, "duration": SWITCH_DURATION, "a":255}
			,{"duration": SWITCH_DURATION, "a":LOW_NOISE}

			,{"start":byteStart-SWITCH_DURATION, "duration": SWITCH_DURATION, "a":255}
			,{"duration": SWITCH_DURATION, "a":180}
		]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/old_tv.png"
		,"layer": 100
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/old_tv_screen.png"
		,"position": [{"x":520,"y":357}]
		,"color": [{"a":120}]
		,"layer": 100
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/old_tv_volume.png"
		,"position": [{"x":1142,"y":531}]
		,"angle":[
			{"degreesZ":-100}
			,{"duration":3,"degreesZ":222}
		]
		,"layer": 100
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/old_tv_channels.png"
		,"position": [{"x":1140,"y":349}]
		,"angle":[
			 {"degreesZ":-10}
			,{"duration":3,"degreesZ":60}
			,{"start":screenshotStartTime,"duration":SCREENSHOT_DURATION*SCREENSHOT_COUNT+0.2,"degreesZ":180}

			,{"start":timings.plasma.start-SWITCH_DURATION, "duration": SWITCH_DURATION, "degreesZ":190}
			,{"start":timings.twister.start-SWITCH_DURATION, "duration": SWITCH_DURATION, "degreesZ":200}
			,{"start":timings.tunnel.start-SWITCH_DURATION, "duration": SWITCH_DURATION, "degreesZ":210}
			,{"start":byteStart-SWITCH_DURATION, "duration": SWITCH_DURATION, "degreesZ":310}
		]
		,"layer": 100
	}]);
}

Demo.prototype.preInitScroller = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 1
		,"textScale": 2
		,"scrollerStart": 1
		,"fbo":{"name":"scrollerTextFbo","action":"begin","width":getScreenWidth(),"height":getScreenHeight()}
		,"initFunction":"{initScrollerText(animation);}"
		,"runFunction":"{drawScrollerText(animation);}"
	},
	{
		 "start": startTime, "duration": durationTime
		,"layer": 5
		,"fbo":{"name":"scrollerTextFbo","action":"unbind"}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "scrollerTextFbo.color.fbo"
		,"layer": 11
		,"color": [{"r":255,"g":255,"b":255}]
		,"shader":{"name":"data/shader/scroller.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);

}

var scrollerImages = [];

var scrollerText = null;
function initScrollerText(animation)
{
	if (scrollerImages.length > 0)
	{
		return;
	}

	scrollerImages = [
		imageLoadImage("scroller_text_01.png"),
		imageLoadImage("scroller_text_02.png"),
		imageLoadImage("scroller_text_03.png"),
		imageLoadImage("scroller_text_04.png"),
		imageLoadImage("scroller_text_05.png"),
		imageLoadImage("scroller_text_06.png"),
		imageLoadImage("scroller_text_07.png"),
		imageLoadImage("scroller_text_08.png")
	];
}

var oldxspeed = 0;
var scrollpos = 0;
function drawScrollerText(animation)
{
	glColor4ub(0xE7, 0x72, 0xB6, 0xFF);

	perspective2dBegin(getScreenWidth(),getScreenHeight());
	var startPosition = getScreenWidth();
	var wholeWidth = 0;
	for (var i = 0; i < scrollerImages.length; i++)
	{
		wholeWidth += scrollerImages[i].w;
	}

	var SPEED_FACTOR =2.2;
	var rotate = (((getSceneTimeFromStart()-animation.start-animation.scrollerStart)/(animation.duration))*SPEED_FACTOR);
	if (rotate < 0)
	{
		rotate = 0.0;
	}

	var x=-wholeWidth*rotate+startPosition;
	var y=getScreenHeight()/2-(scrollerImages[0].h*animation.textScale)/2;
	for (var i = 0; i < scrollerImages.length; i++)
	{
		var scrollerImage = scrollerImages[i];
		var w=scrollerImage.w*animation.textScale;
		var h=scrollerImage.h*animation.textScale;
		var uMax = 1.0;
		var vMax = 1.0;
		var uMin = 0.0;
		var vMin = 0.0;

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,scrollerImage.id);

		glBegin(GL_QUADS);
		glTexCoord2f(uMax,vMax);
		glVertex3d(x+w,y+h,0);
		glTexCoord2f(uMin,vMax);
		glVertex3d(x,y+h,0);
		glTexCoord2f(uMin,vMin);
		glVertex3d(x,y,0);
		glTexCoord2f(uMax,vMin);
		glVertex3d(x+w,y,0);
		glEnd();

		x+=w;

		glDisable(GL_TEXTURE_2D);
	}

	perspective2dEnd();

	glColor4f(1,1,1,1);
}

Demo.prototype.preInitRotozoomer = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/jml_logo_sweet16.png"
		,"scale":[{"uniform2d":3}]
		,"layer": 10
		,"shader":{"name":"data/shader/rotozoom.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"angle","value":["{return Math.PI*2*((Math.sin(getSceneTimeFromStart())+1)/2);}"]}
				,{"name":"zoom","value":["{return (Math.cos(getSceneTimeFromStart()*4)+1)/2*5+0.1;}"]}
				,{"name":"fade","value":["{return 0.0;}"]}
			]
		}
	}]);
}

Demo.prototype.preInitTunnel = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/jml_logo_sweet16.png"
		,"scale":[{"uniform2d":3}]
		,"layer": 10
		,"shader":{"name":"data/shader/tunnel.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);

	var MAX_GREETS = 13;
	var GREET_DURATION = (durationTime-3)/MAX_GREETS;
	var GREET_FADE = GREET_DURATION/6.0;
	for (var i = 1; i <= MAX_GREETS; i++)
	{
		var greetStart = startTime+i*GREET_DURATION;
		var greetDuration = GREET_DURATION;
		this.loader.addAnimation([
		{
			 "start": greetStart, "duration": greetDuration
			,"image": "data/greet_"+i+".png"
			,"scale": [{"uniform2d":1.3}]
			,"position": [{"x":random()*420+325,"y":random()*450+120}]
			,"color": [
				 {"a":0, "r":0xE7, "g":0x72, "b":0xB6}
				,{"duration":GREET_FADE,"a":200}
				,{"duration":GREET_DURATION-GREET_FADE*2}
				,{"duration":GREET_FADE, "a":0}
			]
			,"layer": 11
			,"shader":{"name":"data/shader/wavy.fs",
				"variable":[
					 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				]
			}
		}]);
	}

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/huonologo.png"
		,"position": [{"x":"{return 520+Math.sin(getSceneTimeFromStart()*2)*100}","y":357}]
		,"color": [{"a":155}]
		,"layer": 11
	}]);
}

function getPlasmaScale(animation)
{
	return 30;
}

Demo.prototype.preInitPlasma = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": 10
		,"shader":{"name":"data/shader/plasma.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"scale","value":["{return getPlasmaScale(animation);}","{return getPlasmaScale(animation);}"]}
			]
		}
	}]);
}

function getTwisterTwists(animation)
{
	var percent = Math.min(Math.max((((getSceneTimeFromStart()-animation.start-animation.twist1Start)/(animation.twist1Duration))), 0.0), 1.0);
	var twists = 30*percent;
	if (percent >= 1.0) {
		percent = Math.min(Math.max((((getSceneTimeFromStart()-animation.start-animation.twist2Start)/(animation.twist2Duration))), 0.0), 1.0);
		twists += -90*percent;
	}
	return twists;
}

function getTwisterRotateY(animation)
{
	return ((Math.sin(getSceneTimeFromStart())+1)/2.0)*360*2;
}

function getTwisterDisplacementMagnitude(animation)
{
	var time = getSceneTimeFromStart()-animation.start-animation.displacementStart;
	if (time < 0)
	{
		return 0;
	}

	return 10+(Math.sin(time)-1)*6;
}

function getTwisterDisplacementMultiplier(animation)
{
	var time = getSceneTimeFromStart()-animation.start-animation.displacementStart;
	if (time < 0)
	{
		return 0;
	}

	return 0.1*((Math.sin(time)+1)/2.0);
}

Demo.prototype.preInitTwister = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/blank.png"
		,"layer": 10
		,"twist1Start": 2,"twist1Duration": 5
		,"twist2Start": 7,"twist2Duration": 5
		,"displacementStart": 12.5
		,"shader":{"name":"data/shader/raymarching.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
				,{"name":"twisterTwists","value":["{return getTwisterTwists(animation);}"]}
				,{"name":"twisterRotateY","value":["{return getTwisterRotateY(animation);}"]}
				,{"name":"displacementMagnitude","value":["{return getTwisterDisplacementMagnitude(animation);}"]}
				,{"name":"displacementMultiplier","value":["{return getTwisterDisplacementMultiplier(animation);}"]}
			]
		}
		,"color":[{"a":255}]
	}]);
}
