/*
 * Decompiled with CFR 0.152.
 */
package sound;

import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.vecmath.Vector3f;
import sound.SoundFile;

public class Sound {
    public static final SoundFile POWER_UP = new SoundFile("scan.wav", 1.0);
    public static final SoundFile POWER_DOWN = new SoundFile("power_down.wav", 1.0);
    public static final SoundFile AMBIENT = new SoundFile("ambient.wav", 1.0);
    public static final SoundFile CLICK = new SoundFile("click.wav", 1.0);
    public static final SoundFile[] GEIGERS = new SoundFile[]{new SoundFile("geiger1.wav", 1.0), new SoundFile("geiger2.wav", 1.0), new SoundFile("geiger3.wav", 1.0), new SoundFile("geiger4.wav", 1.0), new SoundFile("geiger5.wav", 1.0), new SoundFile("geiger6.wav", 1.0)};
    private SoundFile currentMusic;
    private double soundVolume;
    private double musicVolume;
    private Clip musicClip;

    public Sound(double volume) {
        this.soundVolume = volume;
        this.musicVolume = volume;
    }

    public Clip play(SoundFile sound) {
        return this.play(sound, this.soundVolume);
    }

    public void play3D(SoundFile sound, Vector3f ear, Vector3f soundPos) {
        double maxDistance = 100.0;
        double dx = ear.x - soundPos.x;
        double dy = ear.y - soundPos.y;
        double dz = ear.z - soundPos.z;
        double dis = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dis < maxDistance) {
            this.play(sound, this.soundVolume * (1.0 - dis / maxDistance));
        }
    }

    public Clip play(SoundFile sound, double volume) {
        try {
            Clip clip = (Clip)AudioSystem.getLine(sound.info);
            clip.open(sound.af, sound.audio, 0, sound.size);
            FloatControl volumeControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            volumeControl.setValue((float)(20.0 * Math.log10(volume * sound.volume * this.soundVolume)));
            clip.start();
            return clip;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setMusic(SoundFile music) {
        if (this.currentMusic == music) {
            return;
        }
        if (this.musicClip != null) {
            this.musicClip.stop();
        }
        this.currentMusic = music;
        try {
            this.musicClip = (Clip)AudioSystem.getLine(music.info);
            this.musicClip.open(music.af, music.audio, 0, music.size);
            this.musicClip.loop(-1);
            FloatControl volume = (FloatControl)this.musicClip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue((float)(20.0 * Math.log10(this.musicVolume * music.volume)));
            this.musicClip.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopMusic() {
        this.currentMusic = null;
        this.musicClip.stop();
    }
}

