/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class LOGBRUSH
implements Pointer {
    public static final int SIZEOF;
    public static final int LBSTYLE;
    public static final int LBCOLOR;
    public static final int LBHATCH;
    private final ByteBuffer struct;

    public LOGBRUSH() {
        this(LOGBRUSH.malloc());
    }

    public LOGBRUSH(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setLbStyle(int lbStyle) {
        LOGBRUSH.lbStyle(this.struct, lbStyle);
    }

    public void setLbColor(int lbColor) {
        LOGBRUSH.lbColor(this.struct, lbColor);
    }

    public void setLbHatch(long lbHatch) {
        LOGBRUSH.lbHatch(this.struct, lbHatch);
    }

    public int getLbStyle() {
        return LOGBRUSH.lbStyle(this.struct);
    }

    public int getLbColor() {
        return LOGBRUSH.lbColor(this.struct);
    }

    public long getLbHatch() {
        return LOGBRUSH.lbHatch(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int lbStyle, int lbColor, long lbHatch) {
        ByteBuffer logbrush = LOGBRUSH.malloc();
        LOGBRUSH.lbStyle(logbrush, lbStyle);
        LOGBRUSH.lbColor(logbrush, lbColor);
        LOGBRUSH.lbHatch(logbrush, lbHatch);
        return logbrush;
    }

    public static void lbStyle(ByteBuffer logbrush, int lbStyle) {
        logbrush.putInt(logbrush.position() + LBSTYLE, lbStyle);
    }

    public static void lbColor(ByteBuffer logbrush, int lbColor) {
        logbrush.putInt(logbrush.position() + LBCOLOR, lbColor);
    }

    public static void lbHatch(ByteBuffer logbrush, long lbHatch) {
        PointerBuffer.put(logbrush, logbrush.position() + LBHATCH, lbHatch);
    }

    public static int lbStyle(ByteBuffer logbrush) {
        return logbrush.getInt(logbrush.position() + LBSTYLE);
    }

    public static int lbColor(ByteBuffer logbrush) {
        return logbrush.getInt(logbrush.position() + LBCOLOR);
    }

    public static long lbHatch(ByteBuffer logbrush) {
        return PointerBuffer.get(logbrush, logbrush.position() + LBHATCH);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = LOGBRUSH.offsets(MemoryUtil.memAddress(offsets));
        LBSTYLE = offsets.get(0);
        LBCOLOR = offsets.get(1);
        LBHATCH = offsets.get(2);
    }
}

