/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;

public final class ARBSparseBuffer {
    public static final int GL_SPARSE_STORAGE_BIT_ARB = 1024;
    public static final int GL_SPARSE_BUFFER_PAGE_SIZE_ARB = 33528;
    public final long BufferPageCommitmentARB;
    public final long NamedBufferPageCommitmentEXT;
    public final long NamedBufferPageCommitmentARB;

    public ARBSparseBuffer(FunctionProvider provider) {
        this.BufferPageCommitmentARB = provider.getFunctionAddress("glBufferPageCommitmentARB");
        this.NamedBufferPageCommitmentEXT = provider.getFunctionAddress("glNamedBufferPageCommitmentEXT");
        this.NamedBufferPageCommitmentARB = provider.getFunctionAddress("glNamedBufferPageCommitmentARB");
    }

    public static ARBSparseBuffer getInstance() {
        return GL.getCapabilities().__ARBSparseBuffer;
    }

    static ARBSparseBuffer create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_sparse_buffer")) {
            return null;
        }
        ARBSparseBuffer funcs = new ARBSparseBuffer(provider);
        boolean supported = Checks.checkFunctions(funcs.BufferPageCommitmentARB, ext.contains("GL_EXT_direct_state_access") ? funcs.NamedBufferPageCommitmentEXT : -1L, ext.contains("GL_ARB_direct_state_access") ? funcs.NamedBufferPageCommitmentARB : -1L);
        return GL.checkExtension("GL_ARB_sparse_buffer", funcs, supported);
    }

    public static native void nglBufferPageCommitmentARB(int var0, long var1, long var3, boolean var5, long var6);

    public static void glBufferPageCommitmentARB(int target, long offset, long size, boolean commit) {
        long __functionAddress = ARBSparseBuffer.getInstance().BufferPageCommitmentARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBSparseBuffer.nglBufferPageCommitmentARB(target, offset, size, commit, __functionAddress);
    }

    public static native void nglNamedBufferPageCommitmentEXT(int var0, long var1, long var3, boolean var5, long var6);

    public static void glNamedBufferPageCommitmentEXT(int buffer, long offset, long size, boolean commit) {
        long __functionAddress = ARBSparseBuffer.getInstance().NamedBufferPageCommitmentEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBSparseBuffer.nglNamedBufferPageCommitmentEXT(buffer, offset, size, commit, __functionAddress);
    }

    public static native void nglNamedBufferPageCommitmentARB(int var0, long var1, long var3, boolean var5, long var6);

    public static void glNamedBufferPageCommitmentARB(int buffer, long offset, long size, boolean commit) {
        long __functionAddress = ARBSparseBuffer.getInstance().NamedBufferPageCommitmentARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBSparseBuffer.nglNamedBufferPageCommitmentARB(buffer, offset, size, commit, __functionAddress);
    }
}

