/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBShadingLanguageInclude {
    public static final int GL_SHADER_INCLUDE_ARB = 36270;
    public static final int GL_NAMED_STRING_LENGTH_ARB = 36329;
    public static final int GL_NAMED_STRING_TYPE_ARB = 36330;
    public final long NamedStringARB;
    public final long DeleteNamedStringARB;
    public final long CompileShaderIncludeARB;
    public final long IsNamedStringARB;
    public final long GetNamedStringARB;
    public final long GetNamedStringivARB;

    public ARBShadingLanguageInclude(FunctionProvider provider) {
        this.NamedStringARB = provider.getFunctionAddress("glNamedStringARB");
        this.DeleteNamedStringARB = provider.getFunctionAddress("glDeleteNamedStringARB");
        this.CompileShaderIncludeARB = provider.getFunctionAddress("glCompileShaderIncludeARB");
        this.IsNamedStringARB = provider.getFunctionAddress("glIsNamedStringARB");
        this.GetNamedStringARB = provider.getFunctionAddress("glGetNamedStringARB");
        this.GetNamedStringivARB = provider.getFunctionAddress("glGetNamedStringivARB");
    }

    public static ARBShadingLanguageInclude getInstance() {
        return GL.getCapabilities().__ARBShadingLanguageInclude;
    }

    static ARBShadingLanguageInclude create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_shading_language_include")) {
            return null;
        }
        ARBShadingLanguageInclude funcs = new ARBShadingLanguageInclude(provider);
        boolean supported = Checks.checkFunctions(funcs.NamedStringARB, funcs.DeleteNamedStringARB, funcs.CompileShaderIncludeARB, funcs.IsNamedStringARB, funcs.GetNamedStringARB, funcs.GetNamedStringivARB);
        return GL.checkExtension("GL_ARB_shading_language_include", funcs, supported);
    }

    public static native void nglNamedStringARB(int var0, int var1, long var2, int var4, long var5, long var7);

    public static void nglNamedStringARB(int type, int namelen, long name, int stringlen, long string) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().NamedStringARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShadingLanguageInclude.nglNamedStringARB(type, namelen, name, stringlen, string, __functionAddress);
    }

    public static void glNamedStringARB(int type, int namelen, ByteBuffer name, int stringlen, ByteBuffer string) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
            Checks.checkBuffer((Buffer)string, stringlen);
        }
        ARBShadingLanguageInclude.nglNamedStringARB(type, namelen, MemoryUtil.memAddress(name), stringlen, MemoryUtil.memAddress(string));
    }

    public static void glNamedStringARB(int type, ByteBuffer name, ByteBuffer string) {
        ARBShadingLanguageInclude.nglNamedStringARB(type, name.remaining(), MemoryUtil.memAddress(name), string.remaining(), MemoryUtil.memAddress(string));
    }

    public static void glNamedStringARB(int type, CharSequence name, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        int stringEncoded = __buffer.stringParamUTF8(string, false);
        int stringEncodedLen = __buffer.getOffset() - stringEncoded;
        ARBShadingLanguageInclude.nglNamedStringARB(type, nameEncodedLen, __buffer.address(nameEncoded), stringEncodedLen, __buffer.address(stringEncoded));
    }

    public static native void nglDeleteNamedStringARB(int var0, long var1, long var3);

    public static void nglDeleteNamedStringARB(int namelen, long name) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().DeleteNamedStringARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(namelen, name, __functionAddress);
    }

    public static void glDeleteNamedStringARB(int namelen, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
        }
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(namelen, MemoryUtil.memAddress(name));
    }

    public static void glDeleteNamedStringARB(ByteBuffer name) {
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name.remaining(), MemoryUtil.memAddress(name));
    }

    public static void glDeleteNamedStringARB(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded));
    }

    public static native void nglCompileShaderIncludeARB(int var0, int var1, long var2, long var4, long var6);

    public static void nglCompileShaderIncludeARB(int shader, int count, long path, long length) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().CompileShaderIncludeARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, count, path, length, __functionAddress);
    }

    public static void glCompileShaderIncludeARB(int shader, int count, ByteBuffer path, ByteBuffer length) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)path, count << Pointer.POINTER_SHIFT);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, count << 2);
            }
        }
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, count, MemoryUtil.memAddress(path), MemoryUtil.memAddressSafe(length));
    }

    public static void glCompileShaderIncludeARB(int shader, PointerBuffer path, IntBuffer length) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, path.remaining());
        }
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, path.remaining(), MemoryUtil.memAddress(path), MemoryUtil.memAddressSafe(length));
    }

    public static native boolean nglIsNamedStringARB(int var0, long var1, long var3);

    public static boolean nglIsNamedStringARB(int namelen, long name) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().IsNamedStringARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBShadingLanguageInclude.nglIsNamedStringARB(namelen, name, __functionAddress);
    }

    public static boolean glIsNamedStringARB(int namelen, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
        }
        return ARBShadingLanguageInclude.nglIsNamedStringARB(namelen, MemoryUtil.memAddress(name));
    }

    public static boolean glIsNamedStringARB(ByteBuffer name) {
        return ARBShadingLanguageInclude.nglIsNamedStringARB(name.remaining(), MemoryUtil.memAddress(name));
    }

    public static boolean glIsNamedStringARB(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        return ARBShadingLanguageInclude.nglIsNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded));
    }

    public static native void nglGetNamedStringARB(int var0, long var1, int var3, long var4, long var6, long var8);

    public static void nglGetNamedStringARB(int namelen, long name, int bufSize, long stringlen, long string) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().GetNamedStringARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShadingLanguageInclude.nglGetNamedStringARB(namelen, name, bufSize, stringlen, string, __functionAddress);
    }

    public static void glGetNamedStringARB(int namelen, ByteBuffer name, int bufSize, ByteBuffer stringlen, ByteBuffer string) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
            Checks.checkBuffer((Buffer)string, bufSize);
            if (stringlen != null) {
                Checks.checkBuffer((Buffer)stringlen, 4);
            }
        }
        ARBShadingLanguageInclude.nglGetNamedStringARB(namelen, MemoryUtil.memAddress(name), bufSize, MemoryUtil.memAddressSafe(stringlen), MemoryUtil.memAddress(string));
    }

    public static void glGetNamedStringARB(ByteBuffer name, IntBuffer stringlen, ByteBuffer string) {
        if (LWJGLUtil.CHECKS && stringlen != null) {
            Checks.checkBuffer((Buffer)stringlen, 1);
        }
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.remaining(), MemoryUtil.memAddress(name), string.remaining(), MemoryUtil.memAddressSafe(stringlen), MemoryUtil.memAddress(string));
    }

    public static void glGetNamedStringARB(CharSequence name, IntBuffer stringlen, ByteBuffer string) {
        if (LWJGLUtil.CHECKS && stringlen != null) {
            Checks.checkBuffer((Buffer)stringlen, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        ARBShadingLanguageInclude.nglGetNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded), string.remaining(), MemoryUtil.memAddressSafe(stringlen), MemoryUtil.memAddress(string));
    }

    public static String glGetNamedStringARB(CharSequence name, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        int stringlen = __buffer.intParam();
        int string = __buffer.bufferParam(bufSize);
        ARBShadingLanguageInclude.nglGetNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded), bufSize, __buffer.address(stringlen), __buffer.address(string));
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address(string), __buffer.intValue(stringlen)));
    }

    public static String glGetNamedStringARB(CharSequence name) {
        int bufSize = ARBShadingLanguageInclude.glGetNamedStringiARB(name, 36329);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        int stringlen = __buffer.intParam();
        int string = __buffer.bufferParam(bufSize);
        ARBShadingLanguageInclude.nglGetNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded), bufSize, __buffer.address(stringlen), __buffer.address(string));
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address(string), __buffer.intValue(stringlen)));
    }

    public static native void nglGetNamedStringivARB(int var0, long var1, int var3, long var4, long var6);

    public static void nglGetNamedStringivARB(int namelen, long name, int pname, long params) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().GetNamedStringivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShadingLanguageInclude.nglGetNamedStringivARB(namelen, name, pname, params, __functionAddress);
    }

    public static void glGetNamedStringivARB(int namelen, ByteBuffer name, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShadingLanguageInclude.nglGetNamedStringivARB(namelen, MemoryUtil.memAddress(name), pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedStringivARB(ByteBuffer name, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.remaining(), MemoryUtil.memAddress(name), pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedStringivARB(CharSequence name, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        ARBShadingLanguageInclude.nglGetNamedStringivARB(nameEncodedLen, __buffer.address(nameEncoded), pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedStringiARB(CharSequence name, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        int params = __buffer.intParam();
        ARBShadingLanguageInclude.nglGetNamedStringivARB(nameEncodedLen, __buffer.address(nameEncoded), pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

