/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Aircraft;
import game.GLSLFunctions;
import game.Track;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import org.lwjgl.glfw.GLFW;
import render.InputHandler;
import render.Renderer;
import render.Texture;
import sound.Sound;

public class Game {
    private Aircraft player;
    private Texture noiseP;
    private Track track = new Track();
    private volatile boolean exit = false;
    private Sound sound;
    private Renderer renderer;
    private long lastTimePlayed;
    static float LEN_TORUS = 350.0f;
    static float LEN_OBSTACLE = 500.0f;
    static float LEN_CAVE = 200.0f;
    static float LEN_CHEESE = 100.0f;
    static float LEN_NOISE_TUNNEL = 200.0f;
    static float LEN_MOD_BLOCKS = 300.0f;
    public static final float LEN_TOT = LEN_TORUS + LEN_OBSTACLE + LEN_CAVE + LEN_CHEESE + LEN_NOISE_TUNNEL + LEN_MOD_BLOCKS;

    public Game(Texture noiseP, long windowID, Sound sound, Renderer renderer) {
        this.noiseP = noiseP;
        this.sound = sound;
        this.renderer = renderer;
        this.player = new Aircraft(this, sound);
        sound.setMusic(Sound.AMBIENT);
    }

    public boolean update(long window, float tick) {
        this.pollInputs(window);
        boolean gameOver = this.player.update(tick);
        int num = 10;
        int i = 0;
        while (i < num) {
            this.player.updateSmallStep((float)num / 2.0f);
            this.collision(tick);
            ++i;
        }
        if (gameOver) {
            this.sound.play(Sound.POWER_DOWN);
            return true;
        }
        this.geiger();
        return false;
    }

    private void geiger() {
        float rd = this.getRadioDis();
        if ((float)(System.currentTimeMillis() - this.lastTimePlayed) > 100.0f + rd * rd / 200.0f) {
            this.sound.play(Sound.GEIGERS[(int)(Math.random() * (double)Sound.GEIGERS.length)]);
            this.lastTimePlayed = System.currentTimeMillis();
        }
    }

    private void pollInputs(long window) {
        if (InputHandler.down(256)) {
            GLFW.glfwSetWindowShouldClose(window, 1);
            this.exit = true;
        }
        if (InputHandler.pressed(80)) {
            Vector3f p = this.player.getPos();
            System.out.println("nodes.add(new Vector3f(" + p.x + "f ," + p.y + "f ," + p.z + "f ));");
        }
    }

    private Vector3f vadd(Vector3f a, Vector3f b) {
        Vector3f res = new Vector3f(a);
        res.add(b);
        return res;
    }

    private Vector3f vmod(Vector3f a, Vector3f b) {
        Vector3f res = new Vector3f(GLSLFunctions.mod(a.x, b.x), GLSLFunctions.mod(a.y, b.y), GLSLFunctions.mod(a.z, b.z));
        return res;
    }

    private Vector3f vmod(Vector3f a, float b) {
        Vector3f res = new Vector3f(GLSLFunctions.mod(a.x, b), GLSLFunctions.mod(a.y, b), GLSLFunctions.mod(a.z, b));
        return res;
    }

    private Vector3f vsub(Vector3f a, Vector3f b) {
        return new Vector3f(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private Vector3f vsub(Vector3f a, float b) {
        return new Vector3f(a.x - b, a.y - b, a.z - b);
    }

    private Vector3f vmul(Vector3f a, Vector3f b) {
        return new Vector3f(a.x * b.x, a.y * b.y, a.z * b.z);
    }

    private Vector3f vmul(Vector3f a, float f) {
        return new Vector3f(a.x * f, a.y * f, a.z * f);
    }

    private void collision(float tick) {
        float pr = 0.5f;
        Vector3f p = this.player.getPos();
        Vector3f s = new Vector3f(1.0f, 1.0f, 1.0f);
        int x = (int)GLSLFunctions.trunc(p.x / s.x);
        int y = (int)GLSLFunctions.trunc(p.y / s.y);
        int z = (int)GLSLFunctions.trunc(p.z / s.z);
        int numCollisions = 0;
        Vector3f normal = new Vector3f(0.0f, 0.0f, 0.0f);
        int nx = x - 1;
        while (nx <= x + 1) {
            int ny = y - 1;
            while (ny <= y + 1) {
                int nz = z - 1;
                while (nz <= z + 1) {
                    Vector3f q = new Vector3f(GLSLFunctions.mod(p.x, 1.0f), GLSLFunctions.mod(p.y, 1.0f), GLSLFunctions.mod(p.z, 1.0f));
                    q.sub(new Vector3f(0.5f, 0.5f, 0.5f));
                    q.sub(new Vector3f(nx - x, ny - y, nz - z));
                    float bdis = GLSLFunctions.sdBox(q, new Vector3f(0.5f, 0.5f, 0.5f));
                    float t = GLSLFunctions.trunc(GLSLFunctions.mod(nz, LEN_TOT));
                    if (nz <= 0) {
                        t = 0.0f;
                    }
                    if (t < LEN_TORUS) {
                        Vector3f ms = new Vector3f(200.0f, 40.0f, 200.0f);
                        float dis = -GLSLFunctions.sdTorus(this.vsub(this.vmod(this.vadd(new Vector3f(nx, ny, nz), new Vector3f(-13.0f, -21.0f, 37.0f)), ms), this.vmul(ms, 0.5f)), new Vector2f(100.0f, 15.0f));
                        if (dis < 0.0f && bdis < pr) {
                            ++numCollisions;
                            normal.x += (float)(nx - x);
                            normal.y += (float)(ny - y);
                            normal.z += (float)(nz - z);
                        }
                    } else if (t < LEN_TORUS + LEN_OBSTACLE) {
                        Vector3f np = new Vector3f((float)nx + GLSLFunctions.sin((double)nz * 0.01) * 35.0f + GLSLFunctions.sin((double)nz * 0.004) * 35.0f, ny, nz);
                        float res = -GLSLFunctions.sdBox(np, new Vector3f(12.0f + GLSLFunctions.sin((double)np.z * 0.008) * 3.0f, 12.0f + GLSLFunctions.sin((double)np.z * 0.005) * 3.0f, 40000.0f));
                        res = GLSLFunctions.min(res, GLSLFunctions.sdCylinder(new Vector3f(np.x, np.y, GLSLFunctions.mod(np.z, 200.0f) - 100.0f), new Vector3f(0.0f, 0.0f, 4.0f)));
                        res = GLSLFunctions.min(res, GLSLFunctions.sdCylinder(new Vector3f(np.y, np.z, GLSLFunctions.mod(np.z + 50.0f, 100.0f) - 50.0f), new Vector3f(0.0f, 0.0f, 4.0f)));
                        Vector3f hp = new Vector3f(np.x, np.y, GLSLFunctions.mod(np.z, 300.0f) - 150.0f);
                        if ((res = GLSLFunctions.min(res, GLSLFunctions.max(-GLSLFunctions.sdHexPrism(hp, new Vector2f(5.0f, 5.0f)), GLSLFunctions.sdBox(hp, new Vector3f(15.0f, 15.0f, 3.0f))))) < 0.0f && bdis < pr) {
                            ++numCollisions;
                            normal.x += (float)(nx - x);
                            normal.y += (float)(ny - y);
                            normal.z += (float)(nz - z);
                        }
                    } else if (t < LEN_TORUS + LEN_OBSTACLE + LEN_CAVE) {
                        Vector3f n = new Vector3f(nx, nz, ny);
                        float tex = GLSLFunctions.texture((Texture)this.noiseP, (Vector2f)new Vector2f((float)(n.x * 0.01f), (float)(n.y * 0.01f))).x;
                        if ((double)tex < 0.9 - (double)GLSLFunctions.abs(GLSLFunctions.sin((double)n.z * 0.1 + 1.0)) * 0.5 && bdis < pr) {
                            ++numCollisions;
                            normal.x += (float)(nx - x);
                            normal.y += (float)(ny - y);
                            normal.z += (float)(nz - z);
                        }
                    } else if (t < LEN_TORUS + LEN_OBSTACLE + LEN_CAVE + LEN_CHEESE) {
                        float modSize = 39.0f;
                        Vector3f mo = this.vsub(this.vmod(new Vector3f(nx, ny, nz), modSize), modSize * 0.5f);
                        float dis = GLSLFunctions.max(-GLSLFunctions.sphere(mo, 22.0f), GLSLFunctions.sdBox(mo, new Vector3f(20.0f, 20.0f, 20.0f)));
                        if (dis < 0.0f && bdis < pr) {
                            ++numCollisions;
                            normal.x += (float)(nx - x);
                            normal.y += (float)(ny - y);
                            normal.z += (float)(nz - z);
                        }
                    } else if (t < LEN_TORUS + LEN_OBSTACLE + LEN_CAVE + LEN_CHEESE + LEN_NOISE_TUNNEL) {
                        float tex = GLSLFunctions.texture((Texture)this.noiseP, (Vector2f)new Vector2f((float)((float)nx * 0.01f + GLSLFunctions.sin((float)((float)nz * 0.01f))), (float)((float)ny * 0.01f + GLSLFunctions.sin((float)((float)nz * 0.02f))))).x;
                        if ((double)tex > 0.6 && bdis < pr) {
                            ++numCollisions;
                            normal.x += (float)(nx - x);
                            normal.y += (float)(ny - y);
                            normal.z += (float)(nz - z);
                        }
                    } else {
                        boolean mo;
                        boolean bl = mo = GLSLFunctions.mod(GLSLFunctions.abs(nx), 6.0f) >= 3.0f && GLSLFunctions.mod(GLSLFunctions.abs(ny), 4.0f) >= 2.0f && GLSLFunctions.mod(GLSLFunctions.abs(nz), 7.0f) >= 4.0f;
                        if (mo && bdis < pr) {
                            ++numCollisions;
                            normal.x += (float)(nx - x);
                            normal.y += (float)(ny - y);
                            normal.z += (float)(nz - z);
                        }
                    }
                    ++nz;
                }
                ++ny;
            }
            ++nx;
        }
        if (numCollisions > 0) {
            if (normal.length() == 0.0f) {
                normal = this.getPlayer().getForward();
                normal.negate();
            }
            normal.normalize();
            this.player.collide(normal, tick);
        }
    }

    private void collision_old() {
        Vector3f p = this.player.getPos();
        Vector3f s = new Vector3f(1.0f, 1.0f, 1.0f);
        int nx = (int)GLSLFunctions.trunc(p.x / s.x);
        int ny = (int)GLSLFunctions.trunc(p.y / s.y);
        int nz = (int)GLSLFunctions.trunc(p.z / s.z);
        int numCollisions = 0;
        Vector3f normal = new Vector3f(0.0f, 0.0f, 0.0f);
        float collideDis = 0.0f;
        int x = nx - 1;
        while (x <= nx + 1) {
            int y = ny - 1;
            while (y <= ny + 1) {
                int z = nz - 1;
                while (z <= nz + 1) {
                    float pr = 0.6f;
                    Vector3f q = new Vector3f(GLSLFunctions.mod(p.x, 1.0f), GLSLFunctions.mod(p.y, 1.0f), GLSLFunctions.mod(p.z, 1.0f));
                    q.sub(new Vector3f(0.5f, 0.5f, 0.5f));
                    q.sub(new Vector3f(x - nx, y - ny, z - nz));
                    float dis = GLSLFunctions.sdBox(q, new Vector3f(0.5f, 0.5f, 0.5f));
                    int t = (int)GLSLFunctions.mod((300.0f + (float)x + (float)z + GLSLFunctions.cos((float)y * 1.0f)) * 0.01f, 4.0f);
                    if (t == 0) {
                        float tex = GLSLFunctions.mix(GLSLFunctions.texture((Texture)this.noiseP, (Vector2f)new Vector2f((float)((float)((double)x * 0.01 + (double)GLSLFunctions.sin((double)((double)nz * 0.001)) + (double)GLSLFunctions.sin((double)((double)z * 0.002)))), (float)((float)((double)y * 0.01)))).x, GLSLFunctions.texture((Texture)this.noiseP, (Vector2f)new Vector2f((float)((float)((double)x * 0.01)), (float)((float)((double)y * 0.01 + (double)GLSLFunctions.sin((double)((double)z * 0.001)) + (double)GLSLFunctions.sin((double)((double)z * 0.002)))))).x, 0.5f);
                        if ((double)tex < 0.6 - (double)GLSLFunctions.abs(GLSLFunctions.sin((double)z * 0.03)) * 0.3 && dis < pr) {
                            ++numCollisions;
                            normal.x += (float)(x - nx);
                            normal.y += (float)(y - ny);
                            normal.z += (float)(z - nz);
                            collideDis = pr - dis;
                        }
                    } else if (t == 1) {
                        float tdis = GLSLFunctions.sdTorus(new Vector3f(GLSLFunctions.mod(x, 100.0f) - 50.0f, GLSLFunctions.mod(y, 100.0f) - 50.0f, GLSLFunctions.mod(z, 100.0f) - 50.0f), new Vector2f(40.0f, 20.0f));
                        if (tdis > 0.0f && dis < pr) {
                            ++numCollisions;
                            normal.x += (float)(x - nx);
                            normal.y += (float)(y - ny);
                            normal.z += (float)(z - nz);
                            collideDis = pr - dis;
                        }
                    } else if (t == 2) {
                        float tex = GLSLFunctions.texture((Texture)this.noiseP, (Vector2f)new Vector2f((float)((float)((double)x * 0.01 + (double)GLSLFunctions.sin((double)((double)z * 0.01)))), (float)((float)((double)y * 0.01 + (double)GLSLFunctions.sin((double)((double)z * 0.02)))))).x;
                        if ((double)tex > 0.6 && dis < pr) {
                            ++numCollisions;
                            normal.x += (float)(x - nx);
                            normal.y += (float)(y - ny);
                            normal.z += (float)(z - nz);
                            collideDis = pr - dis;
                        }
                    } else if (t == 3) {
                        boolean mo;
                        boolean bl = mo = GLSLFunctions.mod(GLSLFunctions.abs(x), 6.0f) >= 3.0f && GLSLFunctions.mod(GLSLFunctions.abs(y), 4.0f) >= 2.0f && GLSLFunctions.mod(GLSLFunctions.abs(z), 7.0f) >= 4.0f;
                        if (mo && dis < pr) {
                            ++numCollisions;
                            normal.x += (float)(x - nx);
                            normal.y += (float)(y - ny);
                            normal.z += (float)(z - nz);
                            collideDis = pr - dis;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        if (numCollisions > 0) {
            if (normal.length() == 0.0f) {
                normal = this.getPlayer().getForward();
                normal.negate();
            }
            normal.normalize();
            this.player.collide(normal, -1337.0f);
        }
    }

    public Vector3f getPlayerPos() {
        return this.player.getPos();
    }

    public Aircraft getPlayer() {
        return this.player;
    }

    public Vector3f getNextNodePos() {
        return this.player.getNode();
    }

    public Track getTrack() {
        return this.track;
    }

    public static float distance(Vector3f a, Vector3f b) {
        Vector3f v = new Vector3f(a);
        v.sub(b);
        return v.length();
    }

    public float getPlayerSpeed() {
        return this.player.getSpeed();
    }

    public float getRadioDis() {
        Vector3f disv = new Vector3f(this.getPlayerPos());
        disv.sub(this.getNextNodePos());
        float dis = disv.length();
        return dis;
    }
}

