/*
 * Decompiled with CFR 0.152.
 */
import javafx.scene.Group;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Polygon;

public class RocketTower
extends GenericTower {
    private CubicCurveTo projectileTo = new CubicCurveTo();
    private int towerPrice = 150;
    private double projectileHeight = 400.0;

    public RocketTower(double _width) {
        this.range = 400.0;
        this.price = this.towerPrice;
        this.width = _width;
        this.body = new Group();
        this.groundPoly = this.getShape();
        this.body.getChildren().add((Object)this.groundPoly);
    }

    public RocketTower(double _x, double _y, double _width) {
        this.range = 400.0;
        this.price = this.towerPrice;
        this.width = _width;
        this.x = _x;
        this.y = _y;
        GenericTower.towers.add(this);
        this.body = new Group();
        this.groundPoly = this.getShape();
        this.projectilePath.getElements().add((Object)this.projectileFrom);
        this.projectilePath.getElements().add((Object)this.projectileTo);
        this.groundPoly.setLayoutX(0.0 - this.width);
        this.groundPoly.setLayoutY(0.0 - this.width);
        this.groundPoly.setFill((Paint)Color.BLACK);
        this.groundPoly.setStroke((Paint)Color.YELLOW);
        this.groundPoly.setStrokeWidth(2.0);
        DropShadow outerGlow = new DropShadow();
        outerGlow.setOffsetX(0.0);
        outerGlow.setOffsetY(0.0);
        outerGlow.setRadius(20.0);
        outerGlow.setColor(Color.YELLOW);
        this.groundPoly.setEffect((Effect)outerGlow);
        this.body.getChildren().add((Object)this.groundPoly);
        this.body.setLayoutX(this.x);
        this.body.setLayoutY(this.y);
        this.projectileFrom.setX(this.x);
        this.projectileFrom.setY(this.y);
        this.projectileTo.setX(this.x);
        this.projectileTo.setY(this.y);
        this.projectileTo.setControlX1(this.x);
        this.projectileTo.setControlY1(this.y);
        this.projectileTo.setControlX2(this.x);
        this.projectileTo.setControlY2(this.y);
        this.rangeCircle = new Circle(this.x, this.y, this.range);
        this.body.getTransforms().add((Object)this.rotation);
        this.rangeCircle.setFill((Paint)Color.WHITE);
        this.rangeCircle.setOpacity(0.0);
    }

    @Override
    public Polygon getShape() {
        Polygon poly = new Polygon();
        poly.getPoints().addAll((Object[])new Double[]{this.width, this.width * 2.0, 0.0, this.width, this.width, 0.0, this.width * 2.0, this.width});
        poly.setLayoutX(0.0 - this.width);
        poly.setLayoutY(0.0 - this.width);
        return poly;
    }

    @Override
    public void rotate(double monsterX, double monsterY) {
        this.projectileTo.setX(monsterX);
        this.projectileTo.setY(monsterY);
        this.projectileTo.setControlX1(this.x);
        this.projectileTo.setControlY1(this.y - this.projectileHeight);
        this.projectileTo.setControlX2(monsterX);
        this.projectileTo.setControlY2(monsterY - this.projectileHeight);
    }

    @Override
    public void shoot(GenericMonster m) {
        if (this.hasAmmo) {
            double endX = this.projectileTo.getX();
            double endY = this.projectileTo.getY();
            new RocketProjectile(this, m, endX, endY);
        }
    }
}

