/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.PathTransition;
import javafx.animation.PauseTransition;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class RocketProjectile
extends GenericProjectile {
    private Polygon bullet;
    private int range = 100;

    public RocketProjectile(GenericTower t, GenericMonster m, double endX, double endY) {
        this.damage = 75;
        this.hitTime = 2000;
        this.reloadTime = 0;
        this.fromTower = t;
        t.setHasAmmo(false);
        GenericProjectile.projectiles.add(this);
        Defence.projectileGroup.getChildren().add((Object)this.body);
        this.bullet = new Polygon();
        this.bullet.getPoints().addAll((Object[])new Double[]{0.0, 0.0, 0.0, 10.0, 10.0, 5.0});
        this.bullet.setFill((Paint)Color.YELLOW);
        this.body.getChildren().add((Object)this.bullet);
        this.pt = new PathTransition();
        this.pt.setDuration(Duration.millis((double)this.hitTime));
        this.pt.setNode((Node)this.body);
        this.pt.setInterpolator(Interpolator.EASE_IN);
        this.pt.setPath((Shape)this.fromTower.getProjectilePath());
        this.pt.setOrientation(PathTransition.OrientationType.ORTHOGONAL_TO_TANGENT);
        this.pt.play();
        this.pt.setOnFinished(e -> {
            Circle hitRange = new Circle(endX, endY, (double)this.range);
            hitRange.setFill((Paint)Color.YELLOW);
            hitRange.setOpacity(0.2);
            Defence.projectileHitGroup.getChildren().add((Object)hitRange);
            FadeTransition ft = new FadeTransition();
            ft.setNode((Node)hitRange);
            ft.setDuration(Duration.millis((double)500.0));
            ft.setFromValue(0.25);
            ft.setToValue(0.0);
            ft.play();
            ArrayList<GenericMonster> monstersInRange = new ArrayList<GenericMonster>();
            for (GenericMonster monster : GenericMonster.monsters) {
                Shape mtIntersect = Shape.intersect((Shape)hitRange, (Shape)monster.getBody());
                if (mtIntersect.getBoundsInLocal().getWidth() == -1.0) continue;
                monstersInRange.add(monster);
            }
            for (GenericMonster mir : monstersInRange) {
                mir.damage(this.damage);
            }
            projectiles.remove(this);
            Defence.projectileGroup.getChildren().remove((Object)this.body);
            PauseTransition pause = new PauseTransition();
            pause.setDuration(Duration.millis((double)this.reloadTime));
            pause.setOnFinished(ep -> t.setHasAmmo(true));
            pause.play();
        });
    }
}

