/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Defence
extends Application {
    private Group root = new Group();
    private Group paths = new Group();
    private Group mouseGroup = new Group();
    private Group towerGroup = new Group();
    private Group towerRangeGroup = new Group();
    private Group menuGroup = new Group();
    private Group timerGroup = new Group();
    private Group timerBoxGroup = new Group();
    private Group waveGroup = new Group();
    private HBox buttonContainer = new HBox(10.0);
    private Group deadGroup = new Group();
    public static Group monsterGroup = new Group();
    public static Group healthBarGroup = new Group();
    public static Group projectileGroup = new Group();
    public static Group projectileHitGroup = new Group();
    public static Group rewardGroup = new Group();
    public static Font baseFont = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)20.0);
    public static Font menuFont = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)14.0);
    public static Font timerFont = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)80.0);
    private Scene scene;
    private int updatesPerSecond = 30;
    private double width = 1600.0;
    private double height = 900.0;
    private int pathWidth = 50;
    private int mouseWidth = 30;
    private int spawnAmount = 50;
    private int bigMonsterFrequency = 10;
    private int spawnInterval = 900;
    private double mouseOpacity = 0.5;
    public static String valuta = "kr";
    public static int cash = 600;
    public static Text cashText = new Text();
    public static int lives = 10;
    public static Text livesText = new Text();
    public static Text waveText = new Text();
    public Text deathText = new Text();
    GenericTower selectedTower;
    private Path monsterPath = new Path();
    private List<PathElement> pathElements = new ArrayList<PathElement>();
    private Circle mouseCircle = new Circle();
    private static double mouseX = 0.0;
    private static double mouseY = 0.0;
    private boolean canPlaceTower = false;
    private boolean displayMouseCircle = true;
    private boolean showTowerRange = false;
    private boolean showDescription = false;
    private boolean waveStarted = false;
    public static boolean isDead = false;
    private int secCounter = 0;
    private int frameCounter = 0;
    private int secToSpawn = 21;
    private double timerWidth = 250.0;
    private double timerHeight = 300.0;
    private double timerMargin = 20.0;
    private double timerRadius = 100.0;
    private Text timerText = new Text("Click this box to begin.");
    private Text timerCricleText = new Text(String.valueOf(this.secToSpawn));
    private VBox timerTextBox = new VBox();
    private VBox timerGroupBox = new VBox();
    VBox timerBox = new VBox();
    Rectangle timerClickBox = new Rectangle();
    private int waveCounter = 0;
    private int totalWaves = 5;
    private boolean lastSpawn = false;
    private VBox descriptionBox = new VBox();
    private Text descriptionText = new Text();
    private int descriptionWidth = 400;
    private int descriptionHeight = 80;
    Timer timer = new Timer();

    public static void main(String[] args) {
        Defence.launch((String[])args);
    }

    public void start(Stage stage) {
        stage.setTitle("Birdie TowerDefence 360\u00b0 NoScope");
        this.descriptionBox.getChildren().add((Object)this.descriptionText);
        Rectangle background = new Rectangle(0.0, 0.0, this.width, this.height);
        background.setFill((Paint)Color.BLACK);
        this.getMouseCircle();
        this.mouseGroup.getChildren().add((Object)this.mouseCircle);
        this.mouseCircle.setOpacity(this.mouseOpacity);
        this.getPath();
        this.monsterPath.getElements().addAll(this.pathElements);
        this.monsterPath.setStrokeWidth((double)this.pathWidth);
        this.monsterPath.setStroke((Paint)Color.color((double)0.1, (double)0.0, (double)0.2));
        this.monsterPath.setStrokeLineCap(StrokeLineCap.SQUARE);
        this.monsterPath.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        DropShadow outerGlow = new DropShadow();
        outerGlow.setOffsetX(0.0);
        outerGlow.setOffsetY(0.0);
        outerGlow.setRadius(40.0);
        outerGlow.setColor(Color.color((double)0.05, (double)0.0, (double)0.1));
        this.monsterPath.setEffect((Effect)outerGlow);
        this.initTimerBox();
        this.initCashAndLives();
        this.paths.getChildren().add((Object)this.monsterPath);
        this.root.getChildren().addAll((Object[])new Node[]{background, this.paths, this.towerRangeGroup, this.towerGroup, projectileGroup, this.mouseGroup, monsterGroup, healthBarGroup, projectileHitGroup, rewardGroup, this.menuGroup, this.timerBoxGroup, this.waveGroup, this.deadGroup, this.buttonContainer});
        this.scene = new Scene((Parent)this.root, this.width, this.height);
        this.scene.setOnMouseClicked(e -> {
            if (this.canPlaceTower) {
                this.showMenu(e.getSceneX(), e.getSceneY());
            }
            if (this.selectedTower != null) {
                if (!this.selectedTower.getShowRange()) {
                    this.selectedTower.getRangeCircle().setOpacity(0.1);
                    this.selectedTower.setShowRange(true);
                } else {
                    this.selectedTower.getRangeCircle().setOpacity(0.0);
                    this.selectedTower.setShowRange(false);
                }
            }
            this.canPlaceTower = false;
        });
        this.scene.setOnMouseMoved(e -> {
            mouseX = e.getSceneX();
            mouseY = e.getSceneY();
            if (this.displayMouseCircle) {
                this.getMouseCircle();
                Shape shape = Shape.intersect((Shape)this.monsterPath, (Shape)this.mouseCircle);
                boolean intersectsPath = shape.getBoundsInLocal().getWidth() != -1.0;
                Shape shape2 = Shape.intersect((Shape)this.timerClickBox, (Shape)this.mouseCircle);
                boolean intersectsTimer = shape2.getBoundsInLocal().getWidth() != -1.0;
                boolean intersectsTower = true;
                if (GenericTower.towers.size() > 0) {
                    for (GenericTower t : GenericTower.towers) {
                        Shape towerShape = Shape.intersect((Shape)((Shape)t.getBody().getChildren().get(0)), (Shape)this.mouseCircle);
                        intersectsTower = towerShape.getBoundsInLocal().getWidth() != -1.0;
                        if (!intersectsTower) continue;
                        this.selectedTower = t;
                        break;
                    }
                } else {
                    intersectsTower = false;
                }
                if (intersectsTower) {
                    this.mouseCircle.setFill((Paint)Color.PURPLE);
                    this.canPlaceTower = false;
                } else {
                    this.selectedTower = null;
                    if (!intersectsPath && !intersectsTimer) {
                        this.mouseCircle.setFill((Paint)Color.LIGHTGREEN);
                        this.canPlaceTower = true;
                    } else {
                        this.mouseCircle.setFill((Paint)Color.DEEPPINK);
                        this.canPlaceTower = false;
                    }
                }
            }
        });
        this.scene.setCursor(Cursor.NONE);
        stage.setScene(this.scene);
        stage.show();
        stage.setOnCloseRequest(e -> this.timer.cancel());
        this.animate();
    }

    private void initCashAndLives() {
        cashText.setFont(baseFont);
        cashText.setFill((Paint)Color.GREENYELLOW);
        cashText.setText(cash + " " + valuta);
        Text cashTextDesc = new Text("Cash:");
        cashTextDesc.setFont(baseFont);
        cashTextDesc.setFill((Paint)Color.WHITE);
        livesText.setFont(baseFont);
        livesText.setFill((Paint)Color.ORANGERED);
        livesText.setText(String.valueOf(lives));
        Text livesTextDesc = new Text("Lives:");
        livesTextDesc.setFont(baseFont);
        livesTextDesc.setFill((Paint)Color.WHITE);
        waveText.setFont(baseFont);
        waveText.setFill((Paint)Color.YELLOW);
        waveText.setText(this.waveCounter + "/" + this.totalWaves);
        Text waveTextDesc = new Text("Wave:");
        waveTextDesc.setFont(baseFont);
        waveTextDesc.setFill((Paint)Color.WHITE);
        this.buttonContainer = new HBox(10.0);
        this.buttonContainer.setCursor(Cursor.DEFAULT);
        this.buttonContainer.setPrefSize(this.width, 40.0);
        this.buttonContainer.setStyle("-fx-padding:10px; -fx-background-color: #110022;");
        this.buttonContainer.getChildren().addAll((Object[])new Node[]{cashTextDesc, cashText, waveTextDesc, waveText, livesTextDesc, livesText});
    }

    private void initTimerBox() {
        this.timerBox.setLayoutX(this.width - (this.timerWidth + this.timerMargin));
        this.timerBox.setLayoutY(this.height - (this.timerHeight + this.timerMargin));
        this.timerBox.setPrefSize(this.timerWidth, this.timerHeight);
        DropShadow outerGlow = new DropShadow();
        outerGlow.setOffsetX(0.0);
        outerGlow.setOffsetY(0.0);
        outerGlow.setRadius(20.0);
        outerGlow.setColor(Color.PURPLE);
        this.timerBox.setEffect((Effect)outerGlow);
        this.timerClickBox.setLayoutX(this.width - (this.timerWidth + this.timerMargin));
        this.timerClickBox.setLayoutY(this.height - (this.timerHeight + this.timerMargin));
        this.timerClickBox.setWidth(this.timerWidth);
        this.timerClickBox.setHeight(this.timerHeight);
        this.timerClickBox.setFill((Paint)Color.TRANSPARENT);
        this.timerClickBox.setCursor(Cursor.HAND);
        this.timerClickBox.setOnMouseClicked(e -> this.endTimer());
        this.timerText.setFont(baseFont);
        this.timerText.setTextAlignment(TextAlignment.CENTER);
        this.timerText.setFill((Paint)Color.WHITE);
        VBox timerCircleBox = new VBox();
        timerCircleBox.setPrefSize(this.timerRadius * 2.0, this.timerRadius * 2.0);
        timerCircleBox.setLayoutX(-this.timerRadius);
        timerCircleBox.setLayoutY(-this.timerRadius);
        timerCircleBox.setAlignment(Pos.CENTER);
        timerCircleBox.getChildren().add((Object)this.timerCricleText);
        double textHeight = this.timerHeight - this.timerWidth;
        this.timerTextBox.setAlignment(Pos.CENTER);
        this.timerTextBox.setPrefSize(this.timerWidth, textHeight);
        this.timerTextBox.getChildren().add((Object)this.timerText);
        this.timerCricleText.setFont(timerFont);
        this.timerCricleText.setFill((Paint)Color.BLACK);
        this.timerCricleText.setStroke((Paint)Color.PURPLE);
        this.timerCricleText.setStrokeWidth(2.0);
        DropShadow outerGlow2 = new DropShadow();
        outerGlow2.setOffsetX(0.0);
        outerGlow2.setOffsetY(0.0);
        outerGlow2.setRadius(20.0);
        outerGlow2.setColor(Color.WHITE);
        this.timerCricleText.setEffect((Effect)outerGlow2);
        Circle timerCircle = new Circle(0.0, 0.0, this.timerRadius, (Paint)Color.MEDIUMPURPLE);
        this.timerGroup.getChildren().addAll((Object[])new Node[]{timerCircle, timerCircleBox});
        this.timerGroupBox.setAlignment(Pos.CENTER);
        this.timerGroupBox.setPrefSize(250.0, 250.0);
        this.timerGroupBox.getChildren().add((Object)this.timerGroup);
    }

    private void showTimer() {
        if (!this.waveStarted) {
            double centerX = 0.0;
            double centerY = 0.0;
            this.timerBox.getChildren().clear();
            this.timerBoxGroup.getChildren().clear();
            this.timerBox.setStyle("-fx-background-radius: 10px;-fx-border-radius: 10px;-fx-background-color: #110033;-fx-border-style: solid;-fx-border-width: 2px;-fx-border-color: #9900FF");
            this.timerBox.getChildren().addAll((Object[])new Node[]{this.timerGroupBox, this.timerTextBox});
            this.timerBoxGroup.getChildren().addAll((Object[])new Node[]{this.timerBox, this.timerClickBox});
            double rotationPrSec = 360 / this.updatesPerSecond;
            for (int i = 0; i < this.updatesPerSecond; ++i) {
                double theta = Math.toRadians((double)i * rotationPrSec - 90.0);
                double nodeX = this.timerRadius * Math.cos(theta) + centerX;
                double nodeY = this.timerRadius * Math.sin(theta) + centerY;
                Circle nodeC = new Circle(nodeX, nodeY, 10.0, (Paint)Color.BLACK);
                nodeC.setOpacity(0.0);
                nodeC.setFill((Paint)Color.PURPLE);
                this.timerGroup.getChildren().add((Object)nodeC);
                this.animateTimer((Node)nodeC, i);
            }
        }
    }

    private void animateTimer(Node node, int i) {
        FadeTransition ft = new FadeTransition();
        ft.setNode(node);
        ft.setDuration(Duration.millis((double)100.0));
        ft.setDelay(Duration.millis((double)(i * (500 / this.updatesPerSecond))));
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.play();
        FadeTransition ft2 = new FadeTransition();
        ft2.setNode(node);
        ft2.setDuration(Duration.millis((double)100.0));
        ft2.setDelay(Duration.millis((double)(500 + i * (500 / this.updatesPerSecond))));
        ft2.setFromValue(1.0);
        ft2.setToValue(0.0);
        ft2.play();
    }

    private void placeTower(GenericTower tower) {
        cashText.setText((cash -= tower.getPrice()) + " " + valuta);
        this.towerGroup.getChildren().add((Object)tower.getBody());
        this.towerRangeGroup.getChildren().add((Object)tower.getRangeCircle());
    }

    private void showMenu(double x, double y) {
        int menuWidth = 30;
        int expand = 5;
        int menuDur = 200;
        Circle c = new Circle(x, y, (double)menuWidth, (Paint)Color.PURPLE);
        c.setOpacity(0.6);
        this.scene.setCursor(Cursor.DEFAULT);
        Circle towerRange = new Circle(x, y, (double)this.mouseWidth);
        towerRange.setFill((Paint)Color.TRANSPARENT);
        towerRange.setStroke((Paint)Color.WHITE);
        towerRange.setStrokeWidth(2.0);
        this.menuGroup.getChildren().add((Object)towerRange);
        this.displayMouseCircle = false;
        ScaleTransition st = new ScaleTransition();
        st.setNode((Node)c);
        st.setDuration(Duration.millis((double)menuDur));
        st.setByX((double)expand);
        st.setByY((double)expand);
        st.play();
        Rectangle background = new Rectangle(this.width, this.height);
        background.setFill((Paint)Color.BLACK);
        background.setOpacity(0.0);
        background.setOnMouseClicked(e -> this.closeMenu());
        this.menuGroup.getChildren().addAll((Object[])new Node[]{background, c});
        double dispWidth = (double)this.mouseWidth * 1.5;
        ArrayList<GenericTower> towers = new ArrayList<GenericTower>();
        towers.add(new QuickTower(this.mouseWidth));
        towers.add(new RocketTower(this.mouseWidth));
        towers.add(new MultiTower(this.mouseWidth));
        towers.add(new SniperTower(this.mouseWidth));
        for (int i = 0; i < towers.size() + 1; ++i) {
            GenericTower t;
            int nodeDelay = menuDur / 2 + i * 100;
            Group dispGroup = new Group();
            VBox priceBox = new VBox();
            priceBox.setPrefSize(dispWidth, dispWidth);
            priceBox.setAlignment(Pos.CENTER);
            priceBox.setLayoutX(-dispWidth / 2.0);
            priceBox.setLayoutY(-dispWidth / 2.0);
            Text priceText = new Text();
            priceText.setTextAlignment(TextAlignment.CENTER);
            priceText.setFont(menuFont);
            priceText.setFill((Paint)Color.WHITE);
            dispGroup.setOpacity(0.0);
            dispGroup.setCursor(Cursor.HAND);
            double theta = Math.toRadians((double)i * dispWidth - 90.0);
            double dispX = ((double)(menuWidth * expand) - dispWidth / 2.0) * Math.cos(theta) + x;
            double dispY = ((double)(menuWidth * expand) - dispWidth / 2.0) * Math.sin(theta) + y;
            FadeTransition dispFT = new FadeTransition();
            dispFT.setNode((Node)dispGroup);
            dispFT.setFromValue(0.0);
            dispFT.setToValue(1.0);
            dispFT.setDuration(Duration.millis((double)((double)menuDur / 1.5)));
            dispFT.setDelay(Duration.millis((double)nodeDelay));
            if (i == towers.size()) {
                dispFT.setOnFinished(e -> {
                    this.showTowerRange = true;
                });
            }
            dispFT.play();
            ScaleTransition dispST = new ScaleTransition();
            dispST.setNode((Node)dispGroup);
            dispST.setFromX(0.5);
            dispST.setFromY(0.5);
            dispST.setToX(1.0);
            dispST.setToY(1.0);
            dispST.setDuration(Duration.millis((double)((double)menuDur / 1.5)));
            dispST.setDelay(Duration.millis((double)nodeDelay));
            dispST.play();
            TranslateTransition tt = new TranslateTransition();
            tt.setNode((Node)dispGroup);
            tt.setFromX(x);
            tt.setFromY(y);
            tt.setToX(dispX);
            tt.setToY(dispY);
            tt.setDuration(Duration.millis((double)((double)menuDur / 1.5)));
            tt.setDelay(Duration.millis((double)nodeDelay));
            tt.play();
            Circle backCircle = new Circle(0.0, 0.0, dispWidth);
            String towerName = "";
            switch (i) {
                case 0: {
                    t = (GenericTower)towers.get(i);
                    towerName = "Quick";
                    backCircle.setOnMouseClicked(e -> {
                        if (t.getPrice() <= cash) {
                            this.placeTower(new QuickTower(x, y, this.mouseWidth));
                        }
                        this.closeMenu();
                    });
                    backCircle.setOnMouseMoved(e -> this.showDescription(e.getSceneX(), e.getSceneY(), "Regular all-purpose tower\nRange: " + t.getRange()));
                    break;
                }
                case 1: {
                    t = (GenericTower)towers.get(i);
                    towerName = "Rocket";
                    backCircle.setOnMouseClicked(e -> {
                        if (t.getPrice() <= cash) {
                            this.placeTower(new RocketTower(x, y, this.mouseWidth));
                        }
                        this.closeMenu();
                    });
                    backCircle.setOnMouseMoved(e -> this.showDescription(e.getSceneX(), e.getSceneY(), "Slow shooting tower with area damage\nRange: " + t.getRange()));
                    break;
                }
                case 2: {
                    t = (GenericTower)towers.get(i);
                    towerName = "Multi";
                    backCircle.setOnMouseClicked(e -> {
                        if (t.getPrice() <= cash) {
                            this.placeTower(new MultiTower(x, y, this.mouseWidth));
                        }
                        this.closeMenu();
                    });
                    backCircle.setOnMouseMoved(e -> this.showDescription(e.getSceneX(), e.getSceneY(), "Shoots at multiple monsters at the same time\nRange: " + t.getRange()));
                    break;
                }
                case 3: {
                    t = (GenericTower)towers.get(i);
                    towerName = "Sniper";
                    backCircle.setOnMouseClicked(e -> {
                        if (t.getPrice() <= cash) {
                            this.placeTower(new SniperTower(x, y, this.mouseWidth));
                        }
                        this.closeMenu();
                    });
                    backCircle.setOnMouseMoved(e -> this.showDescription(e.getSceneX(), e.getSceneY(), "Focuses mainly on big monsters\nRange: " + t.getRange()));
                    break;
                }
                default: {
                    t = null;
                    backCircle.setOnMouseClicked(e -> this.closeMenu());
                }
            }
            if (t != null) {
                backCircle.setOnMouseEntered(e -> {
                    if (this.showTowerRange) {
                        towerRange.setRadius(t.getRange());
                        this.showDescription = true;
                        this.menuGroup.getChildren().add((Object)this.descriptionBox);
                    }
                });
                backCircle.setOnMouseExited(e -> {
                    if (this.showTowerRange) {
                        towerRange.setRadius((double)this.mouseWidth);
                        this.showDescription = false;
                        this.menuGroup.getChildren().remove((Object)this.descriptionBox);
                    }
                });
                if (t.getPrice() > cash) {
                    backCircle.setFill((Paint)Color.RED);
                    priceText.setFill((Paint)Color.RED);
                } else {
                    backCircle.setFill((Paint)Color.BLACK);
                }
                priceText.setText(towerName + "\n" + t.getPrice() + " " + valuta);
                priceBox.getChildren().add((Object)priceText);
            } else {
                priceText.setText("Cancel");
                priceBox.getChildren().add((Object)priceText);
            }
            backCircle.setOpacity(0.25);
            if (t != null) {
                Group dispBody = t.getBody();
                dispBody.setPickOnBounds(false);
                dispGroup.getChildren().add((Object)dispBody);
            }
            dispGroup.getChildren().add((Object)priceBox);
            dispGroup.getChildren().addAll((Object[])new Node[]{backCircle});
            this.menuGroup.getChildren().add((Object)dispGroup);
        }
    }

    private void showDescription(double x, double y, String description) {
        if (this.showDescription) {
            this.descriptionBox.setPrefSize((double)this.descriptionWidth, (double)this.descriptionHeight);
            this.descriptionBox.setLayoutX(x - (double)this.descriptionWidth * 0.5);
            this.descriptionBox.setLayoutY(y - (double)(this.descriptionHeight + 50));
            this.descriptionBox.setAlignment(Pos.CENTER);
            this.descriptionBox.setStyle("-fx-background-color: purple; -fx-background-radius: 10px;-fx-border-color: black; -fx-border-radius: 10px; -fx-border-width: 2px; -fx-border-style: solid;");
            this.descriptionText.setText(description);
            this.descriptionText.setFill((Paint)Color.WHITE);
            this.descriptionText.setFont(menuFont);
            this.descriptionText.setTextAlignment(TextAlignment.CENTER);
        }
    }

    private void closeMenu() {
        this.showTowerRange = false;
        this.menuGroup.getChildren().clear();
        this.scene.setCursor(Cursor.NONE);
        this.mouseCircle.setOpacity(this.mouseOpacity);
        this.getMouseCircle();
        this.displayMouseCircle = true;
    }

    private void animate() {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> Defence.this.frame());
            }
        }, 0L, (long)(1000 / this.updatesPerSecond));
    }

    private void endTimer() {
        if (!this.waveStarted) {
            this.spawnMonsters(1);
            this.timerBoxGroup.getChildren().clear();
            this.timerClickBox.setWidth(0.0);
            this.waveStarted = true;
        }
    }

    private void frame() {
        if (lives > 0) {
            ++this.frameCounter;
            if (this.frameCounter % this.updatesPerSecond == 0) {
                ++this.secCounter;
                this.showTimer();
                this.timerCricleText.setText(String.valueOf(this.secToSpawn - this.secCounter));
                if (this.secCounter == this.secToSpawn) {
                    this.endTimer();
                }
            }
            for (GenericTower t : GenericTower.towers) {
                Circle range = t.getRangeCircle();
                List<GenericMonster> monstersInRange = t.getMonstersInRange();
                for (GenericMonster m : GenericMonster.monsters) {
                    Shape body = m.getBody();
                    Shape mtIntersect = Shape.intersect((Shape)range, (Shape)body);
                    if (mtIntersect.getBoundsInLocal().getWidth() != -1.0) {
                        if (monstersInRange.contains(m)) continue;
                        monstersInRange.add(m);
                        continue;
                    }
                    if (!monstersInRange.contains(m)) continue;
                    monstersInRange.remove(m);
                }
                t.handleMonsters();
            }
            if (this.lastSpawn && GenericMonster.monsters.size() < 1) {
                this.showWin();
            }
        } else {
            this.showDeath();
        }
    }

    private void spawnMonsters(int wave) {
        switch (wave) {
            case 1: {
                for (int i = 0; i <= this.spawnAmount; ++i) {
                    PauseTransition pause = new PauseTransition();
                    pause.setDuration(Duration.millis((double)(this.spawnInterval * i)));
                    if (isDead) continue;
                    if (i % this.bigMonsterFrequency == this.bigMonsterFrequency - 1) {
                        pause.setOnFinished(ep -> new BigMonster(this.monsterPath));
                    } else {
                        pause.setOnFinished(ep -> new NormalMonster(this.monsterPath));
                    }
                    pause.play();
                    if (i != this.spawnAmount) continue;
                    pause.setOnFinished(e -> this.spawnMonsters(2));
                }
                break;
            }
            case 2: {
                for (int i = 0; i <= this.spawnAmount; ++i) {
                    PauseTransition pause = new PauseTransition();
                    pause.setDuration(Duration.millis((double)(this.spawnInterval * i)));
                    if (isDead) continue;
                    if (i % this.bigMonsterFrequency == this.bigMonsterFrequency - 1) {
                        pause.setOnFinished(ep -> new BigMonster2(this.monsterPath));
                    } else {
                        pause.setOnFinished(ep -> new NormalMonster2(this.monsterPath));
                    }
                    pause.play();
                    if (i != this.spawnAmount) continue;
                    pause.setOnFinished(e -> this.spawnMonsters(3));
                }
                break;
            }
            case 3: {
                for (int i = 0; i <= this.spawnAmount; ++i) {
                    PauseTransition pause = new PauseTransition();
                    pause.setDuration(Duration.millis((double)(this.spawnInterval * i)));
                    if (isDead) continue;
                    if (i % this.bigMonsterFrequency == this.bigMonsterFrequency - 1) {
                        pause.setOnFinished(ep -> new BigMonster3(this.monsterPath));
                    } else {
                        pause.setOnFinished(ep -> new NormalMonster3(this.monsterPath));
                    }
                    pause.play();
                    if (i != this.spawnAmount) continue;
                    pause.setOnFinished(e -> this.spawnMonsters(4));
                }
                break;
            }
            case 4: {
                for (int i = 0; i <= this.spawnAmount; ++i) {
                    PauseTransition pause = new PauseTransition();
                    pause.setDuration(Duration.millis((double)(this.spawnInterval * i)));
                    if (isDead) continue;
                    if (i % this.bigMonsterFrequency == this.bigMonsterFrequency - 1) {
                        pause.setOnFinished(ep -> new BigMonster4(this.monsterPath));
                    } else {
                        pause.setOnFinished(ep -> new NormalMonster4(this.monsterPath));
                    }
                    pause.play();
                    if (i != this.spawnAmount) continue;
                    pause.setOnFinished(e -> this.spawnMonsters(5));
                }
                break;
            }
            case 5: {
                for (int i = 0; i <= this.spawnAmount; ++i) {
                    PauseTransition pause = new PauseTransition();
                    pause.setDuration(Duration.millis((double)(this.spawnInterval * i)));
                    if (isDead) continue;
                    if (i % this.bigMonsterFrequency == this.bigMonsterFrequency - 1) {
                        pause.setOnFinished(ep -> new BigMonster5(this.monsterPath));
                    } else {
                        pause.setOnFinished(ep -> new NormalMonster5(this.monsterPath));
                    }
                    pause.play();
                    if (i != this.spawnAmount) continue;
                    pause.setOnFinished(e -> {
                        this.lastSpawn = true;
                    });
                }
                break;
            }
        }
        this.showWave(wave);
        this.waveCounter = wave;
        waveText.setText(this.waveCounter + "/" + this.totalWaves);
    }

    private void getMouseCircle() {
        this.mouseCircle.setRadius((double)this.mouseWidth);
        this.mouseCircle.setCenterX(mouseX);
        this.mouseCircle.setCenterY(mouseY);
    }

    private void getPath() {
        this.pathElements.add((PathElement)new MoveTo(100.0, 100.0));
        this.pathElements.add((PathElement)new LineTo(100.0, 500.0));
        this.pathElements.add((PathElement)new LineTo(300.0, 500.0));
        this.pathElements.add((PathElement)new LineTo(300.0, 800.0));
        this.pathElements.add((PathElement)new LineTo(500.0, 800.0));
        this.pathElements.add((PathElement)new LineTo(500.0, 300.0));
        this.pathElements.add((PathElement)new LineTo(300.0, 300.0));
        this.pathElements.add((PathElement)new LineTo(300.0, 100.0));
        this.pathElements.add((PathElement)new LineTo(1100.0, 100.0));
        this.pathElements.add((PathElement)new LineTo(1100.0, 300.0));
        this.pathElements.add((PathElement)new LineTo(700.0, 300.0));
        this.pathElements.add((PathElement)new LineTo(700.0, 700.0));
        this.pathElements.add((PathElement)new LineTo(900.0, 700.0));
        this.pathElements.add((PathElement)new LineTo(900.0, 500.0));
        this.pathElements.add((PathElement)new LineTo(1300.0, 500.0));
        this.pathElements.add((PathElement)new LineTo(1300.0, 100.0));
        this.pathElements.add((PathElement)new LineTo(1500.0, 100.0));
        this.pathElements.add((PathElement)new LineTo(1500.0, 800.0));
    }

    private void showDeath() {
        if (!isDead) {
            isDead = true;
            this.displayMouseCircle = false;
            this.canPlaceTower = false;
            this.waveStarted = false;
            Rectangle back = new Rectangle(this.width, this.height);
            back.setFill((Paint)Color.BLACK);
            this.deadGroup.setCursor(Cursor.HAND);
            VBox textBox = new VBox();
            textBox.setAlignment(Pos.CENTER);
            textBox.setPrefSize(this.width, this.height);
            this.deathText = new Text("YOU ARE D\u00d6D!\nClick anywhere to restart");
            this.deathText.setTextAlignment(TextAlignment.CENTER);
            this.deathText.setFont(timerFont);
            this.deathText.setFill((Paint)Color.color((double)0.2, (double)0.0, (double)0.0));
            this.deathText.setStroke((Paint)Color.RED);
            this.deathText.setStrokeWidth(2.0);
            this.deathText.setStrokeLineJoin(StrokeLineJoin.ROUND);
            DropShadow outerGlow = new DropShadow();
            outerGlow.setOffsetX(0.0);
            outerGlow.setOffsetY(0.0);
            outerGlow.setRadius(20.0);
            outerGlow.setColor(Color.RED);
            this.deathText.setEffect((Effect)outerGlow);
            textBox.getChildren().add((Object)this.deathText);
            this.deadGroup.getChildren().addAll((Object[])new Node[]{back, textBox});
            this.deadGroup.setOnMouseClicked(e -> this.restart());
        }
    }

    private void showWin() {
        if (!isDead) {
            isDead = true;
            this.displayMouseCircle = false;
            this.canPlaceTower = false;
            this.waveStarted = false;
            Rectangle back = new Rectangle(this.width, this.height);
            back.setFill((Paint)Color.BLACK);
            this.deadGroup.setCursor(Cursor.HAND);
            VBox textBox = new VBox();
            textBox.setAlignment(Pos.CENTER);
            textBox.setPrefSize(this.width, this.height);
            this.deathText = new Text("YOU ARE WIN!\nClick anywhere to restart");
            this.deathText.setTextAlignment(TextAlignment.CENTER);
            this.deathText.setFont(timerFont);
            this.deathText.setFill((Paint)Color.color((double)0.2, (double)0.0, (double)0.1));
            this.deathText.setStroke((Paint)Color.DEEPPINK);
            this.deathText.setStrokeWidth(2.0);
            this.deathText.setStrokeLineJoin(StrokeLineJoin.ROUND);
            DropShadow outerGlow = new DropShadow();
            outerGlow.setOffsetX(0.0);
            outerGlow.setOffsetY(0.0);
            outerGlow.setRadius(20.0);
            outerGlow.setColor(Color.DEEPPINK);
            this.deathText.setEffect((Effect)outerGlow);
            textBox.getChildren().add((Object)this.deathText);
            this.deadGroup.getChildren().addAll((Object[])new Node[]{back, textBox});
            this.deadGroup.setOnMouseClicked(e -> this.restart());
        }
    }

    private void showWave(int i) {
        int waveTime = 2000;
        int fadeTime = 400;
        VBox waveContainer = new VBox();
        waveContainer.setPickOnBounds(false);
        waveContainer.setPrefSize(this.width, this.height);
        waveContainer.setAlignment(Pos.CENTER);
        Text waveText = new Text("Wave " + i);
        waveText.setFont(baseFont);
        waveText.setFill((Paint)Color.DEEPPINK);
        waveText.setOpacity(0.0);
        DropShadow outerGlow = new DropShadow();
        outerGlow.setOffsetX(0.0);
        outerGlow.setOffsetY(0.0);
        outerGlow.setRadius(10.0);
        outerGlow.setColor(Color.BLACK);
        waveText.setEffect((Effect)outerGlow);
        FadeTransition ft = new FadeTransition();
        ft.setNode((Node)waveText);
        ft.setDuration(Duration.millis((double)fadeTime));
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.play();
        FadeTransition ft2 = new FadeTransition();
        ft2.setNode((Node)waveText);
        ft2.setDuration(Duration.millis((double)fadeTime));
        ft2.setDelay(Duration.millis((double)(waveTime - fadeTime)));
        ft2.setFromValue(1.0);
        ft2.setToValue(0.0);
        ft2.play();
        ScaleTransition st = new ScaleTransition();
        st.setNode((Node)waveText);
        st.setDuration(Duration.millis((double)waveTime));
        st.setByX(10.0);
        st.setByY(10.0);
        st.play();
        st.setOnFinished(e -> this.waveGroup.getChildren().clear());
        waveContainer.getChildren().add((Object)waveText);
        this.waveGroup.getChildren().add((Object)waveContainer);
    }

    private void restart() {
        this.deathText.setText("lol, not really\nrestart the program to try again.");
    }
}

