/*
 * Decompiled with CFR 0.152.
 */
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;

public class SniperTower
extends GenericTower {
    private LineTo projectileTo = new LineTo();
    private Polygon groundPoly = new Polygon();
    private int towerPrice = 120;

    public SniperTower(double _width) {
        this.range = 500.0;
        this.price = this.towerPrice;
        this.width = _width;
        this.body = new Group();
        this.groundPoly = this.getShape();
        this.body.getChildren().add((Object)this.groundPoly);
    }

    public SniperTower(double _x, double _y, double _width) {
        this.range = 500.0;
        this.price = this.towerPrice;
        this.width = _width;
        this.x = _x;
        this.y = _y;
        GenericTower.towers.add(this);
        this.body = new Group();
        this.groundPoly = this.getShape();
        this.projectilePath.getElements().add((Object)this.projectileFrom);
        this.projectilePath.getElements().add((Object)this.projectileTo);
        this.groundPoly.setLayoutX(0.0 - this.width);
        this.groundPoly.setLayoutY(0.0 - this.width);
        this.groundPoly.setFill((Paint)Color.BLACK);
        this.groundPoly.setStroke((Paint)Color.LIMEGREEN);
        this.groundPoly.setStrokeWidth(2.0);
        DropShadow outerGlow = new DropShadow();
        outerGlow.setOffsetX(0.0);
        outerGlow.setOffsetY(0.0);
        outerGlow.setRadius(20.0);
        outerGlow.setColor(Color.LIMEGREEN);
        this.groundPoly.setEffect((Effect)outerGlow);
        this.body.getChildren().add((Object)this.groundPoly);
        this.body.setLayoutX(this.x);
        this.body.setLayoutY(this.y);
        this.projectileFrom.setX(this.x);
        this.projectileFrom.setY(this.y);
        this.projectileTo.setX(this.x);
        this.projectileTo.setY(this.y);
        this.rangeCircle = new Circle(this.x, this.y, this.range);
        this.body.getTransforms().add((Object)this.rotation);
        this.rangeCircle.setFill((Paint)Color.WHITE);
        this.rangeCircle.setOpacity(0.0);
    }

    @Override
    public Polygon getShape() {
        Polygon poly = new Polygon();
        poly.getPoints().addAll((Object[])new Double[]{0.0, this.width * 2.0, this.width * 2.0, this.width * 2.0, this.width, 0.0});
        poly.setLayoutX(0.0 - this.width);
        poly.setLayoutY(0.0 - this.width);
        return poly;
    }

    @Override
    public void rotate(double monsterX, double monsterY) {
        double rot = Math.toDegrees(Math.atan2(this.y - monsterY, this.x - monsterX));
        this.rotation.setAngle(rot - 90.0);
        this.projectileTo.setX(monsterX);
        this.projectileTo.setY(monsterY);
    }

    @Override
    public void shoot(GenericMonster m) {
        if (this.hasAmmo) {
            new SniperProjectile(this, m);
        }
    }

    @Override
    public void handleMonsters() {
        if (this.monstersInRange.size() > 0) {
            GenericMonster firstMonsterInSight = null;
            boolean biggieFound = false;
            for (GenericMonster m : this.monstersInRange) {
                if (m.getClass() != BigMonster.class && m.getClass() != BigMonster2.class && m.getClass() != BigMonster3.class && m.getClass() != BigMonster4.class && m.getClass() != BigMonster5.class) continue;
                biggieFound = true;
                firstMonsterInSight = m;
                break;
            }
            if (!biggieFound) {
                firstMonsterInSight = (GenericMonster)this.monstersInRange.get(0);
            }
            Shape monsterBody = firstMonsterInSight.getBody();
            Bounds monsterBounds = monsterBody.localToScene(monsterBody.getBoundsInLocal());
            double monsterX = monsterBounds.getMinX() + monsterBounds.getWidth() * 0.5;
            double monsterY = monsterBounds.getMinY() + monsterBounds.getHeight() * 0.5;
            this.rotate(monsterX, monsterY);
            this.shoot(firstMonsterInSight);
        }
    }
}

