/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.PathTransition;
import javafx.animation.TranslateTransition;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import javafx.util.Duration;

public abstract class GenericMonster {
    public static List<GenericMonster> monsters = new ArrayList<GenericMonster>();
    protected static int idCounter = 0;
    protected int id;
    protected double width;
    protected Group body = new Group();
    protected Rectangle healthBar;
    protected Rectangle healthBarFrame;
    protected int healthBarHeight = 7;
    protected int healthBarOffTop = 25 - this.healthBarHeight;
    protected Path path;
    protected FadeTransition ft;
    protected PathTransition pt;
    protected int initHealth;
    protected int health;
    protected int reward;
    protected int fadeTime = 300;
    protected int pathTime = 50000;
    protected double realX;
    protected double realY;
    protected int rewardPaneWidth = 100;
    protected int rewardTime = 1000;
    protected int livesCost;
    protected boolean dead = false;
    protected DropShadow outerGlow = new DropShadow();

    protected void initHealthBar() {
        this.healthBar = new Rectangle(this.width, (double)this.healthBarHeight);
        this.healthBar.setFill((Paint)Color.color((double)0.0, (double)1.0, (double)0.0));
        this.healthBarFrame = new Rectangle(this.width, (double)this.healthBarHeight);
        this.healthBarFrame.setFill((Paint)Color.BLACK);
        this.healthBarFrame.setStroke((Paint)Color.BLACK);
        this.healthBarFrame.setStrokeWidth(2.0);
        this.healthBar.setOpacity(0.0);
        this.healthBarFrame.setOpacity(0.0);
        Defence.healthBarGroup.getChildren().add((Object)this.healthBarFrame);
        Defence.healthBarGroup.getChildren().add((Object)this.healthBar);
    }

    protected void moveHealthBar() {
        this.healthBar.setX(this.realX - this.width * 0.5);
        this.healthBar.setY(this.realY - this.width * 0.5 - (double)this.healthBarOffTop);
        this.healthBarFrame.setX(this.realX - this.width * 0.5);
        this.healthBarFrame.setY(this.realY - this.width * 0.5 - (double)this.healthBarOffTop);
    }

    protected void moveAlongPath() {
        this.ft = new FadeTransition();
        this.ft.setDuration(Duration.millis((double)this.fadeTime));
        this.ft.setNode((Node)this.body);
        this.ft.setFromValue(0.0);
        this.ft.setToValue(1.0);
        this.ft.play();
        this.pt = new PathTransition();
        this.pt.setDuration(Duration.millis((double)this.pathTime));
        this.pt.setNode((Node)this.body);
        this.pt.setPath((Shape)this.path);
        this.pt.setInterpolator(Interpolator.LINEAR);
        this.pt.setOrientation(PathTransition.OrientationType.ORTHOGONAL_TO_TANGENT);
        this.pt.play();
        this.pt.setOnFinished(e -> {
            if (!Defence.isDead) {
                Defence.livesText.setText(String.valueOf(Defence.lives -= this.livesCost));
            }
            this.kill();
        });
    }

    public void damage(int damage) {
        this.health -= damage;
        if (!this.dead) {
            if (this.health < 1) {
                this.dead = true;
                this.kill();
                this.showReward();
            } else {
                double r;
                double g;
                double pct = (double)this.health / (double)this.initHealth;
                double pow = 1.0 - pct;
                if (pow < 0.5) {
                    g = 1.0;
                    r = 2.0 * pow;
                } else {
                    r = 1.0;
                    g = 1.0 - 2.0 * (pow - 0.5);
                }
                Color c = Color.color((double)r, (double)g, (double)0.0);
                this.healthBar.setWidth(this.width * pct);
                this.healthBar.setFill((Paint)c);
            }
        }
    }

    protected void kill() {
        for (GenericTower t : GenericTower.towers) {
            if (!t.getMonstersInRange().contains(this)) continue;
            t.getMonstersInRange().remove(this);
        }
        this.removeHealthBar();
        monsters.remove(this);
        this.pt.stop();
        this.ft.stop();
        this.ft = new FadeTransition();
        this.ft.setDuration(Duration.millis((double)this.fadeTime));
        this.ft.setNode((Node)this.body);
        this.ft.setFromValue(1.0);
        this.ft.setToValue(0.0);
        this.ft.play();
        this.ft.setOnFinished(e -> this.removeMonster());
    }

    protected void showHealthBar() {
        this.healthBarFrame.setOpacity(1.0);
        this.healthBar.setOpacity(1.0);
    }

    protected void showReward() {
        double x = this.realX - (double)this.rewardPaneWidth * 0.5;
        double y = this.realY - (double)this.rewardPaneWidth * 0.5;
        HBox rewardPane = new HBox();
        rewardPane.setLayoutX(x);
        rewardPane.setLayoutY(y);
        rewardPane.setAlignment(Pos.CENTER);
        rewardPane.setPrefSize((double)this.rewardPaneWidth, (double)this.rewardPaneWidth);
        Text rewardText = new Text("+" + this.reward);
        rewardText.setStyle("-fx-stroke:black; -fx-stroke-width:1px;");
        rewardText.setFill((Paint)Color.GOLD);
        rewardText.setFont(Defence.baseFont);
        rewardPane.getChildren().add((Object)rewardText);
        Defence.rewardGroup.getChildren().add((Object)rewardPane);
        TranslateTransition tt = new TranslateTransition();
        tt.setNode((Node)rewardPane);
        tt.setDuration(Duration.millis((double)this.rewardTime));
        tt.setByX(0.0);
        tt.setByY(-100.0);
        tt.play();
        FadeTransition ft = new FadeTransition();
        ft.setNode((Node)rewardPane);
        ft.setDuration(Duration.millis((double)this.rewardTime));
        ft.setFromValue(1.0);
        ft.setToValue(0.0);
        ft.setOnFinished(e -> Defence.rewardGroup.getChildren().remove((Object)rewardPane));
        ft.play();
        Defence.cashText.setText((Defence.cash += this.reward) + " " + Defence.valuta);
    }

    protected void removeMonster() {
        Defence.monsterGroup.getChildren().remove((Object)this.body);
    }

    protected void removeHealthBar() {
        Defence.healthBarGroup.getChildren().remove((Object)this.healthBar);
        Defence.healthBarGroup.getChildren().remove((Object)this.healthBarFrame);
    }

    public Shape getBody() {
        return (Shape)this.body.getChildren().get(0);
    }

    public String toString() {
        return "#" + this.id;
    }
}

